%define origname tftp

Name: inquisitor-tftpd
Version: 0.48
Release: alt1.qa1

Summary: The server for the Trivial File Transfer Protocol (TFTP)
License: BSD
Group: System/Servers

Url: http://www.kernel.org/pub/software/network/tftp/
Source0: http://www.kernel.org/pub/software/network/tftp/tftp-hpa-%version.tar.gz
Source1: tftp.xinetd
Patch: tftp-hpa-0.48-inquisitor.patch
Patch1: tftp-0.28-malta.patch
Patch2: tftp-hpa-0.36-bcopy.patch
Packager: Michael Shigorin <mike@altlinux.org>

PreReq: shadow-utils
Requires: xinetd
Conflicts: tftpd tftp-server tftp-server-xinetd

# Automatically added by buildreq on Fri Apr 23 2004
BuildRequires: libreadline-devel libwrap-devel

%description
The Trivial File Transfer Protocol (TFTP) is normally used
for booting diskless systems.

This package includes only server side patched to please Inquisitor.

%prep
%setup -n tftp-hpa-%version
%patch0 -p1
%patch2 -p1

%build
%configure
subst '
    s,^CC=.*$,CC=cc,;
    s,^BINDIR=.*$,BINDIR=%_bindir,;
    s,^MANDIR=.*$,MANDIR=%_mandir,;
    s,^SBINDIR=.*$,SBINDIR=%_sbindir,;
    ' MCONFIG
%make_build

%install
mkdir -p %buildroot{%_bindir,%_sbindir,%_mandir/man{1,8},%_localstatedir/tftpboot}
%make_install install INSTALLROOT=%buildroot
ln -s in.tftpd %buildroot%_sbindir/tftpd
install -pDm640 %SOURCE1 %buildroot%_sysconfdir/xinetd.d/%origname

%post
%_sbindir/groupadd -rf %origname ||:
%_sbindir/useradd -r -g %origname -d /dev/null -s /dev/null -n %origname &>/dev/null ||:

%files
%config(noreplace) %_sysconfdir/xinetd.d/%origname
%_sbindir/*
%_man8dir/*
%dir %_localstatedir/tftpboot

%changelog
