Name: installer
Version: 1.8.31
Release: alt1

Summary: Installer common parts
License: GPLv2+
Group: System/Configuration/Other

Url: http://www.altlinux.org/Installer
Source: %name-%version.tar

BuildRequires: glibc-devel-static

%description
This package contains common installer parts.

%package common-stage2
Summary: Installer common stage2
Group: System/Configuration/Other
Provides: %name-stage2 = %version-%release
Obsoletes: %name-stage2 < %version-%release
# installer-preinstall.desktop
Requires: alterator-preinstall >= 0.7-alt1
# scripts/install2
Requires: alterator-wizardface alterator-backend-x11 >= 0.21-alt2 xinit xinitrc xorg-server xorg-drv-video
# scripts/postinstall
Requires: eject
# initinstall.d/10-vt.sh
Requires: bash console-vt-tools

Provides: installer-feature-autohostname
Obsoletes: installer-feature-autohostname
Provides: installer-feature-autohostname-stage2
Obsoletes: installer-feature-autohostname-stage2

Provides: installer-feature-cmdline-parameters-stage2
Obsoletes: installer-feature-cmdline-parameters-stage2

Provides: installer-feature-services
Obsoletes: installer-feature-services

Provides: installer-feature-copy-udev-rules-stage3
Obsoletes: installer-feature-copy-udev-rules-stage3
Requires: udev-rule-generator


Provides: installer-feature-systemd
Obsoletes: installer-feature-systemd

Provides: installer-feature-setup-network-stage2
Obsoletes: installer-feature-setup-network-stage2
Requires: hostinfo iproute2

Provides: installer-feature-setup-bootloader-stage2
Obsoletes: installer-feature-setup-bootloader-stage2

Requires: xorg-xvfb

# needed for lvm binary, see 11-remount.sh
Requires: libdevmapper-event

Conflicts: alterator-pkg < 1.2-alt1, alterator-sysconfig < 0.6-alt1, alterator-datetime < 2.0-alt1
# stage2 and stage3 are mutually exclusive
Conflicts: %name-common-stage3

%description common-stage2
This package contains common installer stage2 files and dependencies.

%package common-stage3
Summary: Installer common stage3
Group: System/Configuration/Other
BuildArch: noarch
Provides: %name-stage3 = %version-%release
Obsoletes: %name-stage3 < %version-%release
Requires: alterator-wizardface alterator-notes
# stage2 and stage3 are mutually exclusive
Conflicts: %name-common-stage2

Provides: installer-feature-eth-by-mac-stage3
Obsoletes: installer-feature-eth-by-mac-stage3

Provides: installer-feature-setup-network-stage3
Obsoletes: installer-feature-setup-network-stage3
Requires: alterator-net-eth chkconfig etcnet

%description common-stage3
This package contains common installer stage3 files and dependencies.

%prep
%setup

%build
%make_build

%install
%makeinstall
mkdir -p %buildroot%_sysconfdir/apt/apt.conf.d/
cat > %buildroot%_sysconfdir/apt/apt.conf.d/installer-cache-limit.conf <<@@@
APT::Cache-Limit "$((32*1024*1024))";
@@@

%files common-stage2
%_bindir/*
%_sbindir/*
%_datadir/install2
%_sysconfdir/apt/apt.conf.d/installer-cache-limit.conf
%exclude %_datadir/install2/preinstall.d/30-setup-network.sh

%files common-stage3
%_datadir/install2/preinstall.d/30-setup-network.sh

%changelog
