
Name: instead
Version: 1.9.0
Release: alt1
Group: Games/Adventure
License: GPLv2
Summary: STEAD text adventures/visual novels engine
Summary(ru_RU.UTF-8): Интерпретатор текстовых приключение и визуальных новелл STEAD
Url: http://instead.googlecode.com
Source: %{name}_%version.tar.gz
Patch: %name-1.7.0-Rules.make.system.patch

# Automatically added by buildreq on Wed Sep 08 2010
BuildRequires: ImageMagick-tools libSDL_image-devel libSDL_mixer-devel libSDL_ttf-devel liblua5-devel libncurses-devel libreadline-devel zlib-devel

%description
INSTEAD was designed to interpret the games that are the mix of visual novels,
text quests and classical 90'ss quests.

%description -l ru_RU.UTF-8
Интерпретатор STEAD (Simple Text Adventure) позволяет проигрывать игры, которые
по жанру являются смесью визуальной новеллы, текстового квеста и классических
квестов 90-х. Особенности STEAD игры:

    * очень простой исходный текст историй. (В качестве основы используется LUA);
    * возможность использования графического или текстового (readline) интерфейса для игры;
    * в графическом интерфейсе поддерживается музыка и графика;
    * поддержка тем для графического интерпретатора -- конкретная игра может менять вид интерфейса;
    * переносимость (изначально написана для Linux, зависит от SDL и lua).

%package sdl
Group: Games/Adventure
License: GPLv2
Summary: STEAD text adventures/visual novels GUI engine
Summary(ru_RU.UTF-8): Графический интерпретатор текстовых приключение и визуальных новелл STEAD
Requires: %name = %version-%release
Obsoletes: %name < %version-%release

%description sdl
This is GUI version of %name, text adventures/visual novels engine

%description sdl -l ru_RU.UTF-8
GUI-версия интерпретатора текстовых приключение и визуальных новелл STEAD

%prep
%setup
%patch -p2
cat > subst <<@@@
sed -i --follow-symlinks -e '\${x;s/./&/;x;t;q 1};'"\$1"';T;x;s/.*/./;x' "\$2"
@@@
chmod +x subst

./subst s/[.]png$// desktop/instead.desktop.in
ln -sf Rules.make.system Rules.make
for N in 16 32 48 64 128; do convert -resize ${N}x${N} icon/sdl_%name.png ${N}x${N}.png; done
./subst 's@char \*games_sw = NULL@char *games_sw = "%_localstatedir/%name/games"@' src/sdl-instead/main.c
./subst 's@src/sdl-instead@src/instead src/sdl-instead@' Makefile
sed -i '/LN/{h;d};${x;s/./&/;x;t;q 1}' src/sdl-instead/Makefile
echo "2
/usr" | ./configure.sh

%build
%make_build EXTRA_LDFLAGS=-lm

%install
%makeinstall DESTDIR=%buildroot
for N in 16 32 48 64 128; do install -pD ${N}x${N}.png %buildroot/%_iconsdir/hicolor/${N}x${N}/apps/sdl_%name.png; done
mkdir -p %buildroot%_localstatedir/%name/games

%files
%doc %_defaultdocdir/%name
%dir %_datadir/%name
%dir %attr(1775,root,games) %_localstatedir/%name/games
%_datadir/%name/*
%_man6dir/*
%_bindir/%name

%files sdl
%_bindir/sdl-%name
%_iconsdir/hicolor/*/apps/sdl_%name.png
%_pixmapsdir/*
%_desktopdir/%name.desktop

%changelog
