Name: ipmiutil
Version: 2.8.3
Release: alt1

Summary: IPMI server management utilities
License: BSD
Group: System/Kernel and hardware

Url: http://ipmiutil.sf.net
Source: http://prdownloads.sf.net/ipmiutil/%name-%version.tar.gz

# Automatically added by buildreq on Sat Oct 08 2011
# optimized out: libstdc++-devel
BuildRequires: gcc-c++ libssl-devel

%description
The ipmiutil component package provides utilities to view the SEL
(showsel), perform a hardware reset (hwreset), set up the BMC LAN
and Platform Event Filter entry to allow SNMP alerts (pefconfig),
and other IPMI tasks.  These can be invoked with the metacommand,
ipmiutil, as well.  Man pages are provided.

An IPMI driver can be provided by either the Intel IPMI driver
(/dev/imb) or the OpenIPMI driver (/dev/ipmi0).  If used locally
and no driver is detected, ipmiutil will use user-space register
I/Os instead.

%package cronjob
Summary: A periodic job to syslog and clear SEL records
Group: Monitoring
BuildArch: noarch

%description cronjob
This package contains a daily cron script which runs ipmiutil sel,
writing any new records to syslog, and will then clear the SEL
if free space is low.

The IPMI SEL should not normally be cleared, because the history
of the events is important, but if the IPMI SEL fills up, no new
events are logged, so saving the previous SEL events and clearing
the SEL must be done occasionally, as needed.

%prep
%setup

%build
%configure
#make_build
# SMP incompatible build, see #27254
make

%install
%makeinstall_std
install -pDm755 scripts/checksel %buildroot%_sysconfdir/cron.daily/checksel

%files
%_bindir/*
%_sbindir/*
%_datadir/%name/
%_man8dir/*

%files cronjob
%_sysconfdir/cron.daily/checksel

%changelog
