Name: iptables
Version: 1.4.21
Release: alt2.M70P.1

Summary: Tools for managing Linux kernel packet filtering capabilities
License: GPLv2+
Group: System/Kernel and hardware
Url: http://www.netfilter.org/projects/iptables/

# git://git.netfilter.org/iptables
# git://git.altlinux.org/gears/i/iptables
Source: %name-%version-%release.tar

Requires: lib%name = %version-%release

# for nfbpf_compile
BuildRequires: libpcap-devel
# for nfnl_osf
BuildRequires: libnfnetlink-devel
# for libxt_connlabel
BuildRequires: libnetfilter_conntrack-devel

%def_disable static

%description
iptables is used to set up, maintain, and inspect the tables of IP
packet filter rules in the Linux kernel.  Several different tables may
be defined.  Each table contains a number of built-in chains and may
also contain user-defined chains.

Each chain is a list of rules which can match a set of packets.
Each rule specifies what to do with a packet that matches.  This is
called a `target', which may be a jump to a user-defined chain in
the same table.

%package ipv6
Summary: IPv6 support for iptables
Group: System/Kernel and hardware
Requires: %name = %version-%release
BuildArch: noarch

%description ipv6
Ip6tables is used to set up, maintain, and inspect the tables of IPv6
packet filter rules in the Linux kernel.  Several different tables may
be defined.  Each table contains a number of built-in chains and may
also contain user-defined chains.

Each chain is a list of rules which can match a set of packets.
Each rule specifies what to do with a packet that matches.  This is
called a `target', which may be a jump to a user-defined chain in
the same table.

%package -n lib%name
Summary: iptables shared libraries
Group: Development/C
# lib%name was introduced since 1.4.13.
Conflicts: %name < 1.4.13

%description -n lib%name
iptables is used to set up, maintain, and inspect the tables of IP
packet filter rules in the Linux kernel.

This package contains libip4tc, libip6tc and libxtables shared libraries.

%package -n lib%name-devel
Summary: iptables development files
Group: Development/C
Requires: lib%name = %version-%release
Provides: %name-devel = %version-%release
Obsoletes: %name-devel < %version-%release

%description -n lib%name-devel
iptables is used to set up, maintain, and inspect the tables of IP
packet filter rules in the Linux kernel.

This package contains development files required to build software that
operates with netfilter.

%package -n lib%name-devel-static
Summary: iptables static development files
Group: Development/C
Requires: lib%name-devel = %version-%release
Provides: %name-devel-static = %version-%release
Obsoletes: %name-devel-static < %version-%release

%description -n lib%name-devel-static
iptables is used to set up, maintain, and inspect the tables of IP
packet filter rules in the Linux kernel.

This package contains static library required to build software that
operates with netfilter.

%prep
%setup -n %name-%version-%release
sed s/NFPROTO_IPV4/NFPROTO_IPV6/ extensions/libipt_NETFLOW.c \
	> extensions/libip6t_NETFLOW.c

%build
%add_optflags -fno-strict-aliasing
%autoreconf
%configure \
	%{subst_enable static} \
	--enable-bpf-compiler \
	--disable-libipq \
	--sbindir=/sbin \
	--with-xtlibdir=/%_lib/iptables \
	#

%make_build V=1

%install
%makeinstall_std

# convert an absolute symlink into relative
ln -snf ../../sbin/xtables-multi %buildroot%_bindir/iptables-xml

mkdir -p %buildroot/%_lib
# Relocate shared libraries from %_libdir/ to /%_lib/.
for f in %buildroot%_libdir/lib*.so; do
	t=`objdump -p "$f" |awk '/SONAME/ {print $2}'`
	[ -n "$t" ]
	ln -snf ../../%_lib/"$t" "$f"
done
mv %buildroot%_libdir/lib*.so.* %buildroot/%_lib/

output_format=$(%__cc $CFLAGS $LDFLAGS -shared -xc /dev/null -o/dev/null -Wl,--verbose -v 2>&1 |
		sed -n -f output-format.sed)
cat >%buildroot%_libdir/libiptc.so <<EOF
/* GNU ld script */

/* Ensure this .so library will not be used by a link
   for a different format on a multi-architecture system.  */
   $output_format

   GROUP ( AS_NEEDED ( -lip4tc -lip6tc ) )
EOF

install -pDm644 iptables/iptables.xslt %buildroot%_datadir/iptables/iptables.xslt

# Install ip*tables.h header files.
mkdir -p %buildroot%_includedir/iptables
install -pm644 include/ip*tables.h %buildroot%_includedir/
install -pm644 include/iptables/internal.h %buildroot%_includedir/iptables/

# Install startup scripts and associated config files.
install -pDm755 iptables.init %buildroot%_initdir/iptables
cp -p %buildroot%_initdir/ip{,6}tables
sed -i 's/iptables/ip6tables/g;s/IPv4/IPv6/g' %buildroot%_initdir/ip6tables

install -pDm644 iptables.service %buildroot%_unitdir/iptables.service
cp -p %buildroot%_unitdir/ip{,6}tables.service
sed -i 's/iptables/ip6tables/g;s/IPv4/IPv6/g' %buildroot%_unitdir/ip6tables.service

install -pDm600 iptables_params %buildroot%_sysconfdir/sysconfig/iptables_params
cp -p %buildroot%_sysconfdir/sysconfig/ip{,6}tables_params
sed -i s/iptables/ip6tables/g %buildroot%_sysconfdir/sysconfig/ip6tables_params

install -pDm600 iptables_data %buildroot%_sysconfdir/sysconfig/iptables
cp -p %buildroot%_sysconfdir/sysconfig/ip{,6}tables
sed -i s/iptables/ip6tables/g %buildroot%_sysconfdir/sysconfig/ip6tables

install -pDm600 iptables_modules %buildroot%_sysconfdir/sysconfig/iptables_modules
cp -p %buildroot%_sysconfdir/sysconfig/ip{,6}tables_modules
sed -i s/iptables/ip6tables/g %buildroot%_sysconfdir/sysconfig/ip6tables_modules

find %buildroot -name 'lib*.la' -delete

%set_verify_elf_method strict

%post
if [ $1 -eq 1 ]; then
	/sbin/chkconfig --add iptables
fi

%preun
if [ $1 -eq 0 ]; then
	/sbin/chkconfig --del iptables
fi

%post ipv6
if [ $1 -eq 1 ]; then
	/sbin/chkconfig --add ip6tables
fi

%preun ipv6
if [ $1 -eq 0 ]; then
	/sbin/chkconfig --del ip6tables
fi

%files
%config(noreplace) %_sysconfdir/sysconfig/iptables*
%doc INCOMPATIBILITIES
%config %_initdir/iptables
%config %_unitdir/iptables.service
/sbin/*
%_bindir/*
%_man1dir/*
%_man8dir/*
/%_lib/iptables/
%_datadir/iptables/
%_datadir/xtables/
# hack around arepo: we have to package something harmless just to trigger
# arepoizer, to generate i586-iptables package required by several other
# i586-* packages.
%ifarch i586
/usr/lib/libiptc.so
%endif

%files ipv6
%config(noreplace) %_sysconfdir/sysconfig/ip6tables*
%config %_initdir/ip6tables
%config %_unitdir/ip6tables.service

%files -n lib%name
/%_lib/lib*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/lib*.so
%_pkgconfigdir/*.pc

%if_enabled static
%files -n lib%name-devel-static
%_libdir/lib*.a
%endif

%changelog
