Name: iputils
%define timestamp 20101006
Version: %timestamp
Release: alt2

Summary: Utilities for IPv4/IPv6 networking
License: BSD-style
Group: Networking/Other
Url: http://www.skbuff.net/iputils
Packager: Afanasov Dmitry <ender@altlinux.org>

Source0: %url/%name-s%version.tar.bz2
Source1: bonding-0.2.tar.bz2
Source2: bonding-ifenslave.c
Source3: ping.control
Source4: ping6.control

Patch1: iputils-ss020927-owl-warnings.patch
Patch3: iputils-20001007-rh-bug23844.patch
Patch4: iputils-s20071127-alt-datalen-fix.patch
Patch5: iputils-s20101006-alt-droppriv.patch
Patch6: iputils-s20071127-owl-man.patch
# Parallel build of documentation:
Patch8: iputils-pmake.patch
# Disallow lazy binding for setuid binaries:
Patch9: iputils-bindnow.patch

Patch21: iputils-20020124-fc-countermeasures.patch
Patch22: iputils-20020927-fc-addrcache.patch
Patch23: iputils-20020927-fc-ia64_align.patch
Patch24: iputils-20020927-fc-unaligned.patch
Patch25: iputils-20020927-fc-ping-subint.patch

Patch30: iputils-fc-ping_cleanup.patch
# Cosmetic fix, remove \n in perror message:
Patch31: iputils-perror-newline.patch

Conflicts: netkit-base

PreReq: shadow-utils, control
Requires: ipv6calc, /var/resolv

# Automatically added by buildreq on Mon Sep 15 2008
BuildRequires: OpenSP docbook-style-dsssl libcap-devel perl-SGMLSpm
BuildRequires: libsysfs-devel libssl-devel

%description
The iputils package contains basic utilities for monitoring a network:
+ clockdiff - measures clock difference;
+ ping/ping6 - sends ICMP ECHO_REQUEST packets to network hosts;
+ arping - ping by ARP packets;
+ rdisc - classic router discovery daemon;
+ tracepath/tracepath6 - traces path to destination discovering MTU
along this path.

%prep
%setup -q -n %name-s%version -a1

rm -f bonding-0.2/ifenslave
mv -f bonding-0.2/README bonding-0.2/README.ifenslave
cp -a %_sourcedir/bonding-ifenslave.c bonding-0.2/ifenslave.c

%patch1 -p1
%patch22 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch8 -p1
%patch9 -p1

%patch21 -p1
%patch23 -p1
%patch24 -p1
%patch25 -p1

%patch30 -p1
%patch31 -p1

find -type f -name \*.orig -delete -print

%build
%make_build \
	CCOPT="%optflags -D_GNU_SOURCE -Wstrict-prototypes" \
	LDLIBS=
%make_build CFLAGS="%optflags" ifenslave -C bonding-0.2
%make_build man -C doc

%install
mkdir -p %buildroot{/{,s}bin,%_sbindir,%_man8dir}
install -p arping clockdiff %buildroot%_sbindir/
install -p -m700 ping %buildroot/bin/
install -p bonding-0.2/ifenslave %buildroot/sbin/
for n in ping6 tracepath tracepath6; do
	install -p -m755 "$n" %buildroot/bin/
done
install -p rdisc %buildroot%_sbindir/in.rdisc
ln -s in.rdisc %buildroot%_sbindir/rdisc
pushd doc
	install -pm644 arping.8 clockdiff.8 pg3.8 rdisc.8 \
		%buildroot%_man8dir/
	install -pD -m644 ping.1 %buildroot%_man1dir/ping.1
	install -pD -m644 tracepath.1 %buildroot%_man1dir/tracepath.1
	ln -s ping.1 %buildroot%_man1dir/ping6.1
	ln -s tracepath.1 %buildroot%_man1dir/tracepath6.1
popd
install -pD -m755 %_sourcedir/ping.control \
	%buildroot/etc/control.d/facilities/ping
install -pD -m755 %_sourcedir/ping6.control \
	%buildroot/etc/control.d/facilities/ping6

%pre
/usr/sbin/groupadd -r -f iputils
/usr/sbin/useradd -r -g iputils -d /dev/null -s /dev/null -n iputils >/dev/null 2>&1 ||:
/usr/sbin/groupadd -r -f netadmin

if [ $1 -ge 2 ]; then
	/usr/sbin/control-dump ping ping6
fi

%post
if [ $1 -ge 2 ]; then
	/usr/sbin/control-restore ping ping6
else
	/usr/sbin/control ping public
	/usr/sbin/control ping6 public
fi

%files
%config /etc/control.d/facilities/ping
%config /etc/control.d/facilities/ping6
%attr(700,root,root) %verify(not mode group) /bin/ping
%attr(700,root,root) %verify(not mode group) /bin/ping6
/bin/tracepath*
/sbin/ifenslave
%_sbindir/*
%_mandir/man?/*
%doc RELNOTES bonding*/README.*

%changelog
