%def_with python3

Name: ipython
Version: 0.13.1
Release: alt1

%setup_python_module IPython

Summary: An enhanced interactive Python shell
License: BSD
Group: Development/Python

Url: http://ipython.org
BuildArch: noarch

# https://github.com/ipython/ipython.git
Source0: %name-%version.tar
Patch0: %name-0.10-alt-bindings-fix.patch

BuildPreReq: python3-module-tornado
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-distribute
%endif

%add_python_req_skip Gnuplot Numeric bzrlib foolscap nose setuptools twisted msvcrt oct2py rpy2
%add_python3_req_skip __main__


%description
IPython provides a replacement for the interactive Python interpreter with
extra functionality.

Main features:
* Comprehensive object introspection.
* Input history, persistent across sessions.
* Caching of output results during a session with automatically generated
  references.
* Readline based name completion.
* Extensible system of 'magic' commands for controlling the environment and
  performing many tasks related either to IPython or the operating system.
* Configuration system with easy switching between different setups (simpler
  than changing $$PYTHONSTARTUP environment variables every time).
* Session logging and reloading.
* Extensible syntax processing for special purpose situations.
* Access to the system shell with user-extensible alias system.
* Easily embeddable in other Python programs.
* Integrated access to the pdb debugger and the Python profiler.

%if_with python3
%package -n %{name}3
Summary: An enhanced interactive Python 3 shell
Group: Development/Python3
%add_python3_req_skip Gnuplot Numeric bzrlib foolscap nose setuptools twisted
%add_python3_req_skip msvcrt wx gtk compiler OpenGL oct2py rpy2

%description -n %{name}3
IPython provides a replacement for the interactive Python interpreter with
extra functionality.

Main features:
* Comprehensive object introspection.
* Input history, persistent across sessions.
* Caching of output results during a session with automatically generated
  references.
* Readline based name completion.
* Extensible system of 'magic' commands for controlling the environment and
  performing many tasks related either to IPython or the operating system.
* Configuration system with easy switching between different setups (simpler
  than changing $$PYTHONSTARTUP environment variables every time).
* Session logging and reloading.
* Extensible syntax processing for special purpose situations.
* Access to the system shell with user-extensible alias system.
* Easily embeddable in other Python programs.
* Integrated access to the pdb debugger and the Python profiler.
%endif


%package doc
Summary: IPython documentation
Group: Development/Python

%description doc
IPython provides a replacement for the interactive Python interpreter with
extra functionality.

This package contains IPython documentation (html and PDF formats).


%package examples
Summary: IPython examples
Group: Development/Python

%description examples
IPython provides a replacement for the interactive Python interpreter with
extra functionality.

This package contains examples for IPython.


%prep
%setup
#patch0 -p1
rm -f IPython/Extensions/{PhysicalQInteractive.py,scitedirector.py,ipy_render.py,ipy_synchronize_with.py,ipy_traits_completer.py,ipy_winpdb.py,win32clip.py}

%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
export LANG="en_US.UTF-8"
%python3_build
popd
%endif

%install
%python_install
rm -rf %buildroot%python_sitelibdir/IPython/{tests,frontend/cocoa,*/tests,kernel/core/tests}
rm -f %buildroot%_bindir/iptest
cp docs/source/*.txt %buildroot%_docdir/%name/

%if_with python3
pushd ../python3
export LANG="en_US.UTF-8"
%python3_install
rm -rf %buildroot%python3_sitelibdir/IPython/{tests,frontend/cocoa,*/tests,kernel/core/tests}
rm -f %buildroot%_bindir/iptest3
popd
%endif

%files
%_bindir/*
%if_with python3
%exclude %_bindir/*3
%exclude %_bindir/%{name}3*
%endif
%_man1dir/*
%dir %_docdir/%name/
%_docdir/%name/*.txt
%python_sitelibdir/IPython/
%python_sitelibdir/*.egg-info

%files doc
%dir %_docdir/%name/
%_docdir/%name/extensions/
#_docdir/%name/manual/

%files examples
%dir %_docdir/%name/
%_docdir/%name/examples/

%if_with python3
%files -n %{name}3
%_bindir/*3
%_bindir/%{name}3*
%python3_sitelibdir/*
%endif


%changelog
