%def_disable debmenu

Name: irssi
Version: 0.8.15
Release: alt4

Summary: Irssi is an IRC client
License: GPL
Group: Networking/IRC

Url: http://irssi.org/
#http://irssi.org/irssi/files/irssi-%version.tar.bz2
Source: %name-%version.tar

# Automatically added by buildreq on Mon Oct 10 2011
BuildRequires: glib2-devel libpopt-devel libssl-devel libtinfo-devel lynx perl-devel

%description
Irssi is a textUI IRC client with IPv6 support written by
Timo Sirainen <a@sicom.fi>.

More information can be found at http://irssi.org

%package devel
Group: Development/C
Summary: Header files and static libs for the development of irssi applications
Requires: %name = %version-%release

%description devel
Header files and static libs for the development of irssi applications.

%package perl
Group: Networking/IRC
Summary: Perl scripts for irssi
Requires: %name = %version-%release

%description perl
Perl scripts for irssi.

%prep
%setup

%build
./autogen.sh
%autoreconf

sed -i 's@$PERL_LDFLAGS -L/usr/lib@$PERL_LDFLAGS -L/usr/%_lib@g' configure

%configure \
	--with-modules \
	--enable-ipv6 \
	--without-socks \
	--with-terminfo \
	--without-ncurses \
	--with-perl=module \
	--with-perl-lib=vendor \
	--with-proxy \
	--with-bot \
	--with-textui

%make_build

%install
%make_install DESTDIR="%buildroot" install

# Menu entries
mkdir -p %buildroot%_iconsdir

%if_enabled debmenu
mkdir -p %buildroot%_menudir

cat << EOF >%buildroot%_menudir/%name
?package(%name): \
needs="text" \
section="Networking/Chat" \
title="Irssi" \
icon="irssi.png" \
longtitle="A Text-UI based Irc Client" \
section="Networking/IRC" \
command="irssi"
EOF
%else
# freedesktop menu
mkdir -p %buildroot%_datadir/applications
install -m 644 irssi.desktop %buildroot%_datadir/applications/irssi.desktop
%endif

# mdk icons
install -D -m 644 irssi-icons/%{name}48.png %buildroot%_liconsdir/%name.png
install -D -m 644 irssi-icons/%{name}32.png %buildroot%_niconsdir/%name.png
install -D -m 644 irssi-icons/%{name}16.png %buildroot%_miconsdir/%name.png

mv %buildroot%_docdir/%name %buildroot%_docdir/%name-%version
bzip2 ChangeLog
mv AUTHORS ChangeLog.bz2 README TODO NEWS %buildroot%_docdir/%name-%version

%add_findreq_skiplist %_datadir/irssi/scripts/*

%files
#%doc AUTHORS ChangeLog.bz2 README TODO NEWS
%_docdir/%name-%version
%attr(755,root,root) %_bindir/*
%_datadir/irssi
%exclude %_datadir/irssi/scripts
%config(noreplace) %_sysconfdir/irssi.conf
%_liconsdir/*.png
%_miconsdir/*.png
%_niconsdir/*.png
%if_enabled debmenu
%_menudir/irssi
%else
%_datadir/applications/irssi.desktop
%endif
%_mandir/man?/*
%dir %_libdir/irssi
%dir %_libdir/irssi/modules
%_libdir/irssi/modules/*proxy*.so

%files perl
%perl_vendor_archlib/Irssi*
%perl_vendor_autolib/Irssi
%_libdir/irssi/modules/*perl*.so
%_datadir/irssi/scripts

%files devel
%_libdir/irssi/modules/*.a
%_includedir/irssi

%changelog
