Name: iscan-free
Version: 2.20.0
Release: alt2

Summary: Free Image Scan Version with epkowa Driver for Epson Scanners

Packager: Vitaly Lipatov <lav@altlinux.ru>

Url: http://www.avasys.jp/english/linux_e/index.html
License: GPL v2 or later; LGPL v2.1 or later
Group: Graphics

# How to make Source:
# Get the matching source from the iscan package (iscan_2.10.0-1.tar.bz2)
# Unpack it:
# tar -xjvf iscan_2.10.0-1.tar.bz2
# Remove only the really non-free files:
# rm iscan-2.10.0/non-free/libesmod-i386*.so iscan-2.10.0/non-free/EAPL.*.txt
# The remaining file filter.hh and the Makefiles are free software.
# The proprietary binary-only i386-only libesmod library is needed only
# to make the %_bindir/iscan frontend and the EAPL.*.txt license files
# apply only to this libesmod library.
# By using "configure --disable-frontend" it builds without the frontend
# (i.e. without the non-free libesmod library).
# Pack the remaining free sources:
# tar -cjvf iscan-free_2.10.0-1.tar.bz2 iscan-2.10.0/*

Source: iscan-free-2.20.0.tar.bz2
# A README regarding the changes of the free version:
Source1: README

Patch1: libltdl.patch
# Patch10 changes the "sane-epkowa" man page so that those models are removed
# which require a non-free binary-only i386-only plugin. To determine those models use
# egrep '^:model|^:comment' doc/epkowa.desc | grep -B1 'non-free' | grep '^:model'
Patch10: adapt-man-for-free.patch

# Either iscan-free or iscan can be installed.
# If iscan replaces iscan-free, proprietary software becomes installed.
# If iscan-free replaces iscan, some scanner models do no longer work (see README).
# Therefore real "Conflicts" (and not "Obsoletes" which does a silent replacement):
Conflicts: iscan

# manually removed: dpkg, gcc-fortran
# Automatically added by buildreq on Fri Apr 01 2011
BuildRequires: gcc-c++ libgtk+2-devel libjpeg-devel libltdl7-devel libpng-devel libsane-devel libtiff-devel libusb-compat-devel

%description
This version of the Image Scan for Linux software contains only free
software. The proprietary binary-only i386-only "libesint*" driver
libraries are available in the separate package
iscan-proprietary-drivers.

The "esfw*.bin" firmware files are available in the separate package
iscan-firmware.

The proprietary binary-only i386-only "libesmod" library is removed
from this package. It is required by the "%_bindir/iscan" front-end.
This package is built without the front-end.

This package contains only the epkowa back-end for SANE, which compiles
and runs natively even on non-i386 platforms. For documentation, see
"man sane-epkowa".

Drawbacks:

The free version of the epkowa back-end cannot work for those scanners
that require proprietary binary-only i386-only libraries, available in
the separate package iscan-proprietary-drivers. At the moment, those
scanners are the following models:

Perfection 1250 / GT-7200U, Perfection 1250 PHOTO, Perfection 1260 /
GT-7300U, Perfection 1260 PHOTO, Perfection 2480 PHOTO / GT-F500,
Perfection 2580 PHOTO / GT-F550, Perfection 3170 PHOTO / GT-9400UF,
Perfection 3490 PHOTO / GT-F520, Perfection 3590 PHOTO / GT-F570,
Perfection 4180 PHOTO / GT-F600, Perfection 4490 PHOTO / GT-X750,
Perfection V10 / GT-S600, Perfection V100 PHOTO / GT-F650, Perfection
V200 PHOTO / GT-F670, Perfection V350 PHOTO / GT-F700, Stylus CX4300,
Stylus CX4400, Stylus CX5500, Stylus CX5600, Stylus DX4400.

Those models do not work with the free iscan version. They require the
original iscan package and the iscan-proprietary-drivers package, which
are only available for i386-compatible platforms.

Some scanners require proprietary firmware files that are available in
the package iscan-firmware. At the moment, those scanners are the
following models:

Perfection 2480 PHOTO / GT-F500, Perfection 2580 PHOTO / GT-F550,
Perfection 3170 PHOTO / GT-9400UF, Perfection 3490 PHOTO / GT-F520,
Perfection 3590 PHOTO / GT-F570, Perfection 4180 PHOTO / GT-F600,
Perfection 4490 PHOTO / GT-X750, Perfection V10 / GT-S600, Perfection
V100 PHOTO / GT-F650, Perfection V200 PHOTO / GT-F670, Perfection V350
PHOTO / GT-F700.

The front-end %_bindir/iscan was removed because it requires the
proprietary binary-only i386-only "libesmod" library. This should cause
no problem because the back-end epkowa runs now natively even on
non-i386 platforms so that all the usual front-ends (like scanimage,
xscanimage, xsane, and kooka) can be used even on non-i386 platforms.

Authors:
--------
    Noriyuki Sasaki
    Peter J. Schretlen
    Olaf Meeuwissen
    Narihiro Matsukuma
    Ross Boylan
    Tobias Kramer
    Dirk O. Siebnich

%prep
%setup
%__subst "s|non-free||" Makefile.*
# Get the README regarding the changes of the free version:
cp %SOURCE1 .
#%patch1
# Patch3 replaces fixed HZ compile-time value by sysconf(_SC_CLK_TCK) runtime value:
#%patch3
# Patch4 applies fixes for GCC 4.3:
#%patch4
# Remove those models from the man page which require a non-free plugin:
#%patch10
# Distinguish the no longer supported models in the description file
# but do not remove them because otherwise they would be no longer shown in YaST
# when the package iscan-free is installed because the 'triggerin' section
# replaces the description file and from this file YaST will re-build its database
# using %_libdir/YaST2/bin/create_scanner_database which tests if a comment
# contains 'requires DFSG non-free' and if yes it sets the package name
# in the YaST database to iscan (otherwise to iscan-free) so that YaST can
# test and install the right package even for the no longer supported models:
grep -q 'requires DFSG non-free' doc/epkowa.desc || exit 1
%__subst '/requires DFSG non-free/s/^:comment[[:space:]][[:space:]]*"/:comment "unsupported by the iscan-free package<br>/' doc/epkowa.desc
%__subst 's/requires DFSG non-free/requires DFSG non-free plugin in the iscan-proprietary-drivers package:/' doc/epkowa.desc

%build
#rm -f m4/libtool.m4
#autoreconf
# By using disable-frontend it builds without the frontend (i.e. without the non-free stuff):
%configure  --enable-jpeg \
            --enable-png \
            --enable-tiff \
            --disable-static \
            --disable-frontend
#            --enable-gimp
%__make

%install
%makeinstall_std
# Install the backend's config file:
install -d %buildroot%_sysconfdir/sane.d/
install -m 644 backend/epkowa.conf %buildroot%_sysconfdir/sane.d/
# Install the backend's description file:
install -d %buildroot%_datadir/iscan/
# Change the manufacturer name to the same as in SANE's epson.desc file.
grep -q '^:mfg[[:space:]][[:space:]]*"EPSON"' doc/epkowa.desc || exit 1
sed -e 's|^:mfg[[:space:]][[:space:]]*"EPSON".*|:mfg "Epson"|' doc/epkowa.desc >%buildroot%_datadir/iscan/epkowa.desc
mv %buildroot%_libdir/iscan/* %buildroot%_datadir/iscan/
# Remove the installed man page for the "iscan" frontend because it is not included in this package:
rm -f %buildroot%_man1dir/iscan.1
rm -f %buildroot%_libdir/sane/libsane-epkowa.la

%files
%_sbindir/iscan-registry
%doc COPYING AUTHORS NEWS README KNOWN-PROBLEMS SUPPORTED-DEVICES
%dir %_sysconfdir/sane.d
%config %_sysconfdir/sane.d/epkowa.conf
%dir %_libdir/sane
%_libdir/sane/libsane-epkowa.so*
%_datadir/iscan/
%_man5dir/sane-epkowa.5.gz


%changelog
