Summary: The Jack Audio Connection Kit
Name: jack-audio-connection-kit
Version: 1.9.7
Release: alt1.1
Epoch: 1
License: GPLv2 and GPLv2+ and LGPLv2+
Group: Sound
URL: http://www.jackaudio.org

Provides: jackd = %epoch:%version-%release
Obsoletes: jackd < %epoch:%version

Source0: http://www.grame.fr/~letz/jack-%version.tar.bz2
Source2: %name-script.pa
Source3: %name-limits.conf
Patch0: jack-realtime-compat.patch
Patch1: jack-1.9.7-alt-fix.patch

BuildRequires: doxygen gcc-c++ libalsa-devel libcelt-devel libdbus-devel libexpat-devel libffado-devel libfreebob-devel
BuildRequires: libncurses-devel libreadline-devel libsamplerate-devel libsndfile-devel python-modules-compiler
BuildRequires: python-modules-email python-modules-encodings python-modules-logging

%description
JACK is a low-latency audio server, written primarily for the Linux
operating system. It can connect a number of different applications to
an audio device, as well as allowing them to share audio between
themselves. Its clients can run in their own processes (i.e. as a
normal application), or can they can run within a JACK server (i.e. a
"plugin").

JACK is different from other audio server efforts in that it has been
designed from the ground up to be suitable for professional audio
work. This means that it focuses on two key areas: synchronous
execution of all clients, and low latency operation.

%package -n libjack
Summary: Shared libraries to run JACK
Group: System/Libraries

%description -n libjack
This package contains the shared libraries required for %name

%package -n libjack-devel
Summary: Development files for JACK
Group: Development/C++
Provides: jackit-devel = %epoch:%version-%release jackit-devel-doc = %epoch:%version-%release
Obsoletes: jackit-devel < %epoch:%version jackit-devel-doc < %epoch:%version

%description -n libjack-devel
This package includes the development libraries and header files
necessary for developing programs which will use JACK

%package utils
Summary: Utilities for JACK
Group: Sound
Requires: %name = %version-%release
Provides: jackit-utils = %epoch:%version-%release
Obsoletes: jackit-utils < %epoch:%version

%description utils
Utilities that control and interact with the JACK server-jackd

%prep
%setup -q -n jack-%version
%patch0 -p1
%patch1 -p1

%build
./waf configure --prefix=%_prefix --libdir=/%_lib --doxygen --firewire --freebob --alsa --dbus --classic
[ -n "$NPROCS" ] || NPROCS=%__nprocs; ./waf build -j$NPROCS

%install
./waf --destdir=%buildroot install
install -pD -m644 %SOURCE2 %buildroot%_sysconfdir/pulse/%name.pa
install -pD -m644 %SOURCE3 %buildroot%_sysconfdir/security/limits.d/99-%name.conf

mkdir -p %buildroot%_datadir/doc/%name
mv %buildroot%_datadir/jack-audio-connection-kit/reference/html/* %buildroot%_datadir/doc/%name/

%files
%_sysconfdir/pulse/%name.pa
%_sysconfdir/security/limits.d/99-%name.conf
%_bindir/jackd*
%_bindir/jack_load
%_bindir/jack_unload
%_bindir/jack_connect
%_bindir/jack_disconnect
%_bindir/jack_lsp
%_libdir/libjackserver.so.*
%dir %_libdir/jack
%_libdir/jack/*.so
%_datadir/dbus-1/services/org.jackaudio.service
%_man1dir/jackd*.1*
%_man1dir/jack_load.1*
%_man1dir/jack_unload.1*
%_man1dir/jack_connect.1*
%_man1dir/jack_disconnect.1*
%_man1dir/jack_lsp.1*

%files -n libjack
%_libdir/libjack.so.*

%files -n libjack-devel
%_includedir/jack
%_libdir/libjack.so
%_pkgconfigdir/*.pc
%_datadir/doc/%name

%files utils
%exclude %_bindir/jack_load
%exclude %_bindir/jack_unload
%exclude %_bindir/jack_connect
%exclude %_bindir/jack_disconnect
%exclude %_bindir/jack_lsp
%_bindir/jack_*
%exclude %_man1dir/jack_load.1*
%exclude %_man1dir/jack_unload.1*
%exclude %_man1dir/jack_connect.1*
%exclude %_man1dir/jack_disconnect.1*
%exclude %_man1dir/jack_lsp.1*
%_man1dir/jack_*.1*
%_man1dir/jackrec.1*

%changelog
