# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ perl(Fcntl.pm) perl(IO/File.pm) perl(find.pl)
# END SourceDeps(oneline)
BuildRequires: /proc
BuildRequires: jpackage-compat
# %name or %version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name jboss-web-native
%define version 2.0.10
%global namedreltag .GA
%global namedversion %{version}%{?namedreltag}

# The version of tomcat native that this package is based on:
%global tcn_version 1.1.22

Name:             jboss-web-native
Version:          2.0.10
Release:          alt1_3jpp7
Summary:          JBoss Web Native
Group:            Development/Java
License:          LGPLv2+ and ASL 2.0
URL:              http://www.jboss.org/

Source0:          http://downloads.jboss.org/jbossnative/%{namedversion}/jboss-native-%{version}-src-ssl.tar.gz

# In order to avoid a conflict with the tomcat-native package it is necessary
# to rename the library from libtcnative to libjbnative:
Patch0: %{name}-rename-so-to-jbnative.patch

BuildRequires:    libapr1-devel
BuildRequires:    autoconf
BuildRequires:    automake
BuildRequires:    gcc
BuildRequires:    jpackage-utils
BuildRequires:    make
BuildRequires:    libssl-devel
Source44: import.info

%description
This package contains support for Apache Portable Runtime (APR) in JBoss AS.

%package devel
Group: Development/Java
Summary: JBoss Web Native development files
Requires: jboss-web-native = %{version}-%{release}

%description devel
This package provides the support files which can be used to
build applications using the JBoss Web native library.

%prep
%setup -q -n jboss-native-%{version}-src-ssl/srclib/tomcat-native-%{tcn_version}
%patch0 -p1

%build

# In order to rename the output library we need to modify the configure.in file
# (with patch 0) and then regenerate the configure script:
autoreconf --force

# Now we can run the modified configure script:
%configure \
--with-apr=%{_bindir}/apr-1-config \
--with-java-home=%{java_home} \
--with-java-platform=2

# And build:
make %{?_smp_mflags}

%install
make install DESTDIR=%{buildroot}

%files
%{_libdir}/libjbnative-1.so.*

%files devel
#%{_libdir}/libjbnative-1.*a
%{_libdir}/libjbnative-1.so
%{_libdir}/pkgconfig/jbnative-1.pc

%changelog
