BuildRequires: /proc
BuildRequires: jpackage-compat
# Copyright (c) 2000-2005, JPackage Project
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the JPackage Project nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

Summary:        Fast Scanner Generator
Name:           jflex
Version:        1.4.3
Release:        alt5_10jpp7
Epoch:          0
License:        GPL+
URL:            http://jflex.de/
Group:          Development/Java
Source0:        http://jflex.de/%{name}-%{version}.tar.gz
Source1:        http://repo2.maven.org/maven2/de/jflex/jflex/1.4.3/jflex-1.4.3.pom
Source2:        %{name}.desktop
Source3:        %{name}.png
Source4:        %{name}.1

Patch0:         jflex-build_xml.patch
Patch1:         jflex-junit-incompatibility.patch

BuildRequires:  jpackage-utils >= 0:1.5
BuildRequires:  ant
BuildRequires:  junit
BuildRequires:  java_cup
BuildRequires:  desktop-file-utils
Requires:       java_cup
BuildArch:      noarch
Source44: import.info

%description
JFlex is a lexical analyzer generator (also known as scanner
generator) for Java(tm), written in Java(tm). It is also a
rewrite of the very useful tool JLex which was developed by
Elliot Berk at Princeton University. As Vern Paxson states
for his C/C++ tool flex: They do not share any code though.
JFlex is designed to work together with the LALR parser
generator CUP by Scott Hudson, and the Java modification of
Berkeley Yacc BYacc/J by Bob Jamison. It can also be used
together with other parser generators like ANTLR or as a
standalone tool.

%package javadoc
Summary:        Javadoc for %{name}
Group:          Development/Java
BuildArch: noarch

%description javadoc
%{summary}.

%prep
%setup -q
%patch0 -b .sav
%patch1 -p1 -b .sav

for j in $(find . -name "*.jar"); do mv $j $j.no; done
find . -name "*.class" -exec rm {} \;

%{__sed} -i 's/\r//' COPYRIGHT
%{__sed} -i 's|includes="JFlex/\*\*,java_cup/\*\*,skeleton|includes="JFlex/\*\*,skeleton|g' src/build.xml

%build

pushd src
# intial build using the autogenerated sym.java LexParse.java and LexScan.java
# these are created by the jflex ant task which needs to be built first
CLASSPATH=%{_javadir}/junit.jar:%{_javadir}/java_cup.jar ant jar-bootstrap
# now that the JFlex.jar has been build we can use jflex ant tasks
# removing the generated files and rebuilding using the JFlex.jar
CLASSPATH=%{_javadir}/junit.jar:%{_javadir}/java_cup.jar:../lib/JFlex.jar ant genclean libclean jar

javadoc -sourcepath . -d ../api JFlex
popd

%install

# jars
mkdir -p %{buildroot}%{_javadir}
cp -p lib/JFlex.jar %{buildroot}%{_javadir}/%{name}.jar
(cd %{buildroot}%{_javadir} && ln -sf %{name}.jar JFlex.jar)

# poms
install -d -m 755 %{buildroot}%{_mavenpomdir}
install -pm 644 %{SOURCE1} %{buildroot}%{_mavenpomdir}/JPP-%{name}.pom

%add_maven_depmap JPP-%{name}.pom %{name}.jar

# javadoc
mkdir -p %{buildroot}%{_javadocdir}/%{name}
cp -pr api/* %{buildroot}%{_javadocdir}/%{name}

# docs
mkdir -p %{buildroot}%{_docdir}/%{name}-%{version}
cp -p doc/* %{buildroot}%{_docdir}/%{name}-%{version}
cp -p COPYRIGHT %{buildroot}%{_docdir}/%{name}-%{version}

# wrapper script for direct execution
%jpackage_script JFlex.Main "" "" jflex:java_cup jflex true

# manpage
install -dm 755 %{buildroot}%{_mandir}/man1
install -pm 644 %{SOURCE4} %{buildroot}%{_mandir}/man1

# .desktop + icons
desktop-file-install --dir=%{buildroot}%{_datadir}/applications %{SOURCE2}
install -Dpm 644 %{SOURCE3} %{buildroot}%{_datadir}/pixmaps/%{name}.png

mkdir -p $RPM_BUILD_ROOT`dirname /etc/java/jflex.conf`
touch $RPM_BUILD_ROOT/etc/java/jflex.conf

%__subst 's,java_cup,java-cup,' $RPM_BUILD_ROOT/%_bindir/jflex

%pre javadoc
[ $1 -gt 1 ] && [ -L %{_javadocdir}/%{name} ] && \
rm -rf $(readlink -f %{_javadocdir}/%{name}) %{_javadocdir}/%{name} || :

%files
%doc %{_docdir}/%{name}-%{version}
%{_javadir}/%{name}.jar
%{_javadir}/JFlex.jar
%{_mavenpomdir}/JPP-%{name}.pom
%{_mavendepmapfragdir}/%{name}
%{_bindir}/%{name}
%{_mandir}/man1/%{name}.1.*
%{_datadir}/applications/%{name}.desktop
%{_datadir}/pixmaps/%{name}.png
%config(noreplace,missingok) /etc/java/jflex.conf

%files javadoc
%doc %{_javadocdir}/%{name}


%changelog
