Epoch: 0
BuildRequires: /proc
BuildRequires: jpackage-compat
# TODO: junit QA tests

Name:           jfreechart
Version:        1.0.14
Release:        alt3_3jpp7
Summary:        Java chart library

Group:          Development/Java
License:        LGPLv2+
URL:            http://www.jfree.org/jfreechart/
Source0:        http://download.sourceforge.net/sourceforge/jfreechart/%{name}-%{version}.tar.gz

Requires:       servlet jpackage-utils
Requires:       jcommon >= 1.0.17
BuildRequires:  %{requires} ant eclipse-swt servlet
# Required for converting jars to OSGi bundles
BuildRequires:  aqute-bnd

BuildArch:      noarch
Source44: import.info

%description
JFreeChart is a free 100%% Java chart library that makes it easy for
developers to display professional quality charts in their applications.


%package swt
Summary:        Experimental swt extension for jfreechart
Group:          Development/Java
Requires:       %{name} = %{?epoch:%epoch:}%{version}-%{release}
Requires:       eclipse-swt jpackage-utils

%description swt
Experimental swt extension for jfreechart.


%package javadoc
Summary:        Javadocs for %{name}
Group:          Development/Java
Requires:       %{name} = %{?epoch:%epoch:}%{version}-%{release}
Requires:       jpackage-utils
BuildArch: noarch

%description javadoc
This package contains the API documentation for %{name}.



%description javadoc -l fr
Javadoc pour %{name}.

%prep
%setup -q

# Erase prebuilt files
find \( -name '*.jar' -o -name '*.class' \) -exec rm -f '{}' \;

%build
CLASSPATH=$(build-classpath jcommon servlet) \
        ant -f ant/build.xml \
        compile javadoc
ant -f ant/build-swt.xml \
        -Dswt.jar=$(build-classpath swt) \
        -Djcommon.jar=$(build-classpath jcommon) \
        -Djfreechart.jar=lib/jfreechart-%{version}.jar
# Convert to OSGi bundle
java -jar $(build-classpath aqute-bnd) wrap lib/%{name}-%{version}.jar

%install
# Directory structure
install -d $RPM_BUILD_ROOT%{_javadir}/%{name}
install -d $RPM_BUILD_ROOT%{_javadocdir}/%{name}
install -d $RPM_BUILD_ROOT%{_mavenpomdir}

# JARs and JavaDoc
install -m 644 lib/jfreechart-%{version}.bar  $RPM_BUILD_ROOT%{_javadir}/%{name}/%{name}.jar
install -m 644 lib/swtgraphics2d.jar  $RPM_BUILD_ROOT%{_javadir}/%{name}/swtgraphics2d.jar
install -m 644 lib/jfreechart-%{version}-swt.jar  $RPM_BUILD_ROOT%{_javadir}/%{name}/%{name}-swt.jar
cp -rp javadoc/. $RPM_BUILD_ROOT%{_javadocdir}/%{name}

# POM
install -pm 644 pom.xml $RPM_BUILD_ROOT%{_mavenpomdir}/JPP.%{name}-%{name}.pom

# DEPMAP
%add_maven_depmap -a "%{name}:%{name}" JPP.%{name}-%{name}.pom %{name}/%{name}.jar
ln -s %{name}/%{name}.jar %buildroot%{_javadir}/%{name}.jar

%files
%{_mavenpomdir}/*
%{_mavendepmapfragdir}/*
%dir %{_javadir}/%{name}
%{_javadir}/%{name}/%{name}.jar
%doc ChangeLog licence-LGPL.txt NEWS README.txt
%{_javadir}/%{name}.jar

%files swt
%{_javadir}/%{name}/swtgraphics2d*.jar
%{_javadir}/%{name}/%{name}-swt*.jar

%files javadoc
%{_javadocdir}/%{name}

%changelog
