Name: jrosetta
Version: 1.0.4
Release: alt1
Summary: A common base to build a graphical console

Group:   Development/Java
License: GPLv2
Url:     http://dev.artenum.com/projects/JRosetta/
Packager: Andrey Cherepanov <cas@altlinux.org>

Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-java
BuildRequires: java-devel
BuildRequires: maven
BuildRequires: maven-surefire-plugin
BuildRequires: maven-surefire-provider-junit4

%description
JRosetta provides a common base for graphical component that could be
used to build a graphical console in Swing with the latest requirements,
such as command history, completion and so on for instance for scripting
language or command line.

%prep
%setup -q 
#wrong-file-end-of-line-encoding
subst 's/\r//' CHANGE.txt COPYRIGHT.txt

%build
mvn-rpmbuild -e install javadoc:aggregate

%install
mkdir -p %buildroot%_javadir
cp -p modules/%name-api/target/%name-api-%version.jar \
    %buildroot%_javadir/%name-API-%version.jar
ln -s %name-API-%version.jar %buildroot%_javadir/%name-API.jar
cp -p modules/%name-engine/target/%name-engine-%version.jar \
    %buildroot%_javadir/%name-engine-%version.jar
ln -s %name-engine-%version.jar %buildroot%_javadir/%name-engine.jar

mkdir -p %buildroot%_javadocdir/%name
cp -rp target/site/apidocs $RPM_BUILD_ROOT%{_javadocdir}/%{name}

install -d -m 755 %buildroot%_mavenpomdir
install -pm 644 pom.xml  \
        %buildroot%_mavenpomdir/JPP-%name.pom
install -pm 644 modules/%name-api/pom.xml  \
        %buildroot%_mavenpomdir/JPP-%name-API.pom
install -pm 644 modules/%name-engine/pom.xml  \
        %buildroot%_mavenpomdir/JPP-%name-engine.pom


%files
%doc CHANGE.txt COPYRIGHT.txt LICENSE.txt
%_mavenpomdir/JPP-%name.pom
%_mavenpomdir/JPP-%name-*.pom
%_javadir/%name-*.jar
%_javadocdir/%name

%changelog
