%set_verify_elf_method no

%define qtdir %_qt3dir
%define kdedir %_K3prefix

%def_disable hal

%undefine __libtoolize
%define	stable_patchset	1.0.1

%define req_std_burning kdelibs >= 3.2, wodim, cdrkit, cdrdao, mkisofs >= 2.0, dvd+rw-tools, libdvdcss, libdvdread
%if_enabled hal
%define req_std_kde dbus hal
%else
%define req_std_kde dbus
%endif
%define req_std_common libacl, libattr, iceauth
%define req_multimedia libcdparanoia, lame, libmad, libvorbis, libmpcdec, libsndfile, libmusicbrainz, sox, transcode, libflac++, vcdimager >= 0.7, normalize, libtag

%define req_mini %req_std_burning, %req_std_kde, %req_std_common
%define req_all %req_mini, %req_multimedia


Name: k3b
Version: 1.0.5
Release: alt13

Group: Archiving/Cd burning
Summary: The CD Kreator (Complete set)
Summary(ru_RU.UTF-8): Программа записи CD (Полный набор)
License: GPL
Packager: Ilya Mashkin <oddity@altlinux.ru>
URL: http://www.k3b.org/

Source0: %name-%version.tar.bz2

Patch0: %name-%stable_patchset-compile_flags.patch
Patch1: %name-%stable_patchset-messages-alt.patch
Patch2: %name-1.0.4-disk_verify_cdrecord_noeject.patch
Patch3: %name-1.0.4-disk_verify_fallback.patch
Patch4: %name.desktop.patch

Patch6: %name-1.0.5-fix-autoconf-2.64.patch
Patch9: tde-3.5.13-build-defdir-autotool.patch

Requires: %req_all
Requires: k3b-mini = %version

BuildRequires: flac gcc-c++ gcc-g77 kdelibs-devel libdbus-devel libdbus-tqt-devel libflac++-devel libflac-devel libjpeg-devel liblame-devel libmad-devel libmpcdec-devel libmusicbrainz-devel libpng-devel libsamplerate-devel libtag-devel libvorbis-devel libsndfile-devel qt3-designer xml-utils pkgconfig
%if_enabled hal
BuildRequires: libhal-devel
%endif
BuildRequires: libacl-devel libattr-devel libdvdread-devel
BuildRequires: desktop-file-utils

%description
K3b is a GUI frontend to the cd recording programs. 
It's aim is to provide a very user friendly interface to all the tasks that 
come with cd recording. 
This package contains all requiremnts and libraries necessary for full 
program functionality.
%description -l ru_RU.UTF-8
K3b - это мощная графическая оболочка для программ записи компакт дисков.
Она создана для предоставления дружественного интерфейса ко всем задачам, сопровождающим
процесс записи компакт-дисков. 
Этот пакет cодержит зависимости и библиотеки, необходимые для 
полнофункциональной работы программы.


%package mini
Summary: The CD Creator
Summary(ru_RU.UTF-8): Программа записи CD
License: GPL
Group: Archiving/Cd burning
Requires: %req_mini
Obsoletes: k3b-minimal

%description mini
K3b is a GUI frontend to the cd recording programs. 
It's aim is to provide a very user friendly interface to all the tasks that 
come with cd recording.
Install 'k3b' package to get all of the program's features.
%description mini -l ru_RU.UTF-8
K3b - это мощная графическая оболочка для программ записи компакт дисков.
Она создана для предоставления дружественного интерфейса ко всем задачам, сопровождающим
процесс записи компакт-дисков.
Для полнофункцмональной работы Вы можете установить пакет 'k3b'.


%package devel
Summary: The CD Kreator (Development package.)
Summary(ru_RU.UTF-8): Программа записи CD (Пакет разработчика.)
License: GPL
Group: Development/KDE and QT
Requires: k3b = %version

%description devel
K3b is a GUI frontend to the cd recording programs. 
It's aim is to provide a very user friendly interface to all the tasks that 
come with cd recording. 
This package contains k3b development files and libraries.
%description devel -l ru_RU.UTF-8
K3b - это мощная графическая оболочка для программ записи компакт дисков.
Она создана для предоставления дружественного интерфейса ко всем задачам, сопровождающим
процесс записи компакт-дисков. 
Этот пакет содержит файлы и библиотеки, необходимые разработчику 
модулей k3b.

 
%prep
%setup -q 
# patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p0

%patch6 -p1
%patch9

%__subst 's/\.la\>/.so/g' admin/acinclude.m4.in
%__subst 's/\(-Wl,--no-undefined\)/-Wl,--warn-unresolved-symbols \1/g' admin/acinclude.m4.in
#MAKE="%__make" /bin/sh admin/cvs.sh cvs

cp -Rp /usr/share/libtool/aclocal/libtool.m4 admin/libtool.m4.in
cp -Rp /usr/share/libtool/config/ltmain.sh admin/ltmain.sh
make -f admin/Makefile.common

%build
rm -rf %buildroot
export QTDIR=%qtdir
export KDEDIR=%kdedir

export PATH=$QTDIR/bin:$KDEDIR/bin:$PATH

#add_optflags -I%_includedir/tqtinterface
%K3configure \
%if_disabled hal
	--without-hal \
%endif
	--without-k3bsetup
%make_build


%install
%K3install
%K3find_lang --with-kde %name


%files
%_K3lib/*.so
%_K3apps/k3b/cdi
%_K3apps/k3b/extra/*
%_K3apps/k3b/plugins
%_K3apps/konqueror/servicemenus/*audio*
%_K3apps/konqueror/servicemenus/*video*
%_K3apps/%name/servicemenus/*audio*
%_K3apps/%name/servicemenus/*video*
%_K3apps/konqsidebartng/virtual_folders/services/*video*
%_K3srv/video*

%files -f %name.lang mini
%_K3bindir/*
%_K3libdir/lib*.so*
%_K3xdg_apps/*
%_K3applnk/.hidden/*
%dir %_K3apps/%name
%_K3apps/%name/eventsrc
%_K3apps/%name/icons
%_K3apps/%name/k3bui.rc
%_K3apps/%name/pics
%_K3apps/%name/tips
%dir %_K3apps/%name/servicemenus
%_K3apps/%name/servicemenus/*data*
%_K3apps/%name/servicemenus/*image*
%_K3apps/konqueror/servicemenus/*copy*
%_K3apps/konqueror/servicemenus/%{name}_handle_empty*
%_K3srv/kfile*
%_kde3_iconsdir/hicolor/*/apps/*.*
%_K3mimelnk/*/*
%_K3snd/*
%doc README FAQ TODO AUTHORS ChangeLog
%doc %_K3doc/*/k3b/

%files devel
%_K3includedir/*.h

%changelog
