%define katrin_user _katrin
%define katrin_group _katrin

# Uncomment this for enable debug
#%%set_strip_method none

Name: katrin
Version: 1.5.0
Release: alt4.3

Summary: Modular billing system

License: GPL
Group: Monitoring
Url: http://katrin.sf.net

Source: %name-%version.tar
Packager: Denis Klimov <zver@altlinux.org>

BuildRequires: libconfuse-devel libmysqlclient-devel ppp-devel postgresql-devel
BuildPreReq: chrpath
Requires: net-tools sudo

%description
Modular billing system Katrin.
%description -l ru_RU.UTF8
Модульная биллинговая система Katrin.

%package devel
Summary: Development katrin header files
Group: Development/C
Requires: %name = %version-%release
%description devel
Development katrin header files
%description -l ru_RU.UTF8 devel
Заголовочные файлы языка C для библиотек katrin

%package monit
Summary: Monit config file for Katrin
Group: Monitoring
Requires: %name = %version-%release
Requires: monit
%description monit
Monit config file for Katrin
%description -l ru_RU.UTF8 monit
Конфигурационный файл monit для Katrin

%package -n kcdr-sender
Summary: Utility for send tel info by KCDR protocol
Group: Networking/Other
%description -n kcdr-sender
Utility for send tel info by KCDR protocol.
%description -l ru_RU.UTF8 -n kcdr-sender
Утилита для отправки информации о телефонных звонках по протоколу KCDR.

%package core
Summary: Core of Katrin billing system
Group: Networking/Other
%description core
Core of Katrin billing system
%description -l ru_RU.UTF8 core
Ядро биллинговой системы Katrin

%package traff
Summary: Traff module of Katrin billing system
Group: Networking/Other
%description traff
Traff module of Katrin billing system
%description -l ru_RU.UTF8 traff
Traff модуль биллинговой системы Katrin

%package tel
Summary: Tel module of Katrin billing system
Group: Networking/Other
%description tel
Traff module of Katrin billing system
%description -l ru_RU.UTF8 tel
Traff модуль биллинговой системы Katrin

%prep
%setup

%build
%autoreconf
%configure \
	--disable-static \
	--with-pppd-auth
%make_build 

%install
%make_install DESTDIR=%buildroot install
install -pD -m 644 upgrade1.1_1.2.sql %buildroot%_datadir/%name/upgrade1.1_1.2.sql
install -pD -m 755 src/auth/katrin-auth-example %buildroot%_datadir/%name/katrin-auth-example
install -pD -m 744 src/init.d/katrind %buildroot%_initdir/katrind
install -pD -m 744 src/init.d/katrin-dropd %buildroot%_initdir/katrin-dropd
install -pD -m 744 src/tc/ppp/katrin-tc-ppp.sh %buildroot%_sysconfdir/ppp/ip-up.d/katrin-tc-ppp.sh
install -pD -m 0400 sudoers.d/katrin %buildroot%_sysconfdir/sudoers.d/katrin

install -pD -m 644 monitrc.d/katrind %buildroot%_sysconfdir/monitrc.d/katrind
mkdir -p %buildroot%_var/run/katrin

chrpath -r %_libdir/katrin \
	%buildroot%_libdir/pppd/libppp-auth-katrin.so.*
for i in %buildroot%_bindir/*
do
	chrpath -r %_libdir/katrin $i ||:
done

%pre
groupadd -r -f %katrin_group 2>/dev/null ||:
useradd -g %katrin_group -c 'Katrin billing system' -d /var/empty -s '/dev/null' \
-r %katrin_user 2>/dev/null || :

%post
%post_service katrind
%post_service katrin-dropd

%preun
%preun_service katrind
%preun_service katrin-dropd

%post monit
%post_service monit

%postun monit
%post_service monit

%files
%doc AUTHORS THANKS ChangeLog
%_bindir/*
%attr(710,root,%katrin_group) %_bindir/*-enable.sample
%attr(710,root,%katrin_group) %_bindir/*-drop.sample
%attr(740,root,%katrin_group) %_bindir/katrin-functions
%exclude %_bindir/kcdr-sender
%dir %_libdir/katrin
%_libdir/katrin/*.so*
%_libdir/*.so*
%_libdir/pppd/libppp-auth-katrin*.so*
%_datadir/%name/
%_initdir/*
%_sysconfdir/ppp/ip-up.d/*
%_sysconfdir/sudoers.d/katrin

%dir %_sysconfdir/%name
%config(noreplace) %attr(640,root,%katrin_group) %_sysconfdir/%name/*
%exclude %_sysconfdir/%name/kcdr-sender.conf
%dir %attr(1770,root,%katrin_group) %_var/run/katrin

%files devel
%_includedir/libkatrin*.h

%files monit
%_sysconfdir/monitrc.d/katrind

%files -n kcdr-sender
%_bindir/kcdr-sender
%config(noreplace) %attr(640,root,root) %_sysconfdir/%name/kcdr-sender.conf

%changelog
