Name: kbd
Serial: 0
Version: 1.15.5
Release: alt1

Group: Terminals
Summary: Tools for managing the Linux console
License: GPL
Url: ftp://ftp.kernel.org/pub/linux/utils/kbd/
# HOWTO at http://www.win.tue.nl/~aeb/linux/kbd/

Packager: Alexey Gladkov <legion@altlinux.ru>

ExclusiveOS: Linux
ExcludeArch: s390 s390x

Provides: console-tools_or_kbd = %name%serial:%version-%release
Conflicts: console-tools_or_kbd < %name%serial:%version-%release
Conflicts: console-tools_or_kbd > %name%serial:%version-%release

# for compatibility:
Requires: console-vt-tools
Obsoletes: console-tools
Provides: console-tools = %version

# due to file extarctions from this pkg to other
# (console-data, console-common-scripts)
Conflicts: interactivesystem < 1:sisyphus-alt12
Conflicts: console-common-scripts <= 0.2.2-alt1.4

Source0: kbd-%version.tar

# Debian kbd-1.12-10 patches (according to debian/patches/series):
Patch22: po_makefile.diff
Patch23: man_pages.diff

#NMU Patches:
Patch100: kbd-1.12-alt-unicode_start_vs_setfont.patch

# Automatically added by buildreq on Mon Jan 07 2008 (-bi)
BuildRequires: flex libpam-devel

%description
This package contains tools for managing the Linux console
(Linux console, virtual terminals on it, keyboard, etc.)--mainly,
what they do is loading console fonts and keyboard maps.

Basic tools for controlling the vitual terminals are in console-vt-tools package.

A set of various fonts and keyboard maps is provided by console-data package.

%description -l ru_RU.UTF-8
Этот пакет содержит инструменты для управления консолью Linux
(консолью, виртуальными терминалами на ней, клавиатурой и т.п.), в основном, они
занимаются загрузкой консольных шрифтов и раскладок клавиатуры.

Простые инструменты для управления виртуальными терминалами находятся
в пакете console-vt-tools.

Набор разнообразных шрифтов и описаний раскладок предоставляется
пакетом console-data.

%package -n %name-data
Group: Terminals
Summary: Linux console data files

Obsoletes: console-data
Provides: console-data = %version

%description -n %name-data
This package contains various console fonts and keyboard maps.

%package -n %name-docs
Group: Documentation
Summary: Documentation for kbd

%description -n %name-docs
Documentation for kbd

%package -n console-vt-tools
Group: Terminals
Summary: Tools to control VTs (virtual terminals) on the Linux console
Serial: 0

# due to the same files before pkg split:
Conflicts: kbd < 0:1.12-alt1
Conflicts: console-tools < 0:0.2.3-ipl30mdk

%description -n console-vt-tools
console-vt-tools perform simple control operations on the VTs on Linux console
(like switching between them). 

Usually, several VTs are used ontop of the Linux console.
These scripts are useful for writing scripts that need to control them.

%package -n console-scripts
Group: System/Configuration/Other
Summary: Console configuration activation and management
BuildArch: noarch

Requires: %name %name-data
Obsoletes: console-common-scripts
Provides: console-common-scripts = %version

Conflicts: startup < 0.9.7-alt1
Conflicts: console-tools < 0.2.3-ipl29mdk

%description -n console-scripts
This package is required if you have an interactive system with console.
The package is dedicated to both system-wide and per-user Linux console/other VT 
configuration.

It is responsible for the ways the console configuration is managed, 
stored and used (activated), either at system-boot time 
or user session startup. 

%package -n kbdrate
Group: System/Configuration/Hardware
Summary: Reset the keyboard repeat rate and delay time

# due to the parent package change (util-linux --> kbd)
%define kbdrate_serial 1
Serial: %kbdrate_serial

# due to kbdrate
Conflicts: util-linux < 2.11h-alt2
# FIX: kbdrate l10n messages are in the common kbd catalogue

%description -n kbdrate
This package is used to change the keyboard repeat rate and delay time.
The delay is the amount of time that a key must be depressed before it
will start to repeat.

%package -n kbdrate-usermode
Group: System/Configuration/Hardware
Summary: Usermode bindings for kbdrate
BuildArch: noarch

# due to the parent package change (util-linux --> kbd)
Serial: %kbdrate_serial

Requires: kbdrate = %kbdrate_serial:%version-%release
Requires: consolehelper

%description -n kbdrate-usermode
Kbdrate package is used to change the keyboard repeat rate and delay time.
The delay is the amount of time that a key must be depressed before it
will start to repeat.

This package contains usermode bindings for kbdrate.

%package -n vlock
Summary: A program which locks one or more virtual consoles
Group: Terminals

PreReq: /etc/tcb

%description -n vlock
The vlock program locks one or more sessions on the console.  Vlock can
lock the current terminal (local or remote) or the entire virtual console
system, which completely disables all console access.  The vlock program
unlocks when the password of the user who started vlock is typed.


%prep
%setup -q
%patch100 -p1 -b .unicode_start_vs_setfont

%build
%autoreconf -I m4
%configure \
	--bindir=/bin \
	--datadir=/lib/%name \
	--mandir=%_mandir \
	--enable-nls \
	--enable-optional-progs \
	#

%make_build

%install
%makeinstall \
	bindir="%buildroot/bin" \
	datadir="%buildroot/lib/%name" \
	localedir="%buildroot/%_datadir/locale" \
	gnulocaledir="%buildroot/%_datadir/locale" \
	#

# Backward compatibility link
mkdir -p -- %buildroot/%_bindir %buildroot/%_libdir
ln -s -- /lib/%name %buildroot/%_libdir/%name
for binary in setfont dumpkeys kbd_mode unicode_start unicode_stop chvt openvt deallocvt fgconsole; do
	t=$(relative /bin/$binary %_bindir/$binary)
	ln -s $t %buildroot/%_bindir/$binary
done

# Set up kbdrate to be userhelpered.
mkdir -p \
	%buildroot/sbin \
	%buildroot/%_bindir \
	%buildroot/%_sysconfdir/security/console.apps \
	%buildroot/%_sysconfdir/pam.d

install -p -m640 rpm/util-linux-2.9w-kbdrate.pamd %buildroot/%_sysconfdir/pam.d/kbdrate
install -p -m640 rpm/util-linux-2.9w-kbdrate.apps %buildroot/%_sysconfdir/security/console.apps/kbdrate

mv %buildroot/bin/kbdrate %buildroot/sbin/
ln -s -- %_usr/lib/consolehelper/helper %buildroot/bin/kbdrate

install -p -m640 src/vlock/vlock.pamd %buildroot/%_sysconfdir/pam.d/vlock
mv %buildroot/bin/vlock %buildroot/%_bindir/

mkdir -p \
	%buildroot/%_initdir \
	%buildroot/%_datadir/console-scripts \
	%buildroot/%_sysconfdir/profile.d

install -p -m755 rpm/console-scripts/setsys* %buildroot/sbin/
install -p -m755 rpm/console-scripts/{keytable,consolesaver} %buildroot/%_initdir/

for f in configure_keyboard vt_activate_*; do
	install -p -m755 rpm/console-scripts/$f %buildroot/%_datadir/console-scripts/
done

for f in console.*sh configure_keyboard.*sh; do
	install -p -m644 rpm/console-scripts/$f  %buildroot/%_sysconfdir/profile.d/
done

%find_lang %name

# Compatibility forever!
cp -ar -- rpm/kbd-data-extra/* %buildroot/lib/%name/

old_path="$(pwd)"
cd %buildroot/lib/%name/keymaps
	rm -rf -- amiga atari sun
%ifnarch ppc
	rm -rf -- mac ppc
%endif
cd %buildroot/lib/%name/keymaps/i386/include
	rm -f euro1.inc windowkeys.map*

	gzip -9 *.inc
	ln -s windowkeys-compose.inc.gz windowkeys.map.gz
	for f in *.map.gz; do
		fn="${f%%.map.gz}"
		ln -s "$f" "$fn.inc.gz"
	done
cd %buildroot/lib/%name/keymaps/i386/qwerty
	gzip -9 *.map

	if [ -f by-cp1251.kmap ]; then
		mv by-cp1251.kmap by-cp1251.map
		gzip -9 by-cp1251.map
	fi

	ln -s ua.map.gz  ua-KOI8-U.map.gz
	ln -s ua.map.gz  ua-KOI8-R.map.gz # it has also a Russian KOI8-R layout
	ln -s ua-cp1251.map.gz  ua-CP1251.map.gz
	ln -s by-cp1251.map.gz  by-CP1251.map.gz
	ln -s ru_alt-KOI8-R.map.gz ru_alt.map.gz
	ln -s ru_cplk-KOI8-R.map.gz ru_cplk.map.gz
	ln -s ru_ct_sh-KOI8-R.map.gz ru_ct_sh.map.gz
	ln -s ru_ctrl-KOI8-R.map.gz ru_ctrl.map.gz
        ln -s ruwin_alt-KOI8-R.map.gz ruwin_alt.map.gz
	ln -s ruwin_cplk-KOI8-R.map.gz ruwin_cplk.map.gz
        ln -s ruwin_ct_sh-KOI8-R.map.gz ruwin_ct_sh.map.gz
	ln -s ruwin_ctrl-KOI8-R.map.gz ruwin_ctrl.map.gz
cd "$old_path"

# Config files:
mkdir -p -- %buildroot/%_sysconfdir/sysconfig/console
cd %buildroot/%_sysconfdir/sysconfig
touch consolefont keyboard console/setterm

# Set default font
echo 'SYSFONT=UniCyr_8x16' > consolefont

%triggerpostun -n %name-data -- console-data
[ $2 = 0 ] || exit 0
[ ! -d '%_libdir/%name' ] ||
	rm -rf -- '%_libdir/%name'
[ -e '%_libdir/%name' ] ||
	ln -s -- '/lib/%name' '%_libdir/%name'

%triggerpostun -n console-scripts -- console-common-scripts <= 0.2.2-alt1.4, console-scripts < 0:1.13.99-alt4
/sbin/chkconfig keytable on
/sbin/chkconfig consolesaver on
	
%post -n console-scripts
%post_service keytable
%post_service consolesaver
cd %_sysconfdir/sysconfig
for f in consolefont keyboard console/setterm; do
	[ ! -s "$f" ] || continue
	if [ -f "$f".rpmsave ]; then
		cp -pfv "$f".rpmsave "$f"
	elif [ -f "$f".rpmnew ]; then
		cp -pfv "$f".rpmnew "$f"
	fi
done

%preun -n console-scripts
%preun_service keytable
%preun_service consolesaver

%files -f %name.lang
/bin/*
/sbin/*
%_bindir/*
%_mandir/*/*
%exclude /bin/chvt
%exclude /bin/openvt
%exclude /bin/deallocvt
%exclude /bin/fgconsole
%exclude /bin/kbdrate
%exclude /sbin/kbdrate
%exclude /sbin/setsysfont
%exclude /sbin/setsyskeytable
%exclude %_bindir/chvt
%exclude %_bindir/openvt
%exclude %_bindir/deallocvt
%exclude %_bindir/fgconsole
%exclude %_bindir/vlock
%exclude %_man1dir/chvt*
%exclude %_man1dir/openvt*
%exclude %_man1dir/deallocvt*
%exclude %_man1dir/fgconsole*
%exclude %_man1dir/vlock.*
%exclude %_man8dir/kbdrate.*

%files -n %name-data
/lib/%name
%ghost %_libdir/%name

%files -n %name-docs
%doc ChangeLog CREDITS README doc/*.txt doc/kbd.FAQ*.html doc/font-formats/*.html doc/utf

%files -n console-vt-tools
/bin/chvt
/bin/openvt
/bin/deallocvt
/bin/fgconsole
%_bindir/chvt
%_bindir/openvt
%_bindir/deallocvt
%_bindir/fgconsole
%_man1dir/chvt*
%_man1dir/openvt*
%_man1dir/deallocvt*
%_man1dir/fgconsole*

%files -n console-scripts
/sbin/setsysfont
/sbin/setsyskeytable
%attr(755,root,root) %config %_initdir/*
%attr(755,root,root) %config %_sysconfdir/profile.d/*.sh
%attr(755,root,root) %config %_sysconfdir/profile.d/*.csh
%_datadir/console-scripts
%dir %_sysconfdir/sysconfig/console
%config(noreplace) %verify(not md5 mtime size) %_sysconfdir/sysconfig/consolefont
%config(noreplace) %verify(not md5 mtime size) %_sysconfdir/sysconfig/keyboard
%config(noreplace) %verify(not md5 mtime size) %_sysconfdir/sysconfig/console/setterm

# as in ALT util-linux:
%files -n kbdrate
/sbin/kbdrate
%_man8dir/kbdrate.*

%files -n kbdrate-usermode
%config(noreplace) %_sysconfdir/pam.d/kbdrate
%config(noreplace) %_sysconfdir/security/console.apps/kbdrate
/bin/kbdrate

%files -n vlock
%attr(640,root,chkpwd) %config(noreplace) %_sysconfdir/pam.d/vlock
%attr(2711,root,chkpwd) %_bindir/vlock
%_man1dir/vlock.*

%changelog
