%add_findpackage_path %_kde4_bindir
%def_disable marble
%def_disable baloo
%define rname digikam
%define label digiKam
Name: kde4-%rname
%define lname lib%name
Version: 4.7.0
Release: alt0.M70P.1

Summary: digiKam is an advanced digital photo management application for linux
License: %gpl2plus
Group: Graphics
Url: http://www.digikam.org/

Packager: Aeliya Grevnyov <gray_graff@altlinux.org>
Conflicts: digikam <= 0.9.6-alt3

BuildRequires(pre): rpm-build-licenses kde-common-devel

BuildPreReq: libpng-devel

# Automatically added by buildreq on Wed Sep 01 2010
BuildRequires: doxygen gcc-c++ graphviz kde4graphics-devel kde4pimlibs-devel libXScrnSaver-devel libXau-devel libXcomposite-devel libXcursor-devel libXdamage-devel libXdmcp-devel libXext-devel libXft-devel libXinerama-devel libXpm-devel libXrandr-devel libXt-devel libXtst-devel libXv-devel libXxf86vm-devel libgphoto2-devel libjasper-devel libjpeg-devel liblensfun-devel liblqr-devel libxkbfile-devel libtiff-devel
BuildRequires: libpgf-devel libclapack-devel libusb-compat-devel liblcms2-devel
BuildRequires: kde4libs-devel libkface-devel libkgeomap-devel boost-devel
BuildRequires: libopencv-devel libsqlite-devel eigen3
%if_enabled baloo
BuildRequires: kde4-baloo-devel
%endif
%if_enabled marble
BuildRequires: kde4edu-devel
%endif


Requires: libqt4-sql-sqlite kde4base-runtime libkipi4 libqt4-sql-mysql
Requires: %lname = %version-%release
Requires: %name-i18n = %version-%release
Requires: %name-data = %version-%release
%if_enabled marble
Requires: %name-marble = %version-%release
%endif
Source0: %rname-%version.tar
Source1: %rname-po-%version.tar
Source2: %rname-doc-%version.tar
Source3: %rname-doc-translated-%version.tar
Patch1: build-without-mysql.patch

%description
DigiKam is an advanced digital photo management application for KDE.
Photos can be collected into albums which can be sorted chronologically,
by directory layout or by custom collections.
DigiKam also provides tagging functionality. Images can be tagged despite of
their position and digiKam provides fast and intuitive ways to browse them.
User comments and customized meta-information added to images, are stored
into a database and retrieved to make them available into the user interface.
As soon as the camera is plugged in digikam allows you to preview, download,
upload and delete images.
DigiKam also includes tools like Image Editor, to modify photos using plugins
such as red eye correction or Gamma correction, exif management,...
Light Table to make artistic photos and an external image editor such
as Showfoto.
DigiKam also uses KIPI plugins (KDE Image Plugin Interface) to increase
its functionalities.

%package utils
Group: Graphics
Summary: %label utils
Requires: %name = %version-%release

%description utils
Utilities for %label data.

%package -n %lname
Group: System/Libraries
Summary: %label library

%description -n %lname
%label library.

%package data
Group: Graphics
Summary: A Photo Management Application for KDE
Requires: %name = %version-%release
BuildArch: noarch
Conflicts: digikam-data <= 0.9.6-alt3

%description data
DigiKam is an advanced digital photo management application for KDE.
Photos can be collected into albums which can be sorted chronologically,
by directory layout or by custom collections.
DigiKam also provides tagging functionality. Images can be tagged despite of
their position and digiKam provides fast and intuitive ways to browse them.
User comments and customized meta-information added to images, are stored
into a database and retrieved to make them available into the user interface.
As soon as the camera is plugged in digikam allows you to preview, download,
upload and delete images.
DigiKam also includes tools like Image Editor, to modify photos using plugins
such as red eye correction or Gamma correction, exif management,...
Light Table to make artistic photos and an external image editor such
as Showfoto.
DigiKam also uses KIPI plugins (KDE Image Plugin Interface) to increase
its functionalities.

%package i18n
Group: Graphics
Summary: Languages support for %label
Requires: %name = %version-%release
BuildArch: noarch

%description i18n
Languages support for %label.

%package image-plugins
Group: Graphics
Summary: %label image plugins
Requires: %name = %version-%release

%description image-plugins
%label plugins for additional functionalities in ImageEditor and
Showfoto.

%package -n %lname-devel
Group: Development/KDE and QT
Summary: Development files for %label
Requires: %lname = %version-%release

%description -n %lname-devel
Development files for %label.

%if_enabled marble
%package marble
Group: Graphics
Summary: %label support
Requires: %name = %version-%release
Requires: kde4edu-core kde4edu-marble

%description marble
Marble support for %lname.
%endif


%prep
%setup -q -n %rname-%version  -a1 -a2 -a3
%patch1 -p2

# change double to qreal for casting on arm
find -type f -name \*.cpp | \
while read f ; do
    sed -i 's|<double>|<qreal>|g' $f
done
find -type f -name \*.h | \
while read f ; do
    sed -i 's|<double>|<qreal>|g' $f
done

mv %rname-po-%version po
mv %rname-doc-%version doc
mv %rname-doc-translated-%version doc-translated
sed -i 's|add_subdirectory|macro_optional_add_subdirectory|' doc-translated/CMakeLists.txt

cat >> CMakeLists.txt <<__EOF__
find_package(Msgfmt REQUIRED)
find_package(Gettext REQUIRED)
add_subdirectory( po )
add_subdirectory( doc )
add_subdirectory( doc-translated )
__EOF__


%build
%K4build \
    -DENABLE_INTERNALMYSQL=OFF \
    -DENABLE_MYSQLSUPPORT=OFF \
    -DENABLE_BALOOSUPPORT=%{?_enable_baloo:ON}%{!?_enable_baloo:OFF} \
    -DENABLE_LCMS2=ON \
    #

%install
%K4install

rm -rf %buildroot%_man1dir

rm -f %buildroot/%_K4i18n/*/*/kipiplugin*
rm -f %buildroot/%_K4i18n/*/*/libkipi.*
rm -f %buildroot/%_K4i18n/*/*/libkgeomap*
%K4find_lang --with-kde %rname
%K4find_lang --with-kde --append --output=%rname.lang showfoto

%files
%_K4bindir/%rname
%_K4bindir/showfoto

%files utils
%_K4bindir/cleanup_digikamdb
%_K4bindir/digitaglinktree

%files -n %lname
%_K4libdir/lib%{rname}*.so*
%_K4lib/kio_%{rname}*.so

%if_enabled marble
%files marble
%_K4plug/marble
%endif

%files data
%doc AUTHORS ChangeLog DESIGN HACKING NEWS README TODO
%_K4xdg_apps/*.desktop
%_K4apps/%rname
%exclude %_K4apps/%rname/%{rname}imageplugin_*_ui.rc
%_K4apps/showfoto
%_K4apps/solid/actions/%{rname}-opencamera.desktop
%_K4srv/%{rname}*.protocol
%_K4iconsdir/hicolor/*/apps/%rname.*
%_K4iconsdir/hicolor/*/apps/showfoto.*
%_K4conf_update/*

%files i18n -f %rname.lang

%files image-plugins
%_K4lib/%{rname}imageplugin_*.so
%_K4apps/%rname/%{rname}imageplugin_*_ui.rc
%_K4srv/%{rname}imageplugin_*.desktop
%_K4srvtyp/*.desktop

%files -n %lname-devel
%_K4link/*.so

%changelog
