%define libsover 4
%define libkipiplugins libkipiplugins%libsover

%define rname kipi-plugins
Name: kde4-%rname
%define beta %nil
Version: 4.5.0
Release: alt0.M70P.2

Group: Graphics
Summary: KDE image Interface Plugins
License: GPLv2, ADOBE DNG SDK
Url: http://www.kipi-plugins.org/
Packager: Sergey V Turchin <zerg@altlinux.org>

Source0: %rname-%version.tar
Source1: %rname-po-%version.tar
Source2: %rname-doc-%version.tar
Source10: FindOpenCV.cmake
Source11: FindKSane.cmake
Source12: FindKipi.cmake
Patch1: alt-arm-cast-to-qreal.patch
Patch2: alt-lib-version.patch

Requires: %name-core = %version-%release
Requires: %name-expoblending = %version-%release
Conflicts: kipi-plugins <= 3:0.1.6-alt5

# Automatically added by buildreq on Thu Apr 16 2009 (-bi)
#BuildRequires: gcc-c++ kde4graphics-devel kde4pimlibs-devel libGL-devel libXScrnSaver-devel libXau-devel libXcomposite-devel libXdmcp-devel libXpm-devel libXt-devel libXtst-devel libXv-devel libXxf86misc-devel libexpat-devel libgio-devel libgpod-devel libgtk+2-common-devel libnss-fallback libopencv-devel libqt3-devel libsane-devel libxkbfile-devel libxslt-devel nvidia_glx_180.44 subversion xorg-xf86vidmodeproto-devel xsltproc
BuildRequires(pre): kde4libs-devel kde4graphics-devel
BuildRequires: gcc-c++ kde4pimlibs-devel libgomp-devel libkgeomap-devel qjson-devel libqca2-devel
BuildRequires: libgio-devel libgpod-devel libgtk+2-devel boost-devel
BuildRequires: libopencv-devel libsane-devel libxslt-devel xsltproc libexpat-devel libxml2-devel libjpeg-devel
BuildRequires: qoauth-devel qjson-devel herqq-devel qtsoap-devel
BuildRequires: qt-gstreamer-devel libImageMagick-devel ImageMagick-tools
BuildRequires: libkvkontakte-devel libmediawiki-devel libtiff-devel flex

%description
The library of the KDE Image Plugin Interface used by digiKam and Gwenview

%package common
Summary: %name common package
Group: System/Configuration/Other
Requires: kde-common
Conflicts: kde4-kipi-plugins <= 1.1.0-alt1
%description common
%name common package

%package core
Group: Graphics
Summary: Core files for %name
Requires: %name-common = %version-%release
Requires: icc-profiles /usr/bin/convert
%description core
Core files for %name

%package expoblending
Group: Graphics
Summary: A tool to blend bracketed images
Requires: %name-common = %version-%release
Requires: hugin enblend
%description expoblending
A tool to blend bracketed images

%package -n %libkipiplugins
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n %libkipiplugins
KDE 4 library.

%prep
%setup -q -n %rname-%version -a1 -a2
%patch1 -p1
%patch2 -p1
mv %rname-po-%version po
mv %rname-doc-%version doc
#install -m 0644 %SOURCE10 cmake/modules
install -m 0644 %SOURCE11 cmake/modules
install -m 0644 %SOURCE12 cmake/modules

if ! grep -qe '^add_subdirectory([[:space:]]*po[[:space:]]*)' CMakeLists.txt
then
cat >> CMakeLists.txt <<__EOF__
find_package(Msgfmt REQUIRED)
find_package(Gettext REQUIRED)
add_subdirectory( po )
__EOF__
fi

if ! grep -qe '^add_subdirectory([[:space:]]*doc[[:space:]]*)' CMakeLists.txt
then
cat >> CMakeLists.txt <<__EOF__
add_subdirectory( doc )
__EOF__
fi

%build
%K4cmake -DImageMagick_INCLUDE_DIRS=%_includedir/ImageMagick-6
%K4make

%install
%K4install

rm -f %buildroot/%_K4i18n/*/*/digikam*
rm -f %buildroot/%_K4i18n/*/*/libkipi.*
rm -f %buildroot/%_K4i18n/*/*/libkgeomap*
%K4find_lang --with-kde %rname
find %buildroot/%_K4i18n -type f -name kipiplugin\*.mo | sed "s|\.mo$||" | \
while read f; do echo `basename "$f"`; done | sort -u | \
while read n
do
    %K4find_lang --with-kde --append --output=%rname.lang "$n"
done

%files
%files common

%files core -f %rname.lang
%doc AUTHORS ChangeLog README TODO NEWS COPYING-*
%_K4bindir/dnginfo
%_K4bindir/dngconverter
#%_K4bindir/multithread
%_K4bindir/panoramagui
%_K4bindir/photolayoutseditor
%_K4bindir/scangui
%_K4lib/kipiplugin_*.so
#%_K4lib/photolayoutseditor*plugin_*.so
%_K4apps/kipi/
%_K4apps/kipiplugin_*/
%_K4apps/gpssync/
%_K4apps/photolayoutseditor/
%_K4cfg/photolayoutseditor.kcfg
%_K4srv/kipiplugin_*
#%_K4srv/photolayoutseditor*plugin_*.desktop
%_K4srvtyp/photolayoutseditor*plugin.desktop
%_K4iconsdir/oxygen/*/*/*.*
%_K4iconsdir/hicolor/*/*/*.*
%_K4xdg_apps/dngconverter.desktop
%_K4xdg_apps/kipiplugins.desktop
%_K4xdg_apps/panoramagui.desktop
%_K4xdg_apps/photolayoutseditor.desktop
%_K4xdg_apps/scangui.desktop
%_K4tmpl/kipiplugins_photolayoutseditor/
# exclude expoblending
%exclude %_K4lib/kipiplugin_expoblending.so
%exclude %_K4srv/kipiplugin_expoblending.desktop
%exclude %_K4apps/kipiplugin_expoblending

%files expoblending
%_K4bindir/expoblending
%_K4lib/kipiplugin_expoblending.so
%_K4apps/kipiplugin_expoblending
%_K4srv/kipiplugin_expoblending.desktop
%_K4xdg_apps/expoblending.desktop

%files -n %libkipiplugins
%_K4libdir/libkipiplugins.so.%libsover
%_K4libdir/libkipiplugins.so.%libsover.*

%changelog
