%define _kde_alternate_placement 1

%def_disable google
%if_enabled kde_mobile
%def_disable desktop
%else
%def_enable desktop
%endif
%def_disable baloo
%def_disable ruby
%define x11confdir %_sysconfdir/X11

%add_findpackage_path %_kde4_bindir
%add_findreq_skiplist %_kde4_bindir/krdb
%add_findreq_skiplist %_kde4_bindir/startkde
%add_findreq_skiplist %_bindir/startkde4
%if_disabled ruby
%add_findreq_skiplist %_K4apps/plasma_scriptengine_ruby/*.rb
%endif


%define major 4
%define minor 11
%define bugfix 14
%define rname kdebase-workspace
Name: kde4base-workspace
Version: %major.%minor.%bugfix
Release: alt0.M70P.1

Group: Graphical desktop/KDE
Summary: K Desktop Environment - Workspace
License: GPLv2
Url: http://www.kde.org/
Packager: Sergey V Turchin <zerg at altlinux dot org>

Requires: %name-core = %version-%release
%if_enabled desktop
Requires: %name-kdm = %version-%release
Requires: %name-cursors = %version-%release
Requires: %name-wallpapers = %version-%release
%endif

Source0: ftp://ftp.kde.org/pub/kde/stable/%version/src/%rname-%version.tar
Source1: pam-kde4
Source2: pam-kde4-np
Source3: pam-kde4-kscreensaver
Source4: kdm.logrotate
Source5: kdm.service

# upstream
# RH
Patch20: kdebase-workspace-4.6.80-krdb.patch
Patch21: kde-workspace-4.8.80-battery-plasmoid-showremainingtime.patch
Patch22: kde-workspace-4.9.90-plasma_konsole.patch
Patch23: kde-workspace-4.7.80-no_HAL.patch
Patch24: kdebase-workspace-4.11.1-no_HAL2.patch
Patch25: kde-workspace-4.9.1-solid_krunner_disable.patch
Patch26: kde-workspace-4.10.90-kde#171685.patch
Patch27: kde-workspace-4.11.0-backlight_actual_brightness.patch
#
Patch29: kde-workspace-4.11.1-kdm-logind-multiseat.patch
# Ubuntu
Patch850: kubuntu_11_fix_root_only_kcms.diff
Patch851: kubuntu_always_show_kickoff_subtext.diff
# ROSA
Patch900: kde-workspace-4.11.13-alt-screenlocker-background.patch
# ALT
Patch1000: kdebase-workspace-4.11.1-alt-startkde.patch
Patch1001: kdebase-workspace-4.6.0-alt-kdm-confdir.patch
Patch1002: kdebase-workspace-4.6.3-alt-kdm-cmd-poweroff.patch
Patch1003: kdebase-workspace-4.11.6-alt-kdm-defaults.patch
Patch1004: kdebase-workspace-4.6.5-alt-kdm-wmsession.patch
Patch1005: kdebase-workspace-4.4.92-alt-kdm-dont-show-nologin-users.patch
Patch1006: kmenuedit-4.8.0-alt-menueditor.patch
Patch1007: kdebase-workspace-4.8.0-alt-def-kxkb.patch
Patch1008: kdebase-workspace-4.4.92-alt-kdm-defaults-language.patch
Patch1009: kdebase-workspace-4.4.3-alt-kickoff-cleanup.patch
Patch1010: kdebase-workspace-4.10.0-alt-fix-compile.patch
Patch1011: kdebase-workspace-4.8.0-alt-def-apps-menu.patch
Patch1012: kdebase-workspace-4.2.2-alt-kdm-greet.patch
Patch1013: kdebase-workspace-4.7.3-alt-devicenotifier-remote-shares.patch
Patch1014: kdebase-workspace-4.7.1-alt-kdm-kcm-defaults.patch
Patch1015: kdebase-workspace-4.7.1-alt-gtkrc-custom.patch
Patch1016: kdebase-workspace-4.11.2-alt-def-plasma.patch
Patch1017: kdebase-workspace-4.11.1-alt-ksysguardrc.patch
Patch1018: kdebase-workspace-4.11.1-alt-def-kwin.patch
Patch1019: kdebase-workspace-4.8.0-alt-def-fonts.patch
Patch1020: kdebase-workspace-4.4.92-alt-kdm-guistyle.patch
Patch1021: kdebase-workspace-4.4.92-alt-kdm-color-scheme.patch
Patch1022: kdebase-workspace-4.7.1-alt-splash.patch
Patch1023: kdebase-workspace-4.4.3-alt-disable-konqueror-gestures.patch
Patch1024: kdebase-workspace-4.6.0-alt-kdm-bglist.patch
Patch1025: kdebase-workspace-4.3.1-alt-screenpreview-update.patch
Patch1026: kdebase-workspace-4.5.0-alt-usb-ids-path.patch
Patch1027: kdebase-workspace-4.7.3-alt-kickoffsimple.patch
Patch1028: kdebase-workspace-4.4.3-alt-kickoff-search.patch
Patch1029: kdebase-workspace-4.4.3-alt-kickoff-search-keywords.patch
Patch1030: kdebase-workspace-4.8.2-alt-def-systray-applets.patch
Patch1031: kdebase-workspace-4.4.5-alt-python25.patch
Patch1032: kdebase-workspace-4.7.1-alt-def-desktop-plugin.patch
Patch1033: kdebase-workspace-4.5.2-alt-lsof-path.patch
Patch1034: kdebase-workspace-4.7.1-alt-systemsettings-desktop.patch
Patch1035: kdebase-workspace-4.6.0-alt-disable-effect-startupfeedback.patch
Patch1036: kdebase-workspace-4.6.3-alt-kdm-apply-colors.patch
Patch1037: kdebase-workspace-4.6.4-alt-hide-configs.patch
Patch1038: kdebase-workspace-4.8.5-alt-session-exclude.patch
Patch1039: kdebase-workspace-4.11.4-alt-def-plasma-digitalclock.patch
Patch1040: kdebase-workspace-4.7.4-alt-kxkb-indicator-uppercase.patch
#
Patch1042: kdebase-workspace-4.8.5-alt-netbook-def-menu-groups.patch
Patch1043: kdebase-workspace-4.8.5-alt-def-plasma-netbook.patch
Patch1044: kdebase-workspace-4.8.5-alt-workspaceoptions.patch
Patch1045: kdebase-workspace-4.10.0-alt-def-plasma-desktop-immutability.patch
Patch1046: kdebase-workspace-4.10.0-alt-pager-refresh-layout.patch
Patch1047: kdebase-workspace-4.10.0-alt-def-oxygen-widgets.patch
Patch1048: kdebase-workspace-4.11.1-alt-def-oxygen-kwin.patch
Patch1049: kdebase-workspace-4.10.4-alt-mobile-netbook.patch
Patch1050: kdebase-workspace-4.10.4-alt-mobile-kwin-buildopts.patch
Patch1051: kdebase-workspace-4.10.4-alt-kcm_fonts_dont_change_on_load.patch
Patch1052: kdebase-workspace-4.11.1-alt-disable-kcm-randr.patch
Patch1053: kdebase-workspace-4.11.5-alt-oxygen-decoration-color-selinux.patch

BuildRequires(pre): kde4libs-devel rpm-build-python
BuildRequires(pre): NetworkManager-devel
BuildRequires(pre): libpolkit-devel
%if_enabled google
BuildRequires: google-gadgets-devel
%endif
BuildRequires: bzlib-devel gcc-c++ libXft-devel libGLES-devel
BuildRequires: libxcb-devel libxcbutil-image-devel libxcb-render-util-devel libxcbutil-keysyms-devel
BuildRequires: libbluez-devel libkrb5-devel libpam-devel libaudit-devel
BuildRequires: libqimageblitz-devel libraw1394-devel libsensors3-devel libgps-devel
BuildRequires: libstrigi-devel libusb-compat-devel xml-utils
BuildRequires: libalternatives-devel libudev-devel
BuildRequires: polkit-qt-1-devel libpolkit-devel libdbusmenu-qt-devel
BuildRequires: soprano soprano-backend-redland libsoprano-devel
BuildRequires: libqalculate-devel libjpeg-devel prison-devel qjson-devel
BuildRequires: kde4pimlibs-devel akonadi-devel libraw1394-devel libpci-devel
BuildRequires: python-module-PyQt4 python-module-sip python-devel
BuildRequires: kde4-kactivities-devel
%if_disabled baloo
BuildRequires: kde4-nepomuk-core-devel
%endif
BuildRequires: python-module-sip python-devel libselinux-devel
BuildRequires: libsystemd-login-devel libsystemd-journal-devel libsystemd-id128-devel libsystemd-daemon-devel systemd-devel
#BuildRequires: libwayland-client-devel libwayland-server-devel libwayland-egl-devel
BuildRequires: kde4libs-devel >= %version
%if_enabled ruby
BuildRequires: rpm-build-ruby
%endif

%description
The KDE Workspace consists of what is the desktop of the
KDE Desktop Environment.

This package contains:
%if_enabled desktop
* kdm (the login manager of KDE)
%endif
* khotkeys (a hotkey daemon)
* klipper (a cut & paste history utility)
* kmenuedit (the menu editor)
* krandrtray (resize and rotate X screens)
* krunner (a command run interface)
* ksysguard (a performance monitor)
* kwin (the window manager of KDE)
* kxkb (a utility to switch keyboard maps)
* plasma (the KDE desktop, panels and widgets workspace application)
* systemsettings (the configuration editor)

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Requires: %name-common = %version-%release
#Requires: %name = %version-%release
Requires: kde4libs-devel libqimageblitz-devel kde4-kactivities-devel kde4base-runtime-devel
%description devel
Development files for %name

%package common
Summary: Common files for %name package
Group: Graphical desktop/KDE
BuildArch: noarch
Requires: kde-common >= %major.%minor
#
%description common
Common files for %name package

%package core
Summary: Core files for %name package
Group: Graphical desktop/KDE
Requires: design-graphics >= 12.0.0
Requires: %name-common = %version-%release
%ifdef _kde_alternate_placement
%else
Provides: kdebase-wm = %version-%release
Obsoletes: kdebase-wm < %version-%release
%endif
Requires: udev udisks2 upower media-player-info usbids
Requires: kde4base-runtime >= %version
Requires: kde4-icon-theme-oxygen kde4-kactivities
Requires: /usr/bin/qdbus dbus-tools-gui
Requires: qalculate-common
Requires: kde4-kscreen
%if_enabled google
#Requires: google-gadgets-qt
%endif
Requires: polkit-kde-agent-1
%if_enabled baloo
Requires: kde4-baloo
%else
Requires: kde4-nepomuk-core
%endif
Provides: kde4base-kinfocenter = %version-%release
Obsoletes: kde4base-kinfocenter < %version-%release
%description core
Core files for %name package

%package kdm
Summary: KDE Display Manager (KDM)
Group: Graphical desktop/KDE
PreReq(post,preun): alternatives >= 0.2
Requires: design-graphics >= 11.0.0 xinitrc
#Requires: systemd
Requires: %name-common = %version-%release
Provides: kde4base-kdm = %version-%release
Provides: kde4-kdm = %version-%release
Provides: kdebase-kdm = %version-%release
%description kdm
This is the KDE Display Manager (KDM), a replacement for the
X Display Manager (XDM)

%package cursors
Summary: Default X11 cursors for KDE
Group: System/XFree86
BuildArch: noarch
Requires: %name-common = %version-%release
%description cursors
Default X11 cursors for KDE

%package wallpapers
Summary: Default desktop wallpapers for KDE
Group: Graphics
BuildArch: noarch
Requires: %name-common = %version-%release
%description wallpapers
Default desktop wallpapers for KDE

%package -n libpolkitkdeprivate4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libpolkitkdeprivate4
KDE 4 library.

%package -n libsolidcontrolifaces4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libsolidcontrolifaces4
KDE 4 library

%package -n libsolidcontrol4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libsolidcontrol4
KDE 4 library

%package -n libweather4_ion
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libweather4_ion
KDE 4 library

%package -n libkdecorations4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libkdecorations4
KDE 4 library

%package -n libkscreensaver4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libkscreensaver4
KDE 4 library

%package -n libksgrd4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libksgrd4
KDE 4 library

%package -n libkwineffects4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libkwineffects4
KDE 4 library

%package -n libkworkspace4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libkworkspace4
KDE 4 library

%package -n libplasmaclock4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libplasmaclock4
KDE 4 library

%package -n libprocesscore4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libprocesscore4
KDE 4 library

%package -n libprocessui4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libprocessui4
KDE 4 library

%package -n libkhotkeysprivate4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libkhotkeysprivate4
KDE 4 library

%package -n libkfontinst4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libkfontinst4
KDE 4 library

%package -n libkfontinstui4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libkfontinstui4
KDE 4 library

%package -n libtaskmanager4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libtaskmanager4
KDE 4 library

%package -n libkwinnvidiahack4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libkwinnvidiahack4
KDE 4 library


%package -n libkephal4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libkephal4
KDE 4 library

%package -n liblsofui4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
Requires: /usr/sbin/lsof
%description -n liblsofui4
KDE 4 library

%package -n libplasma4_applet-system-monitor
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libplasma4_applet-system-monitor
KDE 4 library

%package -n libplasma4-geolocation-interface
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libplasma4-geolocation-interface
KDE 4 library

%package -n libsystemsettingsview4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libsystemsettingsview4
KDE 4 library

%package -n libksignalplotter4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libksignalplotter4
KDE 4 library

%package -n libplasmagenericshell4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libplasmagenericshell4
KDE 4 library

%package -n liboxygenstyle4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n liboxygenstyle4
KDE 4 library

%package -n libpowerdevilcore4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libpowerdevilcore4
KDE 4 library

%package -n libpowerdevilui4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libpowerdevilui4
KDE 4 library

%package -n libpowerdevilconfigcommonprivate4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libpowerdevilconfigcommonprivate4
KDE 4 library

%package -n libkwinglutils4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libkwinglutils4
KDE 4 library

%package -n libkwinglesutils4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libkwinglesutils4
KDE 4 library

%package -n liboxygenstyleconfig4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n liboxygenstyleconfig4
KDE 4 library

%package -n libkwinactiveglutils4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libkwinactiveglutils4
KDE 4 library

%package -n libkwinactivenvidiahack4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libkwinactivenvidiahack4
KDE 4 library

%package -n libkwinactiveglesutils4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libkwinactiveglesutils4
KDE 4 library

%package -n libkwinactiveeffects4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libkwinactiveeffects4
KDE 4 library

%prep
%setup -q -n %rname-%version
# move default ksplash theme to use another by default
#sed -i 's|Default|Air|g' ksplash/ksplashx/themes/air/CMakeLists.txt
#sed -i 's|Default|Air|g' ksplash/ksplashx/themes/air/Theme.rc
%if_disabled google
rm -rf plasma/generic/scriptengines/google_gadgets
%endif

%patch20 -p1
%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch24 -p1
%patch25 -p1
%patch26 -p1
%patch27 -p1
#
%patch29 -p1
#
%patch850 -p1
%patch851 -p1
#
%patch900 -p1
#
%patch1000 -p1 -b .startkde
%patch1001 -p1
%patch1002 -p1
%patch1003 -p1 -b .kdmdefs
%patch1004 -p1
%patch1005 -p1
%patch1006 -p1
%patch1007 -p1
%patch1008 -p1
%patch1009 -p1
%patch1010 -p1
%patch1011 -p1
%patch1012 -p1
###%patch1013 -p1
%patch1014 -p1
%patch1015 -p1
%patch1016 -p1
%patch1017 -p1
%patch1018 -p1
%patch1019 -p1
%patch1020 -p1
%patch1021 -p1
%patch1022 -p1
%patch1023 -p1
%patch1024 -p1
%patch1025 -p1
%patch1026 -p1
%patch1027 -p1
%patch1028 -p1
%patch1029 -p1
%patch1030 -p1
%patch1031 -p1
%patch1032 -p1
%patch1033 -p1
%patch1034 -p1
%patch1035 -p1
%patch1036 -p1
%patch1037 -p1
%patch1038 -p1
%patch1039 -p1
%patch1040 -p1
#
%patch1042 -p1
%patch1043 -p1
%patch1044 -p1
%patch1045 -p1
%patch1046 -p1
%patch1047 -p1
%patch1048 -p1
%patch1049 -p1
%patch1050 -p1
%patch1051 -p1
%patch1052 -p1
%patch1053 -p1

grep -q X-KDE-RootOnly kdm/kcm/kdm.desktop \
    || echo "X-KDE-RootOnly=true" >>kdm/kcm/kdm.desktop
grep -q X-KDE-SubstituteUID kdm/kcm/kdm.desktop \
    || echo "X-KDE-SubstituteUID=true" >>kdm/kcm/kdm.desktop

sed -i 's|@KDM_BIN_DIR@|%_K4exec|' altlinux/kdm.service

%build
#    -DKDE4_ENABLE_FINAL:BOOL=ON \
%K4cmake \
    -DKDE4_BUILD_TESTS:BOOL=OFF \
    -DKDE4_ENABLE_FPIE:BOOL=ON \
    -DWITH_NetworkManager=ON \
    -DKDE4_COMMON_PAM_SERVICE=kde4 \
    -DKDE4_KDM_PAM_SERVICE=kde4 \
    -DKDE4_KCHECKPASS_PAM_SERVICE=kde4 \
    -DKDM_CONFIG_INSTALL_DIR=%x11confdir/kdm4 \
    -DKDE4_KSCREENSAVER_PAM_SERVICE=kde4-kscreensaver \
    -DPYTHON_SITE_PACKAGES_INSTALL_DIR:PATH=%python_sitelibdir \
    -DKWORKSPACE_USE_SYSTEMD=ON \
    -DKDE_DEFAULT_HOME:STRING=".kde4"
%K4make

%install
export GENKDMCONF_FLAGS="--no-old"
%K4install
mkdir -p %buildroot/%_bindir/

# Install kde pam configuration files
install -d -m 0755 %buildroot/%_sysconfdir/pam.d/
install -m 0644 %SOURCE1 %buildroot/%_sysconfdir/pam.d/kde4
install -m 0644 %SOURCE2 %buildroot/%_sysconfdir/pam.d/kde4-np
install -m 0644 %SOURCE3 %buildroot/%_sysconfdir/pam.d/kde4-kscreensaver

# add startkde to %_bindir
mkdir -p %buildroot/%_bindir
ln -s `relative %_kde4_bindir/startkde %_bindir/startkde4` %buildroot/%_bindir/startkde4

# Add chksession support
mkdir -p %buildroot/%x11confdir/wmsession.d/
cat <<__EOF__ > %buildroot/%x11confdir/wmsession.d/01KDE4
NAME=KDE
DESC=The K Desktop Environment
ICON=%_K4iconsdir/oxygen/64x64/apps/kde.png
EXEC=%_bindir/startkde4
SCRIPT:
exec %_bindir/startkde4
__EOF__


# Create menu session
mkdir -p %buildroot/%_menudir/
cat <<__EOF__ > %buildroot/%_menudir/kde4-session
?package(%name): needs=wm \
                        section="Session/Windowmanagers" \
			title="KDE" \
			longtitle="K Desktop Environment" \
			command="%_bindir/startkde4" \
			icon="kde.png"
__EOF__

# move cursors
for d in `ls -1d %buildroot/%_kde4_iconsdir/Oxygen_*` ; do
    mv $d %buildroot/%_K4iconsdir/
done


%if_enabled desktop
# install kdm settings
mkdir -p %buildroot/%x11confdir/kdm4
cp -ar altlinux/kdm-settings/* %buildroot/%x11confdir/kdm4/
install -m 0644 %buildroot/%_K4conf/kdm/kdmrc %buildroot/%x11confdir/kdm4/
mkdir -p %buildroot/%_localstatedir/kdm4/faces

mkdir -p %buildroot/%_sysconfdir/alternatives/packages.d/
# install kdm alternatives
%ifdef _kde_alternate_placement
mv %buildroot/%_kde4_bindir/kdm %buildroot/%_K4exec/kdm
mv %buildroot/%_kde4_bindir/kdmctl %buildroot/%_K4exec/kdmctl
%else
mv %buildroot/%_K4bindir/kdm %buildroot/%_K4exec/kdm
mv %buildroot/%_K4bindir/kdmctl %buildroot/%_K4exec/kdmctl
%endif
cat > %buildroot/%_sysconfdir/alternatives/packages.d/kde4-kdm <<__EOF__
%_bindir/kdm	%_K4exec/kdm	20
%_bindir/kdm_config	%_K4exec/kdm_config	%_K4exec/kdm
%_bindir/kdmctl	%_K4exec/kdmctl	%_K4exec/kdm
__EOF__

mkdir -p %buildroot/%_K4xdg_apps/
install -m 0644 %buildroot/%_K4srv/kdm.desktop %buildroot/%_K4xdg_apps/kdm.desktop
sed -i 's|^Type=.*$|Type=Application|' %buildroot/%_K4xdg_apps/kdm.desktop
sed -i 's|^Categories=.*$|Categories=Qt;KDE;System;Settings;|' %buildroot/%_K4xdg_apps/kdm.desktop
sed -i 's|^X-KDE-System-Settings-Parent-Category.*||' %buildroot/%_K4xdg_apps/kdm.desktop
sed -i 's|^X-KDE-ServiceTypes=.*||' %buildroot/%_K4xdg_apps/kdm.desktop
sed -i 's|^X-KDE-ParentApp=.*||' %buildroot/%_K4xdg_apps/kdm.desktop
sed -i 's|^X-KDE-Library=.*||' %buildroot/%_K4xdg_apps/kdm.desktop

# install logrotate file
mkdir -p %buildroot/%_sysconfdir/logrotate.d
install -m 0644 %SOURCE4 %buildroot/%_sysconfdir/logrotate.d/kdm4

# install systemd service file
mkdir -p %buildroot/%_unitdir
install -m 0644 altlinux/kdm.service %buildroot/%_unitdir/kdm4.service

# default user face
mkdir -p %buildroot/%_sysconfdir/firsttime.d/
cat >%buildroot/%_sysconfdir/firsttime.d/kdm4 <<__EOF__
#!/bin/sh
WITHOUT_RC_COMPAT=1
# Source functions library.
. /etc/init.d/functions
if [ ! -e %_localstatedir/kdm4/faces/.default.face.icon -a -d %_localstatedir/kdm4/faces -a -f %_datadir/design/current/faces/default.png ]
then
    action "Setup kdm default user icon:" cp -af %_datadir/design/current/faces/default.png %_localstatedir/kdm4/faces/.default.face.icon
fi
__EOF__
chmod 0755 %buildroot/%_sysconfdir/firsttime.d/kdm4

%pre kdm
/usr/sbin/useradd -c 'KDM Greeter User' -s /sbin/nologin -d %_localstatedir/kdm4 -r _kdm4 2> /dev/null || :
/bin/chown _kdm4 %_localstatedir/kdm4/kdmsts >/dev/null 2>&1 || :

%post kdm
[ -n "$DURING_INSTALL" ] || %_sysconfdir/firsttime.d/kdm4

%triggerpostun kdm -- kde4base-workspace-kdm <= 4.11.8-alt1
[ "`grep '^ServerVTs=' %x11confdir/kdm4/kdmrc | sed 's|ServerVTs=\(.*\)|\1|'`" != "-7" ] \
    || sed -i 's|^ServerVTs=.*|ServerVTs=-1,-7|' %x11confdir/kdm4/kdmrc ||:
%endif


%files
%files common
%config(noreplace) %_sysconfdir/pam.d/kde4
%config(noreplace) %_sysconfdir/pam.d/kde4-np

%if_enabled desktop
%files kdm
%dir %x11confdir/kdm4
%config(noreplace) %x11confdir/kdm4/*
%config %_sysconfdir/alternatives/packages.d/kde4-kdm
%_sysconfdir/firsttime.d/kdm4
%config %_sysconfdir/logrotate.d/kdm4
%_unitdir/kdm4.service
%config(noreplace) %_sysconfdir/dbus-1/system.d/org.kde.kcontrol.kcmkdm.conf
%exclude %_K4conf/kdm
%_kde4_bindir/genkdmconf
%_K4exec/kdm
%_K4exec/kdm_config
%_K4exec/kdmctl
%_K4exec/krootimage
%_K4exec/kdm_greet
%_K4exec/kcmkdmhelper
%_K4lib/kcm_kdm.so*
%_K4apps/kdm/
%_K4apps/doc/kdm
%exclude %_K4apps/kdm/sessions/*
%_K4srv/kdm.desktop
%_K4xdg_apps/kdm.desktop
%attr(0775,_kdm4,root) %_localstatedir/kdm4
%_datadir/polkit-1/actions/org.kde.kcontrol.kcmkdm.policy
%_K4dbus_sys_services/org.kde.kcontrol.kcmkdm.service
%_K4doc/en/kdm
%endif

%files core
%config(noreplace) %_sysconfdir/pam.d/kde4-kscreensaver
%config(noreplace) %_sysconfdir/dbus-1/system.d/org.kde.*.conf
%if_enabled desktop
%config(noreplace) %x11confdir/wmsession.d/*KDE*
%exclude %_sysconfdir/dbus-1/system.d/org.kde.kcontrol.kcmkdm.conf
%endif
%_menudir/kde4-session
%doc README
%if_enabled desktop
%config(noreplace) %_sysconfdir/ksysguarddrc4
%endif
#%config(noreplace) %_sysconfdir/systemsettingsrc
%ifdef _kde_alternate_placement
%_bindir/startkde4
%_kde4_bindir/*
%if_enabled desktop
%exclude %_kde4_bindir/genkdmconf
%endif
%else
%_K4bindir/*
%if_enabled desktop
%exclude %_K4bindir/genkdmconf
%endif
%endif
%if_enabled desktop
%exclude %_K4exec/kcmkdmhelper
%endif
%attr(2711,root,chkpwd) %_K4exec/kcheckpass
%_K4exec/backlighthelper

%if_enabled desktop
%_K4exec/kcmdatetimehelper
%_K4exec/kfontprint
%_K4exec/fontinst
%_K4exec/fontinst_x11
%_K4exec/fontinst_helper
%_K4exec/kwin_rules_dialog
#%_K4exec/test_kcm_xinerama
%endif
%_K4exec/kscreenlocker_greet
%_K4exec/ksysguardprocesslist_helper
%_K4exec/kwin_killer_helper
%_K4exec/kwin_opengl_test
%if_enabled desktop
%_K4libdir/libkickoff.so
%_K4libdir/strigi/*
%endif
#%_K4libdir/libsystemsettingsview.so
%_K4libdir/libkdeinit4_*.so
%_K4conf_bin/*
%_K4lib/*.so*
%if_enabled desktop
%_K4lib/imports/org/kde/kwin/
%exclude %_K4lib/kcm_kdm.so*
%endif
%_K4lib/plugins/styles/*.so
%_K4plug/gui_platform/libkde.so
%if_enabled desktop
%exclude %_K4lib/kgreet_*.so*
%endif
%_datadir/polkit-1/actions/org.kde.*.policy
%if_enabled desktop
%exclude %_datadir/polkit-1/actions/org.kde.kcontrol.kcmkdm.policy
%endif
%_K4apps/*
%if_enabled desktop
%exclude %_K4apps/kdm
%exclude %_K4apps/doc/kdm
%endif
%exclude %_K4apps/cmake/
%_K4conf/*
%if_enabled desktop
%exclude %_K4conf/kdm*
%endif
%_K4srv/*
%if_enabled desktop
%exclude %_K4srv/kdm.desktop
%endif
%_K4srvtyp/*
%_K4snd/*
%if_enabled desktop
%_K4start/*
%endif
%if_enabled desktop
%_kde4_xdg_apps/*
%_K4xdg_apps/*
%exclude %_K4xdg_apps/kdm.desktop
%endif
%_K4cfg/*
%ifdef _kde_alternate_placement
%if_enabled desktop
%_K4doc/en/*
%exclude %_K4doc/en/kdm
%endif
%else
%_K4doc/en/*
%if_enabled desktop
%exclude %_K4doc/en/kdm
%endif
%endif
%exclude %_K4plug/designer/*
#%_K4datadir/xsessions/*
%if_enabled desktop
%_K4dbus_services/*
%endif
%_K4dbus_sys_services/*
%if_enabled desktop
%exclude %_K4dbus_sys_services/org.kde.kcontrol.kcmkdm.service
%endif
%python_sitelibdir/*
%_K4iconsdir/oxygen/*/*/*
%ifdef _kde_alternate_placement
%_kde4_iconsdir/hicolor/*/*/*
%else
%_K4iconsdir/hicolor/*/*/*
%endif

%if_enabled desktop
%files cursors
%_K4iconsdir/Oxygen_*/
%_kde4_iconsdir/KDE_Classic/

%files wallpapers
%_K4wall/*
#%ifdef _kde_alternate_placement
#%exclude %_K4wall/default_blue*
#%endif
%endif

%files -n libpowerdevilconfigcommonprivate4
%_K4libdir/libpowerdevilconfigcommonprivate.so.*
%files -n libpowerdevilcore4
%_K4libdir/libpowerdevilcore.so.*
%files -n libpowerdevilui4
%_K4libdir/libpowerdevilui.so.*
%files -n libweather4_ion
%_K4libdir/libweather_ion.so.*
%files -n libkdecorations4
%_K4libdir/libkdecorations.so.*
%if_enabled desktop
%files -n libkscreensaver4
%_K4libdir/libkscreensaver.so.*
%endif
%files -n libksgrd4
%_K4libdir/libksgrd.so.*
%files -n libkworkspace4
%_K4libdir/libkworkspace.so.*
%if_enabled desktop
%_K4lib/kgreet_*.so*
%endif
%files -n libplasmaclock4
%_K4libdir/libplasmaclock.so.*
%files -n libprocessui4
%_K4libdir/libprocessui.so.*
%if_enabled desktop
%files -n libkhotkeysprivate4
%_K4libdir/libkhotkeysprivate.so.*
%files -n libkfontinst4
%_K4libdir/libkfontinst.so.*
%files -n libkfontinstui4
%_K4libdir/libkfontinstui.so.*
%files -n libtaskmanager4
%_K4libdir/libtaskmanager.so.*
%endif
%files -n libkephal4
%_K4libdir/libkephal.so.*
%files -n liblsofui4
%_K4libdir/liblsofui.so.*
%files -n libplasma4_applet-system-monitor
%_K4libdir/libplasma_applet-system-monitor.so.*
%files -n libplasma4-geolocation-interface
%_K4libdir/libplasma-geolocation-interface.so.*
%files -n libprocesscore4
%_K4libdir/libprocesscore.so.*
%files -n libksignalplotter4
%_K4libdir/libksignalplotter.so.*
%files -n libplasmagenericshell4
%_K4libdir/libplasmagenericshell.so.*
%if_enabled desktop
%files -n libsystemsettingsview4
%_K4libdir/libsystemsettingsview.so.*
%endif
%files -n liboxygenstyle4
%_K4libdir/liboxygenstyle.so.*
%files -n liboxygenstyleconfig4
%_K4libdir/liboxygenstyleconfig.so.*
%if_enabled desktop
%files -n libkwinglutils4
%_K4libdir/libkwinglutils.so.*
%files -n libkwinglesutils4
%_K4libdir/libkwinglesutils.so.*
%files -n libkwineffects4
%_K4libdir/libkwineffects.so.*
%else
%files -n libkwinactiveglutils4
%_K4libdir/libkwinactiveglutils.so.*
%files -n libkwinactiveglesutils4
%_K4libdir/libkwinactiveglesutils.so.*
%files -n libkwinactiveeffects4
%_K4libdir/libkwinactiveeffects.so.*
%endif


%files devel
%_K4includedir/*
%_K4apps/cmake/
%_K4libdir/cmake/KDE4Workspace/
%_K4link/lib*.so
%_K4plug/designer/*
%_K4dbus_interfaces/*

%changelog
