%define _kde_alternate_placement 1

%if_enabled kde_mobile
%def_disable desktop
%else
%def_enable desktop
%endif

%def_enable hupnp

%add_findpackage_path %_kde4_bindir
%add_findreq_skiplist %_K4apps/cmake/modules*.py

%define major 4
%define minor 12
%define bugfix 4
%define rname kdelibs
Name: kde4libs
Version: %major.%minor.%bugfix
Release: alt0.M70P.1

%define conflictver %major.%minor-alt0.0.1
%define conflictver_kdevelop 3.4.1-alt0.0.1

Group: System/Libraries
Summary: K Desktop Environment 4 - Libraries
Url: http://www.kde.org/
License: LGPLv2/BSD/GFDL

Requires: kde-common >= %major.%minor
PreReq: altlinux-freedesktop-menu-kde4
Requires: ca-certificates shared-mime-info

Conflicts: koffice-core = 1.9.98.3
# Conflicts for old KDE
#Conflicts: kde4-i18n-de < %conflictver kde4-i18n-fr < %conflictver kde4-i18n-he < %conflictver
#Conflicts: kde4-i18n-et < %conflictver kde4-i18n-ru < %conflictver kde4-i18n-uk < %conflictver
#Conflicts: kde4-i18n-tt < %conflictver kde4-i18n-kk < %conflictver kde4-i18n-pt_BR < %conflictver
#Conflicts: kdevelop-common < %conflictver_kdevelop
#Conflicts: kde4accessibility-common < %conflictver
#Conflicts: kde4addons-common < %conflictver
#Conflicts: kde4admin-common < %conflictver
#Conflicts: kde4artwork-common < %conflictver
#Conflicts: kde4artwork-wallpapers < %conflictver
#Conflicts: kde4base-common < %conflictver
#Conflicts: kde4base-runtime < %conflictver
#Conflicts: kde4base-runtime-common < %conflictver kde4base-common < %version
#Conflicts: kde4base-workspace-common < %conflictver kde4base-common < %version
#Conflicts: kde4devplatform-common < %conflictver
#Conflicts: kde4edu-common < %conflictver
#Conflicts: kde4games-common < %conflictver
#Conflicts: kde4multimedia-common < %conflictver
#Conflicts: kde4network-common < %conflictver
#Conflicts: kde4pimlibs-common < %conflictver
#Conflicts: kde4pimlibs < %conflictver kde4base-common < %version
#Conflicts: kde4pim-common < %conflictver
#Conflicts: kde4plasma-addons-common < %conflictver
#Conflicts: kde4toys-common < %conflictver
#Conflicts: kde4utils-common < %conflictver
#Conflicts: kde4sdk-common < %conflictver
#Conflicts: kde4webdev-common < %conflictver
#Conflicts: kde4-konqueror-plugins-common < %conflictver


Source: %rname-%version.tar

# RH
Patch101: kdelibs-4.3.90-install_all_css.patch
Patch102: kdelibs-4.5.80-parallel_devel.patch
Patch103: kdelibs-4.7.0-knewstuff_gpg2.patch
Patch104: kdelibs-4.5.80-no_rpath.patch
Patch105: kdelibs-4.7.4-SOLID_UPNP.patch
# Debian
Patch201: 14_hardcode_ptm_device.diff
Patch202: 30_kfileshare_kdesu_fileshareset.diff
Patch203: 31_relax_plugin_kde_version_check.diff
# SuSE
Patch301: desktop-translations.diff
# upstream
# ALT
Patch1000: kdelibs-4.8.4-alt-xdg-dirs.patch
Patch1001: kdelibs-4.0.72-alt-custom-kdedir.patch
Patch1002: kdelibs-4.6.0-alt-exists_ext.patch
Patch1003: kdelibs-4.4.0-alt-applications.menu.patch
Patch1004: kdelibs-4.6.0-alt-libexec-install-dir.patch
Patch1005: kdelibs-4.7.0-alt-def-http-slave.patch
Patch1006: kdelibs-4.1.0-alt-libssl-name.patch
Patch1007: kdelibs-4.0.0-alt-su-close-pty.patch
Patch1008: kdelibs-4.3.90-alt-show-distribution.patch
Patch1009: kdelibs-4.0.71-alt-find-ruby.patch
Patch1010: kdelibs-4.6.5-alt-findqt4-version.patch
Patch1011: kdelibs-4.1.1-alt-find-automoc.patch
Patch1012: kdelibs-4.1.2-alt-mark-user-edited.patch
Patch1013: kdelibs-4.6.3-alt-places-add-docs.patch
Patch1014: kdelibs-4.2.2-alt-find-usb.patch
Patch1015: kdelibs-4.3.0-alt-resources-order.patch
Patch1016: kdelibs-4.6.0-alt-initial-preference.patch
Patch1017: kdelibs-4.6.0-alt-def-plasma.patch
Patch1018: kdelibs-4.5.0-alt-def-fonts.patch
Patch1019: kdelibs-4.6.0-alt-kfileplaces.patch
Patch1020: kdelibs-4.4.2-alt-disable-debug.patch
Patch1021: kdelibs-4.4.92-alt-find-docbook.patch
Patch1022: kdelibs-4.5.0-alt-submenu-delay.patch
Patch1023: kdelibs-4.7.4-plasma-tooltip-delay.patch
Patch1024: kdelibs-4.6.3-alt-samba-sharing.patch
Patch1025: kdelibs-4.7.1-alt-find-hupnp.patch
Patch1026: kdelibs-4.7.1-alt-find-pulseaudio.patch
Patch1027: kdelibs-4.10.0-alt-no-hal.patch
Patch1028: kdelibs-4.8.1-alt-kdesu-export-user-var.patch
#
Patch1030: kdelibs-4.9.1-alt-platform-profile.patch
Patch1031: kdelibs-4.8.5-alt-add-desktop-translations.patch
Patch1032: kdelibs-4.9.1-alt-policy-dir.patch
Patch1033: kdelibs-4.9.1-alt-cmake-spaces.patch
#
Patch1035: kdelibs-4.10.2-alt-flags.patch
Patch1036: kdelibs-4.10.2-alt-add-protocol-all.patch
Patch1037: kdelibs-4.10.4-alt-def-plasma-theme-bg.patch
Patch1038: kdelibs-4.10.5-alt-run-with-context.patch

Patch3000: kdelibs-4.4.92-alt-alternate-kconf_update_bin-path.patch

# security

BuildRequires(pre): kde-common-devel libqt4-devel libsoprano-devel libstrigi-devel attica-devel
BuildRequires: soprano-backend-redland soprano-backend-virtuoso soprano
BuildRequires: bzlib-devel cmake libalsa-devel libselinux-devel
%if_enabled hupnp
BuildRequires: herqq-devel
%endif
BuildRequires: libXScrnSaver-devel grantlee-devel
#BuildRequires: libaspell-devel aspell
BuildRequires: libenchant-devel
BuildRequires: libavahi-devel libjasper-devel libjpeg-devel
BuildRequires: libgif-devel libxslt-devel liblzma-devel docbook-style-xsl docbook-dtds
BuildRequires: openexr-devel libkrb5-devel shared-desktop-ontologies-devel
BuildRequires: polkit-qt-1-devel libpolkit1-devel libudev-devel
BuildRequires: graphviz gcc-c++ libpcre-devel shared-mime-info
BuildRequires: xml-utils libutempter-devel phonon-devel automoc
BuildRequires: libacl-devel libattr-devel flex libqca2-devel
BuildRequires: libdbusmenu-qt-devel
BuildRequires: kde-common-devel >= %major.%minor
BuildRequires: libqt4-devel >= 4.4 libsoprano-devel >= 2.1 libstrigi-devel >= 0.5.9

%description
Libraries for the K Desktop Environment 4.

%package devel
Group: Development/KDE and QT
Summary: Header files for compiling KDE 4 applications
Requires: %name = %version-%release
Requires: cmake libqt4-devel kde-common-devel >= %major.%minor
Requires: libXdmcp-devel libXcomposite-devel libXdamage-devel libxkbfile-devel libXtst-devel libXScrnSaver-devel
Requires: libXpm-devel libXxf86vm-devel libXt-devel libXft-devel
Requires: libstrigi-devel libsoprano-devel libpcre-devel libgif-devel xml-utils
Requires: libutempter-devel bzlib-devel phonon-devel automoc shared-desktop-ontologies-devel
Requires: docbook-style-xsl docbook-dtds

%description devel
This package includes the header files you will need to compile
applications for KDE 4.

%prep
%setup -q -n %rname-%version

%patch101 -p1
%patch102 -p1
%patch103 -p1
%patch104 -p1
%if_enabled hupnp
%patch105 -p1
%endif
#
%patch201 -p1
%patch202 -p1
%patch203 -p1
#
%patch301 -p0
#
%patch1000 -p1 -b .xdg-dirs
%patch1001 -p1 -b .custom-kdedir
%patch1002 -p1 -b .exists_ext
%patch1003 -p1
%patch1004 -p1
%patch1005 -p1
%patch1006 -p1
%patch1007 -p1
%patch1008 -p1
%patch1009 -p1
%patch1010 -p1
#%patch1011 -p1
%patch1012 -p1
%patch1013 -p1
#%patch1014 -p1
#%patch1015 -p1 -b .resources-order
%patch1016 -p1
#%patch1017 -p1
%patch1018 -p1
%patch1019 -p1
%patch1020 -p1
%patch1021 -p1
%patch1022 -p1
#%patch1023 -p1
%patch1024 -p1
%patch1025 -p1
%patch1026 -p1
%patch1027 -p1
%patch1028 -p1
#
%patch1030 -p1
%patch1031 -p1
%patch1032 -p1
%patch1033 -p1
#
%patch1035 -p1
%patch1036 -p1
%patch1037 -p1
%patch1038 -p1

%patch3000 -p1

# CA certificates bundle
#pushd kio/kssl/kssl
#echo "%_datadir/ca-certificates/ca-bundle.crt" >localcerts
#./mergelocal
#popd


%build
export XDG_DATA_DIRS=%_K4datadir:%_datadir
#export CMAKE_LIBRARY_PATH=%_libdir
#define _K4buildtype Debug
#    -DKDE4_ENABLE_FINAL:BOOL=ON \
%K4cmake \
    -DKDE4_BUILD_TESTS=OFF \
    -DKDE4_ENABLE_FPIE:BOOL=ON \
%if_enabled desktop
    -DKDE_PLATFORM_PROFILE="Desktop" \
%else
    -DKDE_PLATFORM_PROFILE="Mobile" \
%endif
    -DPCRE_INCLUDE_DIR=%_includedir/pcre \
%if_enabled hupnp
    -DHUPNP_ENABLED:BOOL=ON \
%endif
    -DWITH_FAM:BOOL=OFF \
    -DWITH_SOLID_UDISKS2=ON \
    -DKDE_DISTRIBUTION_TEXT="%distribution %_target_cpu" \
    -DKDE4_AUTH_BACKEND_NAME="POLKITQT-1" \
    -DKDE_DEFAULT_HOME:STRING=".kde4"

%K4make

# FIXME
#doc/api/doxygen.sh --doxdatadir=doc/common .


%install
%K4install

# move menu
mkdir -p %buildroot/%_sysconfdir/kde4/xdg/menus/applications-merged/
mv %buildroot/%_sysconfdir/kde4/xdg/menus/applications.menu %buildroot/%_sysconfdir/kde4/xdg/menus/applications-merged/

%ifdef _kde_alternate_placement
mkdir -p %buildroot/%_K4bindir/
pushd %buildroot/%_kde4_bindir
for f in *4
do
    ln -sf `relative %buildroot/%_kde4_bindir/$f %buildroot/%_K4bindir/$f` %buildroot/%_K4bindir/$f
done
popd
ln -sf `relative %buildroot/%_kde4_bindir/kde4-config %buildroot/%_K4bindir/kde4-config` %buildroot/%_K4bindir/kde4-config
%endif

# CA certificates bundle 2
#[ -f %buildroot/%_K4apps/kssl/ca-bundle.crt ] || exit 1
#ln -sf `relative %buildroot/%_datadir/ca-certificates/ca-bundle.crt %buildroot/%_K4apps/kssl/ca-bundle.crt` %buildroot/%_K4apps/kssl/ca-bundle.crt

# disable annoing autostart
mkdir -p %buildroot/%_K4start/
for n in tracker-miner-fs tracker-store ; do
    echo -e "[Desktop Entry]\nHidden=true" > %buildroot/%_K4start/$n.desktop
done


%files
%doc AUTHORS README TODO
#%_man1dir/*
%_man7dir/*
%_man8dir/*
#
#%config(noreplace) %_sysconfdir/profile.d/*
%exclude %_K4sysconfdir/kde4/xdg/menus/applications-merged/applications.menu
%config %_K4sysconfdir/dbus-1/system.d/*.conf
#
%_K4bindir/*
%exclude %_K4bindir/kconfig_compiler4
%exclude %_K4bindir/makekdewidgets4
%ifdef _kde_alternate_placement
%_kde4_bindir/*
%exclude %_kde4_bindir/kconfig_compiler4
%exclude %_kde4_bindir/makekdewidgets4
%endif
%_K4exec/*
%_K4apps/*
%exclude %_K4apps/LICENSES/
%exclude %_K4apps/cmake/
%exclude %_K4apps/kdewidgets/
%exclude %_K4datadir/apps/ksgmltools2/
%_K4start/*
%_K4conf/*
%_K4dbus_interfaces/*
%_K4xdg_mime/*
%_kde4_xdg_apps/*
%_K4srv/*
%_K4srvtyp/*
%_kde4_iconsdir/hicolor/*/actions/presence_*
#%_kde4_iconsdir/hicolor/*/apps/ktexteditorautobrace.*
%_K4i18n/all_languages
%_K4i18n/en_US/entry.desktop
%_K4doc/en/*
%_K4libdir/lib*.so.*
%_K4libdir/libkdeinit4_*.so
%_K4lib/*.so*
%_K4plug/script/*.so*
%_K4plug/imageformats/*.so*
%_K4plug/kauth
#%_datadir/polkit-1/actions/org.kde.kcontrol.kcmremotewidgets.policy

%files devel
%doc KDE4PORTING.html
%_K4bindir/kconfig_compiler4
%_K4bindir/makekdewidgets4
%ifdef _kde_alternate_placement
%_kde4_bindir/kconfig_compiler4
%_kde4_bindir/makekdewidgets4
%endif
%_K4libdir/cmake/KDeclarative
%_K4link/lib*.so
%dir %_K4plug/designer/
%_K4plug/designer/*.so*
%_K4apps/cmake/
%_K4apps/ksgmltools2/
%_K4apps/kdewidgets/
%_K4includedir/*

%changelog
