
%add_findpackage_path %_kde4_bindir

%define rname kdemultimedia
Name: kde4multimedia
%define major 4
%define minor 12
%define bugfix 3
Version: %major.%minor.%bugfix
Release: alt0.M70P.1

Group: Graphical desktop/KDE
Summary: K Desktop Environment - Multimedia
License: GPLv2
Url: http://www.kde.org

#Requires: %name-dragonplayer = %version-%release
Requires: %name-juk = %version-%release
Requires: %name-audiocd = %version-%release
Requires: %name-kmix = %version-%release
Requires: %name-kscd = %version-%release
Requires: %name-videothumbnail = %version-%release


Source00: dragon-%version.tar
Source01: juk-%version.tar
Source02: ffmpegthumbs-%version.tar
Source03: kmix-%version.tar
Source04: kscd-%version.tar
Source05: audiocd-kio-%version.tar

# ALT
#

BuildRequires(pre): kde4base-workspace-devel
BuildRequires: gcc-c++ libcdparanoia-devel
BuildRequires: libmusicbrainz3-devel libtunepimp-devel libflac-devel
BuildRequires: libmad-devel libvorbis-devel libtheora-devel libspeex-devel
BuildRequires: libxine-devel >= 1.1.9
BuildRequires: libsamplerate-devel libtag-devel libfreebob-devel
BuildRequires: libjpeg-devel bzlib-devel libpulseaudio-devel glib2-devel libxine-devel
#BuildRequires: libcdda-devel
BuildRequires: libalsa-devel
BuildRequires: libcanberra-devel
BuildRequires: libavcodec-devel libavformat-devel libavutil-devel libavdevice-devel libswscale-devel libpostproc-devel
#BuildRequires: libgstreamer-plugins-base-devel
BuildRequires: kde4base-workspace-devel
BuildRequires: libkcompactdisc4-devel libkcddb4-devel desktop-file-utils

%description
* kmix: the audio mixer as a standalone program and Kicker applet
* kscd: A CD player with an interface to the internet CDDB database
* phonon-xine: A Phonon-Backend based on Xine
* kfile-plugins: provide meta information about sound files
* libkcddb: a library for retrieving and sending cddb information


%package common
Summary: %name common package
Group: Graphical desktop/KDE
Requires: kde-common >= %major.%minor
Conflicts: kdemultimedia-common <= 3.5.12-alt1
%description common
%name common package

%package core
Summary: Core files for %name
Group: Graphical desktop/KDE
Requires: %name-common = %version-%release
%description core
Core files for %name

%package dragonplayer
Group: Video
Summary: Video Player for KDE
Requires: %name-core = %version-%release
%description dragonplayer
Video Player for KDE

%package juk
Group: Sound
Summary: KDE music player, jukebox, tagger and music collection manager
Requires: %name-core = %version-%release
%description juk
Juk is well, a jukebox.  As is typical with many jukebox
applications, Juk allows you to edit the tags of the
audio files, and manage your collection and playlists.

%package audiocd
Group: Sound
Summary: KDE audiocd ioslave
Requires: %name-core = %version-%release
%description audiocd
Audiocd ioslave

%package -n libaudiocdplugins4
Group: System/Libraries
Summary: KDE 4 library
Requires: %name-common = %version-%release
%description -n libaudiocdplugins4
KDE 4 library

%package kmix
Group: Sound
Summary: KDE sound mixer applet
Requires: %name-core = %version-%release
%description kmix
A sound mixer applet for KDE.
%name allows you to control the volumes of your
sound card from a KDE panel applet.

%package kscd
Group: Sound
Summary: KDE Audio-CD player
Requires: %name-core = %version-%release
Requires: %name-audiocd
%description kscd
KSCD is an Audio-CD player for KDE

%package videothumbnail
Group: Video
Summary: Video thumbnail generator
Requires: %name-common = %version-%release
%description videothumbnail
Video thumbnail generator for all KDE file managers

%package -n libkcddb4
Group: System/Libraries
Summary: KDE 4 library
Requires: %name-common = %version-%release
%description -n libkcddb4
KDE 4 library

%package -n libkcompactdisc4
Group: System/Libraries
Summary: KDE 4 library
Requires: %name-common = %version-%release
%description -n libkcompactdisc4
KDE 4 library

%package devel
Group: Development/KDE and QT
Summary: Devel stuff for %name
Requires: kde4libs-devel
Requires: libkcompactdisc4-devel libkcddb4-devel
Requires: %name-common = %version-%release
%description devel
This package contains header files needed if you wish to build applications
based on %name.


%prep
%setup -q -cT -n %rname-%version -a0 -a1 -a2 -a3 -a4 -a5
ls -d1 * | \
while read d
do
    [ -d "$d" ] || continue
    newdirname=`echo "$d"| sed 's|-%version$||'`
    [ "$d" == "$newdirname" ] || mv $d $newdirname
done

ls -d1 * | \
while read d
do
    [ "$d" == "${d#lib}" ] || continue
    [ -d "$d" ] || continue
    echo "add_subdirectory($d)" >> CMakeLists.txt
done


%build
ls -d1 * | \
while read d ; do
[ -d "$d" ] || continue
pushd $d
%K4build \
    -DKDE4_ENABLE_FPIE:BOOL=ON
popd
done


%install
ls -d1 * | \
while read d ; do
[ -d "$d" ] || continue
pushd $d
%K4install
popd
done

# fix desktop files
for app in kscd juk
do
    desktop-file-install \
	--mode=0755 \
	--dir %buildroot/%_K4xdg_apps \
	--add-category=Audio \
	--remove-category=AudioVideo \
	%buildroot/%_K4xdg_apps/$app.desktop
done

%files
%files common
#%doc README

%files core
#%_K4conf_update/*
%_K4iconsdir/oxygen/*/*/*.*
%_K4iconsdir/hicolor/*/*/*.*

%files videothumbnail
%_K4lib/ffmpegthumbs.so
%_K4srv/ffmpegthumbs.desktop

%files dragonplayer
%_K4bindir/dragon
%_K4lib/dragonpart.so
%_K4apps/dragonplayer/
%_K4apps/solid/actions/dragonplayer-opendvd.desktop
%_K4xdg_apps/dragonplayer.desktop
%_K4srv/ServiceMenus/dragonplayer_*
%_K4srv/dragonplayer_part.desktop
%_K4conf/dragonplayerrc
%_K4doc/*/dragonplayer

%files juk
%_K4bindir/juk
%_K4apps/juk/
%_K4xdg_apps/juk.desktop
%_K4srv/ServiceMenus/jukservicemenu.desktop
%_K4doc/*/juk

%files audiocd
%_K4lib/kcm_audiocd.so
%_K4lib/kio_audiocd.so
%_K4lib/libaudiocd_*
%_K4apps/konqsidebartng/virtual_folders/services/audiocd.desktop
%_K4apps/solid/actions/solid_audiocd.desktop
%_K4cfg/audiocd_*
%_K4srv/audiocd.desktop
%_K4srv/audiocd.protocol
%_K4doc/*/kioslave/audiocd/

%files kmix
%_K4bindir/kmix
%_K4bindir/kmixctrl
%_K4libdir/libkdeinit4_kmix*
%_K4lib/kded_kmixd.so
%_K4apps/kmix/
%_K4xdg_apps/kmix.desktop
%_K4start/restore_kmix_volumes.desktop
%_K4start/kmix_autostart.desktop
%_K4srv/kmixctrl_restore.desktop
%_K4srv/kded/kmixd.desktop
%_K4doc/*/kmix
#
%_K4lib/plasma_engine_mixer.so
%_K4apps/plasma/services/mixer.operations
%_K4srv/plasma-engine-mixer.desktop

%files kscd
%_K4bindir/kscd
#%_K4bindir/workman2cddb.pl
#%_K4apps/profiles/
%_K4apps/kscd/
%_K4xdg_apps/kscd.desktop
%_K4apps/solid/actions/kscd-play-audiocd.desktop
%_K4cfg/kscd.kcfg
#%_K4doc/*/kscd

%files -n libaudiocdplugins4
%_K4libdir/libaudiocdplugins.so.*

%files devel
%_K4link/lib*.so
%_K4includedir/*
%_K4dbus_interfaces/*.xml

%changelog
