%define _keep_libtool_files 1
%define ruby 0

%define unstable 0
%define _optlevel s
%if %unstable
%define _optlevel 0
%endif

%define qtruby_docdir %_docdir/ruby-qt-%version
%define korundum_docdir %_docdir/ruby-korundum-%version
%add_findpackage_path %_K3bindir

Name: kdebindings
Version: 3.5.13.2
Release: alt1.M70P.1

Summary: bindings to KDE libraries for various programming languages 
Group: Graphical desktop/KDE
URL: http://www.kde.org
License: GPLv2 LGPL

Requires: %name-perl-DCOP = %version-%release
%if %ruby
Requires: %name-ruby-qt = %version-%release
Requires: %name-ruby-korundum = %version-%release
%endif
Requires: %name-kjsembed = %version-%release
Requires: %name-xparts = %version-%release


Source0: %name-%version.tar
# ALT
Patch1: kdebindings-3.5.12-alt-fix-compile.patch
Patch2: kdebindings-3.5.12-alt-perl-ccflags.patch
#
Patch5: kdebindings-3.5.10-alt-ruby-getopts.patch
Patch6: kdebindings-3.5.12-alt-ruby-paths.patch
Patch7: kdebindings-3.5.10-alt-ruby-compile.patch
Patch8: kdebindings-3.5.13.2-trinityHomeToKDE.patch
Patch9: tde-3.5.13-build-defdir-autotool.patch

BuildRequires(pre): kdelibs-devel gtk+-devel libgtk+2-devel
BuildRequires: kdebase-devel libstdc++-devel gcc-c++ libjpeg-devel perl-devel libpng-devel
BuildRequires: xml-utils ruby libssl-devel libruby-devel

%description
This is the KDE bindings package.

%package common
Summary: Common empty package for %name
Group: Graphical desktop/KDE
Requires: kde-common >= 3.5
#
%description common
Common empty package for %name

%package devel
Summary: Devel stuff for kdepim
Group: Development/KDE and QT
Requires: %name-common = %version-%release
Requires: kdelibs-devel >= %{get_version kdelibs-devel}
%if %ruby
Requires: %name-ruby-qt-doc = %version-%release
Requires: %name-ruby-qt-devel = %version-%release
Requires: %name-ruby-korundum-doc = %version-%release
%endif
Requires: %name-kjsembed-devel = %version-%release
%description devel
Development files and headers for %name
%description devel -l ru_RU.UTF-8
Файлы для разработки приложений с %name

%package perl-DCOP
Summary: Perl module for DCOP
Summary(ru_RU.UTF-8): Модуль Perl для DCOP
Group: Development/Perl
Requires: %name-common = %version-%release
%description perl-DCOP
Perl module which allows to create DCOP clients and servers.
DCOP is a KDE protocol for programmatic access to
applications data and methods
%description perl-DCOP -l ru_RU.UTF-8
Модуль Perl, позволяющий создавать клиентские и серверные приложения
DCOP. DCOP - это используемый в KDE протокол для программного доступа
к данным и методам приложений

%package ruby-qt
Summary: Qt bindings for Ruby
Summary(ru_RU.UTF-8): Расширение Ruby для использования библиотеки Qt
Group: Development/Ruby
Requires: %{get_dep libqt3}
Requires: %name-common = %version-%release
Provides: ruby-module-qt = %version-%release
Obsoletes: ruby-module-qt < %version-%release
%description ruby-qt
This package contains Ruby modules and service programs to create
applications with Qt GUI.
%description ruby-qt -l ru_RU.UTF-8
Данный пакет содержит модули языка Ruby и вспомогательные приложения,
которые позволяют создавать на Ruby приложения с графическим
интерфейсом, построенным на Qt.

%package ruby-qt-doc
Summary: Documentation and examples for Qt Ruby bindings
Summary(ru_RU.UTF-8): Документация и примеры к расширению Qt для Ruby
Group: Development/Ruby
Requires: %name-common = %version-%release
Provides: ruby-module-qt-doc = %version-%release
Obsoletes: ruby-module-qt-doc < %version-%release
%description ruby-qt-doc
Documentation and examples for Qt Ruby bindings
%description ruby-qt-doc -l ru_RU.UTF-8
Документация и примеры к расширению Qt для Ruby

%package ruby-qt-devel
Summary: Development files for ruby-qt
Group: Development/Ruby
#Requires: ruby-qt = %version-%release
Requires: %name-common = %version-%release
Provides: ruby-module-qt-devel = %version-%release
Obsoletes: ruby-module-qt-devel < %version-%release
%description ruby-qt-devel
This package contains utility files for ruby-qt package
%description ruby-qt-devel -l ru_RU.UTF-8
Этот пакет содержит утилиты для пакета ruby-qt

%package ruby-korundum
Summary: KDE bindings for Ruby
Summary(ru_RU.UTF-8): Расширение Ruby для использования библиотек KDE
Provides: korundum = %version-%release
Group: Development/Ruby
Requires: kdelibs >= %{get_version kdelibs}
Requires: %name-common = %version-%release
Provides: ruby-module-korundum = %version-%release
Obsoletes: ruby-module-korundum < %version-%release
%description ruby-korundum
This package contains Ruby modules and service programs to create
applications built upon KDE interface and technologies.
with KDE GUI.
%description ruby-korundum -l ru_RU.UTF-8
Данный пакет содержит модули языка Ruby и вспомогательные приложения,
которые позволяют создавать на Ruby приложения с использованием интерфейса
и технологий среды KDE.

%package ruby-korundum-doc
Summary: Documentation and examples for Korundum
Summary(ru_RU.UTF-8): Документация и примеры для Korundum
Provides: korundum = %version-%release
Group: Development/Ruby
Requires: %name-common = %version-%release
Provides: ruby-module-korundum-doc = %version-%release
Obsoletes: ruby-module-korundum-doc < %version-%release
%description ruby-korundum-doc
Documentation and examples for Korundum
%description ruby-korundum -l ru_RU.UTF-8
Документация и примеры для Korundum

%package kjsembed-devel
Summary: Development files and headers for kjsembed
Summary(ru_RU.UTF-8): Заголовочные и другие файлы для разработки приложений с kjsembed
Group: Development/KDE and QT
Requires: %name-common = %version-%release
%description kjsembed-devel
Development files and headers for kjsembed
%description kjsembed-devel -l ru_RU.UTF-8
Заголовочные и другие файлы для разработки приложений с kjsembed

%package kjsembed
Summary: KJS Javascript command line interpreter and utilities
Summary(ru_RU.UTF-8): Интерпретатор Javascript KJS и вспомогательные приложения
Group: Graphical desktop/KDE
Requires: kdelibs >= %{get_version kdelibs}
Requires: %name-common = %version-%release
Provides: libkjsembed = %version-%release
Obsoletes: libkjsembed < %version-%release
%description kjsembed
KJS Javascript command line interpreter and utilities
%description kjsembed -l ru_RU.UTF-8
Интерпретатор Javascript KJS (версия для командной строки) и вспомогательные
приложения.

%package xparts
Summary: XPart technology
Summary(ru_RU.UTF-8): XPart технология
Group: Graphical desktop/KDE
Requires: kdelibs >= %{get_version kdelibs}
Requires: %name-common = %version-%release
%description xparts
Currently XPart is more a proof of concept than a stabilized and maintained
technology. The only application using it is kmozilla, which makes the
Gecko html/browser (the one of mozilla) available as a kpart.
%description xparts -l ru_RU.UTF-8
На данный момент XPart больше концепция чем стабильная и поддерживаемая технология.
Может использоваться только с приложением kmozilla, которое делеает Gecko html/browser
(один из mozilla) доступным как kpart.

%prep
%setup -q
##cp -ar altlinux/admin ./

%patch1 -p1
%patch2 -p1
#
##%if %ruby
#%patch5 -p1
#%patch6 -p1
#%patch7 -p1
##%endif
%patch8 -p1
%patch9

sed -i '\|\${kdeinit}_LDFLAGS[[:space:]]=[[:space:]].*-no-undefined|s|-no-undefined|-no-undefined -Wl,--warn-unresolved-symbols|' admin/am_edit
for f in `find $PWD -type f -name Makefile.am`
do
    sed -i -e '\|_la_LDFLAGS.*[[:space:]]-module[[:space:]]|s|-module|-module \$(KDE_PLUGIN)|' $f
    #sed -i -e '\|_la_LDFLAGS.*[[:space:]]-no-undefined|s|-no-undefined|-no-undefined -Wl,--allow-shlib-undefined|' $f
    grep -q -e 'lib.*SOURCES' $f || continue
    RPATH_LINK_OPTS+=" -Wl,-rpath-link,`dirname $f`/.libs"
done
##sed -i "s|\(-Wl,--as-needed\)| $RPATH_LINK_OPTS \1|g" admin/acinclude.m4.in
##sed -i -e 's|\$USER_INCLUDES|-I%_includedir/tqtinterface \$USER_INCLUDES|' admin/acinclude.m4.in

find ./ -type f -name Makefile.am | \
while read f
do
    sed -i -e 's|\(.*_la_LIBADD[[:space:]]*\)=\(.*\)|\1= -lkdefx -lDCOP -lkdesu -lkdeinit_kded \$(LIB_KPARTS) \$(LIB_KHTML) \$(LIB_KIO) \$(LIB_KDEUI) \$(LIB_KDECORE) \$(LIB_QT) \2|' $f
done

cp -Rp /usr/share/libtool/aclocal/libtool.m4 admin/libtool.m4.in
cp -Rp /usr/share/libtool/config/ltmain.sh admin/ltmain.sh
make -f admin/Makefile.common cvs ||:

%build
%add_optflags -I%_includedir/tqtinterface
export QTDIR=%_qt3dir
export KDEDIR=%prefix
DO_NOT_COMPILE="python dcoppython kdejava"
%if %ruby
%else
export DO_NOT_COMPILE+=" smoke qtruby korundum"
%endif
export DO_NOT_COMPILE
export PATH=$QTDIR/bin:%_K3bindir:$PATH \
%K3configure \
    --enable-closure \
%if %unstable
    --enable-debug=full \
%else
    --disable-debug \
%endif
    --sysconfdir=%_sysconfdir \
    --without-java

# remove rpath
sed -i 's|LD_RUN_PATH=[^[:space:]][^[:space:]]*[[:space:]]||' dcopperl/Makefile
sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool

%make

%check
cd dcopperl
perl -Mblib -MDCOP -e1

%install
%if %unstable
%set_strip_method none
%endif
%make DESTDIR=%buildroot INSTALLDIRS=vendor bindir=%_bindir datadir=%_K3datadir install

%if %ruby
mkdir -p %buildroot/%qtruby_docdir
cp -pr qtruby/{AUTHORS,ChangeLog,README,README.1st} %buildroot/%qtruby_docdir/
cp -pr qtruby/rubylib/tutorial %buildroot/%qtruby_docdir/
cp -pr qtruby/rubylib/examples %buildroot/%qtruby_docdir/
cp -pr qtruby/rubylib/designer/examples %buildroot/%qtruby_docdir/designer_examples
mkdir -p %buildroot/%korundum_docdir
cp -pr korundum/{AUTHORS,ChangeLog,README,TODO} %buildroot%korundum_docdir
cp -pr korundum/rubylib/{tutorials,examples,templates} %buildroot%korundum_docdir
mkdir -p %buildroot/%korundum_docdir/rbkconfig_compiler
cp -pr korundum/rubylib/rbkconfig_compiler/{autoexample.rb,exampleprefs_base.kcfgc,kcfg.xsd,example.rb,myoptions_base.ui,TODO,example.kcfg,general_base.ui,README.dox} \
	%buildroot/%korundum_docdir/rbkconfig_compiler
%endif

%files
%files common
%files devel

%files perl-DCOP
##%perl_vendor_archlib/DCOP*
##%perl_vendor_autolib/DCOP
%perl_vendor_archlib/*

%if %ruby
%files ruby-qt
%docdir %qtruby_docdir
%qtruby_docdir/AUTHORS
%qtruby_docdir/ChangeLog
%qtruby_docdir/README
%qtruby_docdir/README.1st
%_bindir/rbuic
%_bindir/rbqtsh
%_bindir/rbqtapi
%_bindir/qtrubyinit
%_libdir/libsmokeqt.so.*
%ruby_sitearchdir/qtruby.so*
%ruby_sitearchdir/qui.so*
%ruby_sitelibdir/Qt*

%files ruby-qt-doc
%docdir %qtruby_docdir
%qtruby_docdir/tutorial
%qtruby_docdir/examples
%qtruby_docdir/designer_examples


%files ruby-qt-devel
%_K3includedir/smoke.h
%_libdir/libsmokeqt.so
%if %_keep_libtool_files
%_libdir/libsmokeqt.la
%endif

%files ruby-korundum
%docdir %korundum_docdir
%korundum_docdir/AUTHORS
%korundum_docdir/ChangeLog
%korundum_docdir/README
%korundum_docdir/TODO

%_bindir/rbkdesh
%_bindir/rbkdeapi
%_bindir/rbkconfig_compiler
%_bindir/krubyinit
%_libdir/libsmokekde.so.*
%ruby_sitearchdir/korundum.so*
%ruby_sitelibdir/Korundum.*
%ruby_sitelibdir/KDE

%files ruby-korundum-doc
%docdir %korundum_docdir
%korundum_docdir/tutorials
%korundum_docdir/examples
%korundum_docdir/templates
%korundum_docdir/rbkconfig_compiler
%endif

%files kjsembed-devel
%_libdir/libkjsembed.so
%_K3includedir/kjsembed
%if %_keep_libtool_files
%_libdir/libkjsembed.la
%endif

%files kjsembed
%doc kjsembed/README kjsembed/TODO
%_bindir/embedjs
#%_bindir/jsaccess
%_bindir/kjscmd

%_libdir/libkjsembed.so.*

%_K3xdg_apps/kjscmd.desktop
%_K3applnk/Utilities/embedjs.desktop
%_K3apps/embedjs
%_K3apps/kjsembed

%_man1dir/kjscmd.*

%_kde3_iconsdir/*/*/apps/embedjs.*

# Plugins
%_K3lib/libjavascript.so
%_K3lib/libjavascript.la
%_K3lib/lib*plugin.so
%_K3lib/lib*plugin.la
%_K3srv/*.desktop
%_K3srvtyp/*.desktop

# Kate plugin
%_K3apps/kate/scripts/*

%files xparts
%_bindir/shell_xparthost
%_bindir/xp_notepad
%_libdir/libkdexparts.so*
%_libdir/libgtkxparts.so*
%_libdir/libdcopc.so*
%_libdir/libxp_notepadpart.so
%_K3includedir/xkparts


%changelog
