%undefine __libtoolize
%define qtdir %_qt3dir
%define _optlevel s
%define _keep_libtool_files 1

%define unstable 0
%define gphoto 1
%define cmake 1

%add_findpackage_path %_K3bindir
%add_findprov_lib_path %_libdir/kde3

Name: kdegraphics
Version: 3.5.13.2
Release: alt2.M70P.1

Group: Graphical desktop/KDE
Summary: K Desktop Environment - Graphics
License: GPL
Url: http://www.kde.org/

Packager: Sergey V Turchin <zerg@altlinux.org>

Requires: %name-kamera = %version-%release
Requires: %name-kcoloredit = %version-%release
Requires: %name-kdvi = %version-%release
Requires: %name-kfax = %version-%release
Requires: %name-kfile = %version-%release
Requires: %name-kgamma = %version-%release
Requires: %name-kghostview = %version-%release
Requires: %name-kiconedit = %version-%release
Requires: %name-kmrml = %version-%release
Requires: %name-kooka = %version-%release
Requires: %name-kolourpaint = %version-%release
Requires: %name-kpdf = %version-%release
Requires: %name-kpovmodeler = %version-%release
Requires: %name-kruler = %version-%release
Requires: %name-ksnapshot = %version-%release
Requires: %name-ksvg = %version-%release
Requires: %name-kuickshow = %version-%release
Requires: %name-kview = %version-%release
Requires: %name-kviewshell = %version-%release
Requires: %name-libkscan = %version-%release

Source: kdegraphics-%version.tar
#Source: kdegraphics-3.0.98.tar.bz2
Source1: kdegraphics-kghostviewrc


# RH
Patch1: kdegraphics-3.3.0-misc.patch
Patch2: kdegraphics-3.3.1-xorg.patch
#
Patch4: kdegraphics-3.5.1-warning.patch
Patch5: kdegraphics-3.5.2-kpdf-xft.patch
# MDK
# ALT
Patch101: 3.5.12-fix-linking.patch
Patch102: kdegraphics-3.5.10-alt-fix-compile.patch
# Security
Patch302: security_01_CVE-2009-0945.diff
Patch303: security_02_CVE-2009-1709.diff
Patch304: xpdf-3.02-CVE-2010-3702.patch
Patch305: xpdf-3.02-CVE-2010-3704.patch
Patch306: tde-3.5.13-build-defdir.patch
Patch307: tde-3.5.13-build-poppler.patch
Patch308: kdegraphics-3.5.13.2-trinityHomeToKDE.patch

# Automatically added by buildreq on Tue Apr 13 2004 (-bi)
BuildRequires(pre): cmake glibc-core kdelibs-devel
BuildRequires: fontconfig-devel freetype2-devel
BuildRequires: gcc-c++ imlib-devel libart_lgpl-devel
BuildRequires: libieee1284-devel libjpeg-devel openexr-devel
BuildRequires: liblcms-devel libpng-devel libqt3-devel libsane-devel libstdc++-devel
BuildRequires: libtiff-devel libungif-devel libusb-devel pkg-config
BuildRequires: qt3-designer xml-utils zlib-devel
BuildRequires: libfribidi-devel fribidi t1lib-devel libpoppler-devel
BuildRequires: libacl-devel libattr-devel
BuildRequires: libXxf86vm-devel
BuildRequires: kdelibs >= %version kdelibs-devel >= %version
%if %gphoto
BuildRequires: libgphoto2-devel liblockdev-devel
%endif

%description
kdegraphics is a collection of graphic oriented applications:
 * kamera: digital camera io_slave for Konqueror. Together gPhoto this
          allows you to access your camera's picture with the URL camera:/
 * kcoloredit: contains two programs: a color value editor and also a color
               picker
 * kdvi: program (and embeddable KPart) to display *.DVI files from TeX
 * kfax: a program to display raw and tiffed fax images (g3, g3-2d, g4)
 * kfaxview: an embeddable KPart to display tiffed fax images
 * kfile-plugins: provide meta information for graphic files
 * kgamma: XFree86 Gamma correction KControl module.
 * kghostview: program (and embeddable KPart) to display *.PDF and *.PS
 * kiconedit: an icon editor
 * kmrml: A Konqueror plugin for searching pictures
 * kolourpaint: a simple pixel oriented image drawing program
 * kooka: a raster image scan program, based on SANE and libkscan
 * kpdf: a pdf viewer
 * kpovmodeler: A graphical editor for povray scenes
 * kruler: a ruler in inch, centimeter and pixel to check distances on the
           screen
 * ksnapshot: make snapshots of the screen contents
 * ksvg: SVG graphics viewer
 * kuickshow: fast and comfortable imageviewer
 * kview: picture viewer, provided as standalone program and embeddable KPart
 * kviewshell: generic framework for viewer applications

%package common
Summary: Common empty package for %name
Group: Graphical desktop/KDE
BuildArch: noarch
Requires: kde-common >= 3.2
Conflicts: kdegraphics <= 3.0
#
%description common
Common empty package for %name

%package kpdf
Summary: PDF viewer for KDE
Group: Graphics
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kpdf
A PDF file viewer for KDE.
In addition to being a standalone viewer application,
kpdf acts as a Konqueror plugin.

%package ksvg
Summary: KDE implementation of the SVG
Group: Publishing
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description ksvg
KDE implementation of the
Scalable Vector Graphics Specifications.

%package kgamma
Summary: Simple tool for monitor gamma correction
Group: Graphics
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
Provides: kgamma = %version-%release
Obsoletes: kgamma
#
%description kgamma
KGamma allows you to alter the monitor's gamma correction of XFree86.
But that's not all to do. For good results you have to set the
correct brightness, contrast and color balance of your monitor.

%package kamera
Summary: Digital camera support for KDE
Group: Graphics
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kamera
Kamera adds support for digital cameras to KDE.
After installing kamera, you can access your digital camera just like
a filesystem from KDE applications.

%package kcoloredit
Summary: KDE palette editor and color chooser
Group: Graphics
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kcoloredit
KDE palette editor and color chooser.
kcoloredit can be used by other programs (and scripts) to pick a color or
edit a palette.

%package kdvi
Summary: KDE DVI (TeX output) file viewer
Group: Publishing
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
Requires: ghostscript-utils
#
%description kdvi
A DVI (TeX output) file viewer for KDE.

%package kfax
Summary: KDE Fax viewer
Group: Communications
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kfax
A KDE viewer for incoming faxes

%package kfile
Summary: KFile module for reading graphical files information
Group: File tools
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
Provides: %name-kfile-png = %version-%release
Obsoletes: kdegraphics-kfile-png
#
%description kfile
The KFile plugin allows all applications using KFile (e.g. Konqueror) to view
information on bmp,dvi,gif,ico,jpeg,pcx,pdf,png,pnm,ps,tga,tiff,xbm files.

%package kghostview
Summary: PostScript viewer for KDE
Group: Publishing
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
Requires: ghostscript-module-X
#
%description kghostview
A PostScript file viewer for KDE.
In addition to being a standalone viewer application,
kghostview acts as a Konqueror plugin.

%package kiconedit
Summary: An icon editor for creating KDE icons
Group: Graphics
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kiconedit
An icon editor for creating KDE icons

%package kmrml
Summary: MRML for KDE -- Content based image retrieval
Group: Graphics
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kmrml
MRML is short for Multimedia Retrieval Markup Language,
which defines a protocol for querying a server for images
based on their content. See http://www.mrml.net about MRML
and the GNU Image Finding Tool (GIFT), an MRML server.

This package consists of an mrml kio-slave that handles
the communication with the MRML server and a KPart to
be embedded e.g. into Konqueror.

%package kooka
Summary: KDE scanner application
Group: Graphics
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kooka
Kooka is a KDE application for previewing, cutting and receiving images
from a scanner.

%package kolourpaint
Summary: A paint program for KDE
Group: Graphics
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kolourpaint
A paint program for KDE.

%package kpovmodeler
Summary: A graphical editor for povray scenes for KDE
Group: Graphics
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
Requires: povray
#
%description kpovmodeler
KPovModeler is a graphical editor for povray scenes.

%package kruler
Summary: A screen ruler and color measurement tool
Group: Graphics
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kruler
A screen ruler and color measurement tool

%package ksnapshot
Summary: A KDE applet for taking snapshots of the desktop
Group: Graphics
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description ksnapshot
A KDE applet for taking screenshots.
ksnapshot allows both capturing the whole desktop and capturing just
the active window.

%package kuickshow
Summary: Quick picture viewer for KDE
Group: Graphics
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kuickshow
Kuickshow is a picture viewer for KDE. It displays the directory structure,
displaying images as thumbnails.
Clicking on an image shows the image in its normal size.

%package kview
Summary: KDE Image Viewer
Group: Graphics
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kview
KView is a KDE image viewer, supporting a wide range of graphics file formats.

%package kviewshell
Summary: Plugin integration for KView
Group: Graphics
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
Requires: %name-kview
#
%description kviewshell
KViewShell allows the kview image viewer to be embedded into other KDE
applications.

%package libkscan
Summary: KDE library for scanner support
Group: Graphics
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description libkscan
Library to access scanners used by kooka (and koffice)

%package devel
Summary: Include files for kdegraphics
Group: Development/KDE and QT
Requires: %name-common = %version-%release
Requires: %name-ksvg = %version-%release
Requires: %name-kviewshell = %version-%release
Requires: %name-libkscan = %version-%release
#
%description devel
This package contains include files needed to build applications
based on kdegraphic.

%prep
%setup -q -n kdegraphics-%version
%patch1 -p1
%patch2 -p1
#
%patch4 -p1
%patch5 -p1
#
%patch101 -p1
###%patch102 -p1
#
%patch302 -p1
%patch303 -p1
pushd kpdf/xpdf
%patch304 -p0
%patch305 -p0
popd
%patch306
###%patch307
%patch308 -p1

%if %cmake
%else
sed -i '\|\${kdeinit}_LDFLAGS[[:space:]]=[[:space:]].*-no-undefined|s|-no-undefined|-no-undefined -Wl,--warn-unresolved-symbols|' admin/am_edit
for f in `find $PWD -type f -name Makefile.am`
do
    sed -i -e '\|_la_LDFLAGS.*[[:space:]]-module[[:space:]]|s|-module|-module \$(KDE_PLUGIN)|' $f
    #sed -i -e '\|_la_LDFLAGS.*[[:space:]]-no-undefined|s|-no-undefined|-no-undefined -Wl,--allow-shlib-undefined|' $f
    grep -q -e 'lib.*SOURCES' $f || continue
    RPATH_LINK_OPTS+=" -Wl,-rpath-link,`dirname $f`/.libs"
done
sed -i "s|\(-Wl,--as-needed\)| $RPATH_LINK_OPTS \1|g" admin/acinclude.m4.in
sed -i -e 's|\$USER_INCLUDES|-I%_includedir/tqtinterface \$USER_INCLUDES|' admin/acinclude.m4.in

find ./ -type f -name Makefile.am | \
while read f
do
    sed -i -e 's|\(.*_la_LIBADD[[:space:]]*\)=\(.*\)|\1= \$(LIBART_LIBS) -lfontconfig -lkdefx -lkdeinit_kded -lDCOP \$(LIB_KDEPRINT) \$(LIB_KPARTS) \$(LIB_KHTML) \$(LIB_KIO) \$(LIB_KDEUI) \$(LIB_KDECORE) \$(LIB_QT) \2|' $f
done
make -f admin/Makefile.common cvs ||:
%endif

%build
rm -rf %buildroot
export QTDIR=%qtdir
export KDEDIR=%_K3prefix

export PATH=$QTDIR/bin:$KDEDIR/bin:$PATH
export PKG_CONFIG_PATH=%_libdir/pkgconfig
export LD_LIBRARY_PATH=$QTDIR/%_lib:$KDEDIR/%_lib:$LD_LIBRARY_PATH
export LDFLAGS="-L%buildroot/%_libdir -L%buildroot/%_libdir/kde3 -L%_libdir"

%add_optflags -fpermissive

%if %cmake
BD=%_builddir/%name-%version/BUILD

if ! [ -f $BD/CMakeCache.txt ]
then
%K3cmake \
    -DCMAKE_BUILD_TYPE=RelWithDebInfo \
    -DWITH_T1LIB=ON \
    -DWITH_LIBPAPER=ON \
    -DWITH_TIFF=ON \
    -DWITH_OPENEXR=ON \
    -DWITH_PDF=ON \
    -DBUILD_ALL=ON
fi
%K3make

%else
# else if cmake

%K3configure \
%if %unstable
    --enable-debug=full \
%else
    --disable-debug \
%endif
    --enable-final \
%if %gphoto
    --with-kamera \
%else
    --without-kamera \
%endif
    --with-openexr \
    --enable-multithreaded-kpdf
#    --with-poppler \

sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
%make_build

%endif
# end if cmake

%install
%if %unstable
%set_strip_method none
%endif

%K3install

%if %cmake
install -dm 0755 %buildroot/%_kde3_iconsdir/
mv %buildroot/%_iconsdir/hicolor %buildroot/%_kde3_iconsdir/hicolor/

install -dm 0755 %buildroot/%_K3applnk/Graphics/
install -m 0644 %buildroot/%_K3xdg_apps/kruler.desktop %buildroot/%_K3applnk/Graphics/kruler.desktop

%endif

install -d %buildroot/%_K3conf/
install -m 0644 %SOURCE1 %buildroot/%_K3conf/kghostviewrc


%files
%files common
%_K3conf/*
%_K3cfg/*

%files ksvg
%_K3bindir/printnodetest
%_K3bindir/svgdisplay
%_K3lib/libksvgplugin.so*
%_K3lib/libksvgrendererlibart.so*
%_K3lib/svgthumbnail.so*
%_K3libdir/libksvg.so*
%_K3libdir/libtext2path.so*
%_K3apps/ksvg
%_K3srv/ksvglibartcanvas.desktop
%_K3srv/ksvgplugin.desktop
%_K3srv/svgthumbnail.desktop
%_K3srvtyp/ksvgrenderer.desktop

%files kpdf
%_K3bindir/kpdf
%_K3lib/libkpdfpart.so*
%_K3apps/kpdf
%_K3apps/kpdfpart
%_K3srv/kpdf_part.desktop
%_kde3_iconsdir/hicolor/*/apps/kpdf.*
%_K3doc/en/kpdf
%_K3xdg_apps/kpdf.desktop

%files kgamma
%_K3bindir/xf86gammacfg
%_K3lib/kcm_kgamma.so*
%_K3apps/kgamma
%_kde3_iconsdir/hicolor/*/apps/kgamma.*
%_K3doc/en/kgamma
%_K3xdg_apps/kgamma.desktop

%files kamera
%_K3lib/*kamera*.so*
%_K3iconsdir/crystalsvg/*/*/camera*
%_K3srv/camera.protocol
%doc %_K3doc/en/kamera
%_K3xdg_apps/kamera.desktop

%files kcoloredit
%_K3bindir/kcoloredit
%_K3bindir/kcolorchooser
#%_K3libdir/kcolorchooser*
%_K3apps/kcoloredit
%_kde3_iconsdir/hicolor/*/apps/kcoloredit.png
%_kde3_iconsdir/hicolor/*/apps/kcolorchooser.png
%doc %_K3doc/en/kcoloredit
%_K3xdg_apps/kcoloredit.desktop
%_K3xdg_apps/kcolorchooser.desktop

%files kdvi
%_K3bindir/kdvi
%_K3lib/kdvipart.so*
%_K3xdg_apps/kdvi.desktop
%_K3apps/kdvi
%_K3srv/kdvimultipage.desktop
%_kde3_iconsdir/hicolor/*/apps/kdvi.*
%doc %_K3doc/en/kdvi

%files kfax
%_K3bindir/kfax
#%_K3lib/kfaxpart.*
%_kde3_iconsdir/hicolor/*/apps/kfax.*
%_K3xdg_apps/kfax.desktop
%_K3apps/kfax
#
%_K3bindir/kfaxview
%_K3xdg_apps/kfaxview.desktop
%_K3libdir/libkfaximage.so*
%_K3lib/kfaxviewpart.so*
%_K3apps/kfaxview/
%_kde3_iconsdir/hicolor/*/apps/kfaxview.*
%_K3srv/kfaxmultipage.desktop
%_K3srv/kfaxmultipage_tiff.desktop

%files kfile
%_K3lib/kfile_*.so*
%_K3srv/kfile_*.*
%_K3libdir/libpoppler-tqt.so*

%files kghostview
%_K3bindir/kghostview
%_K3libdir/libkghostviewlib.so*
%_K3lib/libkghostviewpart.so*
%_K3lib/gsthumbnail.so*
#%config %_datadir/config/kghostviewrc
%_K3apps/kconf_update/kghostview.upd
%_K3apps/kconf_update/update-to-xt-names.pl
%_K3apps/kghostview
%_K3srv/gsthumbnail.desktop
%_K3srv/kghostview_part.desktop
%_kde3_iconsdir/hicolor/*/apps/kghostview.png
%_K3xdg_apps/kghostview.desktop
%doc %_K3doc/en/kghostview

%files kiconedit
%_K3apps/kiconedit
%_kde3_iconsdir/hicolor/*/apps/kiconedit.png
%_K3xdg_apps/kiconedit.desktop
%_K3bindir/kiconedit
%doc %_K3doc/en/kiconedit

%files kmrml
%_K3bindir/mrmlsearch
%_K3libdir/libkdeinit_mrmlsearch.so*
%_K3lib/kcm_kmrml.so*
%_K3lib/kded_daemonwatcher.so*
%_K3lib/kio_mrml.so*
%_K3lib/libkmrmlpart.so*
%_K3lib/mrmlsearch.so*
%_K3apps/konqueror/servicemenus/mrml-servicemenu.desktop
%_K3mimelnk/text/mrml.desktop
%_K3srv/kded/daemonwatcher.desktop
%_K3srv/mrml.protocol
%_K3srv/mrml_part.desktop
%_K3xdg_apps/kcmkmrml.desktop

%files kooka
%_K3bindir/kooka
#%_datadir/config/kookarc
%_K3apps/kooka
%_K3xdg_apps/kooka.desktop
%doc %_K3doc/en/kooka

%files kolourpaint
%doc kolourpaint/COPYING kolourpaint/NEWS kolourpaint/README kolourpaint/VERSION
%_K3bindir/kolourpaint
%_K3apps/kolourpaint
%_kde3_iconsdir/hicolor/*/apps/kolourpaint.*
%_K3xdg_apps/kolourpaint.desktop
%doc %_K3doc/en/kolourpaint

%files kpovmodeler
%_K3bindir/kpovmodeler
%_K3libdir/libkpovmodeler.so*
%_K3lib/libkpovmodelerpart.so*
%_K3apps/kpovmodeler
%doc %_K3doc/en/kpovmodeler
%_kde3_iconsdir/hicolor/*/apps/kpovmodeler.*
%_K3iconsdir/crystalsvg/*/*/kpovmodeler_doc.png
%_K3xdg_apps/kpovmodeler.desktop

%files kruler
%_kde3_iconsdir/hicolor/*/apps/kruler.png
%_K3apps/kruler
%_K3bindir/kruler
%doc %_K3doc/en/kruler
%_K3applnk/Graphics/kruler.desktop
%_K3xdg_apps/kruler.desktop

%files ksnapshot
%_K3bindir/ksnapshot
%_kde3_iconsdir/hicolor/*/apps/ksnapshot.*
%_K3xdg_apps/ksnapshot.desktop
%doc %_K3doc/en/ksnapshot

%files kuickshow
%_K3bindir/kuickshow
%_K3libdir/libkdeinit_kuickshow.so*
%_K3lib/kuickshow.so*
%_kde3_iconsdir/hicolor/*/apps/kuickshow.png
%_K3xdg_apps/kuickshow.desktop
%_K3apps/kuickshow
%doc %_K3doc/en/kuickshow

%files kview
%_K3bindir/kview
%_K3libdir/libkimageviewer.so*
%_K3libdir/libkdeinit_kview.so*
%_K3lib/libphotobook.so*
%_K3lib/kview.so*
%_K3lib/kcm_kview*.so*
#%_K3libdir/libkviewsupport.*
%_K3lib/kviewerpart.so*
%_K3lib/kview_*plugin.so*
%_K3lib/libkviewcanvas.so*
%_K3lib/libkviewviewer.so*
%_K3apps/photobook/
%_K3apps/kview
%_K3apps/kviewviewer
%_kde3_iconsdir/hicolor/*/apps/kview.png
%_K3srv/kviewviewer.desktop
%_K3srv/kviewcanvas.desktop
%_K3srv/kconfiguredialog/kview*
%_K3srv/photobook.desktop
%_K3srvtyp/kimageviewer.desktop
%_K3srvtyp/kimageviewercanvas.desktop
%_K3iconsdir/crystalsvg/*/apps/photobook.*
%doc %_K3doc/en/kview
%_K3xdg_apps/kview.desktop

%files kviewshell
%_K3bindir/kviewshell
%_K3libdir/libkmultipage*.so*
%_K3libdir/libdjvu.so*
%_K3lib/emptymultipagepart.so*
%_K3lib/djvuviewpart.so*
%_K3apps/djvumultipage.rc
%_K3apps/kviewshell
%_K3apps/kviewerpart
%_K3srv/djvumultipage.desktop
%_K3srv/emptymultipage.desktop
%_K3srvtyp/kmultipage.desktop
%_K3iconsdir/crystalsvg/*/*/kviewshell.png

%files libkscan
%_K3libdir/libkscan*.so*
%_K3iconsdir/crystalsvg/*/*/palette_color.png
%_K3iconsdir/crystalsvg/*/*/palette_gray.png
%_K3iconsdir/crystalsvg/*/*/palette_halftone.png
%_K3iconsdir/crystalsvg/*/*/palette_lineart.png
%_K3srv/scanservice.desktop

%files devel
%if %_keep_libtool_files
%_K3libdir/*.la
%_K3lib/*.la
%endif
%_K3includedir/*.h
%_K3includedir/dom/*.h
%_K3includedir/libtext2path*/
%_K3includedir/ksvg/
%_K3includedir/kviewshell/
%_pkgconfigdir/poppler-tqt.pc


%changelog
