
%undefine __libtoolize
%define _keep_libtool_files 1
%define _optlevel s
%define versioning_hack 1
%define unstable 0
%define bad_doc 0
%define arts 1
%define cmake 1

%define qtdir %_qt3dir

%add_findpackage_path %_K3bindir
%add_findprov_lib_path %_K3lib
#set_perl_req_method relaxed
%add_findreq_skiplist %_K3apps/dcopidlng/*
%add_findprov_skiplist %_K3apps/dcopidlng/*
%add_verify_elf_skiplist %_K3libdir/libkscreensaver.so*
%add_verify_elf_skiplist %_K3libdir/libkscreensaver.so.4.2.0
%add_findreq_skiplist %_K3bindir/fileshareset

%define major 3
%define minor 5
%define bugfix 13.2
%define rel alt2
Name: kdelibs
Version: %major.%minor.%bugfix
Release: %rel
#%define conflictver %major.%minor.%bugfix-alt0.0.1
%define conflictver 3.5.10-alt1
%define conflictver_kdevelop 3.5.3-alt0.0.1
%define reqver %major.%minor

Summary: K Desktop Environment - Libraries
Group: Graphical desktop/KDE
License: ARTISTIC BSD GPL_V2 LGPL_V2 QPL_V1.0
URL: http://www.kde.org/

Provides: kde-settings = %version-%release
Obsoletes: kde-settings < %version-%release
Provides: kde-settings-lite = %version-%release
Obsoletes: kde-settings-lite < %version-%release

%if %unstable
Requires: gdb
%endif
PreReq: kde-common >= %reqver
Requires: ca-certificates
Requires: libart_lgpl >= %{get_version libart_lgpl}
#Requires: %{get_dep libqt3}
%if %arts
#Requires: %{get_dep libarts-qtmcop}
%endif

# Conflicts for Main
Conflicts: kaffeine <= 0.4.3b-alt3.1
Conflicts: kmplayer <= 0.9.0c-alt1
Conflicts: openoffice <= 1.0.2-alt5
Conflicts: sim-common <= 1:0.9.4-alt8
Conflicts: kile <= 1.7.1-alt1.1.1

# Conflicts for old KDE
#Conflicts: kde-i18n-de < %conflictver kde-i18n-fr < %conflictver kde-i18n-he < %conflictver
#Conflicts: kde-i18n-et < %conflictver kde-i18n-ru < %conflictver kde-i18n-uk < %conflictver
Conflicts: kdevelop-common < %conflictver_kdevelop
Conflicts: kdeaccessibility-common < %conflictver
Conflicts: kdeaddons-common < %conflictver
Conflicts: kdeadmin-common < 1:%conflictver
Conflicts: kdeartwork-common < %conflictver
#Conflicts: kdebase-common < %conflictver kdebase-common < %version
Conflicts: kdebase-common < %conflictver
Conflicts: kdebindings-common < %conflictver
Conflicts: kdeedu-common < %conflictver
Conflicts: kdegames-common < %conflictver
Conflicts: kdegraphics-common < %conflictver
Conflicts: kdemultimedia-common < %conflictver
Conflicts: kdenetwork-common < %conflictver
Conflicts: kdepim-common < 1:%conflictver
Conflicts: kdetoys-common < %conflictver
Conflicts: kdeutils-common < %conflictver
Conflicts: kdesdk-common < %conflictver
Conflicts: kdewebdev-common < %conflictver


Source: kdelibs-%version.tar
#Source: kdelibs-3.3.92.tar
#
Source122: x-toc.desktop
Source123: x-icq.desktop
Source124: x-mplayer2.desktop

# MDK -> ALT
Patch01: kdelibs-3.1.94-iconssearch.patch
Patch02: kdelibs-3.5.12-kfiledialogbox.patch
#
Patch04: kdelibs-3.5.12-fix-cups-by-default.patch
Patch05: kdelibs-3.5.12-fix-default-spell-checker.patch
#
Patch07: kdelibs-3.4.0-fix-kcmshell-list.patch

# Gentoo
Patch10: kdelibs-3.5.12-libutempter.patch

# MDK
Patch30: kdelibs-3.2-remove-debug.patch
Patch31: kdelibs-3.5-fix-kde-default-font-value.patch

# SuSE
Patch1003: show-distribution.diff
#
Patch1007: kdeXrc-alt.patch
#
Patch1010: disable-idn-support.diff
#
Patch1020: x-jar-desktop.diff


# RH
Patch3009: kdelibs-3.1-ssl-krb5.patch
Patch3010: kdelibs-3.2-ALT-flash.patch
Patch3011: kdelibs-3.5.2-pcre.patch

# Sergey A. Sukiyazov <corwin@micom.don.ru>
Patch4600: kdelibs-3.1.2-fix-kprocio-def-codec.patch
Patch4601: kdelibs-3.5.12-alt-fix-kdoctools-mime-charset.patch

# misc

# ALT patches
Patch5001: kdelibs-3.5.12-alt-versioning-hack.patch
Patch5002: kdelibs-3.5-exists_exe.patch
Patch5003: kdelibs-3.5.12-alt-defaults.patch
Patch5004: kdelibs-3.5.12-alt-htmldocdir.patch
Patch5005: kdelibs-3.4.1-alt-dont-change-group.patch
Patch5006: kdelibs-3.5.12-alt-fix-build.patch
Patch5007: kdelibs-3.5.12-alt-fix-compile.patch
Patch5008: kdelibs-3.5.2-alt-maccyrillic.patch
Patch5009: kdelibs-3.5.12-alt-fix-linking.patch
#
Patch5011: kdelibs-3.5.12-alt_la2so_load_module.patch
Patch5012: kdelibs-3.5.12-alt_la2so.patch
Patch5013: kdelibs-3.1.4-alt-ldl.patch
Patch5014: kdelibs-3.1.4-alt-no_ltdl.patch
#
Patch5016: kdelibs-3.5.12-lang.patch
Patch5017: kdelibs-3.5.10-alt-lua51.patch
Patch5018: kdelibs-3.5.10-alt-xdg-autostart.patch
#
Patch5022: kded-3.5.12-applications.menu.patch
Patch5023: kdelibs-3.5.10-alt-automake.patch
Patch5024: kdesu-3.5.3-fix-exec.patch
#
Patch5026: kdecore-3.5.12-crystalsvg-default-icontheme.patch
Patch5027: kdelibs-3.3.0-fix-build.patch
Patch5028: kssl-3.5.10-libssl-name.patch
Patch5029: kio-3.2.3-subfs.patch
Patch5030: kdelibs-3.5.12-xdg-dirs.patch
Patch5031: kdelibs-3.5.0-alt-etc-sysconfig.patch
Patch5032: kdelibs-3.5.0-alt-locale-placement.patch
Patch5033: kdelibs-3.5.5-mark-user-edited.patch
#
Patch5035: kdelibs-3.5.6-alt-kurl-encoding.patch
Patch5036: kdelibs-3.5.7-alt-html-copypaste.patch
Patch5037: kdelibs-3.5.7-alt-browser-mailer-env.patch
Patch5038: kdelibs-3.5.7-alt-zip-dont-embed.patch
Patch5039: kdelibs-3.5.8-alt-pdf-dont-embed.patch
Patch5040: kdelibs-3.5.9-alt-ltdl-use-so.patch
Patch5041: kdelibs-3.5.12-alt-add-translations.patch
Patch5042: kdelibs-3.5.12-alt-menu-prefix-kde3.patch
Patch5043: tde-3.5.13-build-defdir.patch
Patch5044: tdelibs-3.5.13-work-defdir.patch
Patch5045: tde-3.5.13-trayIconScaleDis.patch
Patch5046: tde-3.5.13-SpellDialogSavePersonal.patch
Patch5047: tdelibs-3.5.13-CUPS_IPP-memoryleak.patch

# security patches
# end security patches

# Automatically added by buildreq on Thu Apr 08 2004 (-bi)
#BuildRequires: XFree86-devel XFree86-libs bzlib-devel doxygen fontconfig freetype2 gcc-c++ gcc-g77 glib2 kde-settings libalsa-devel libart_lgpl-devel libarts-devel libarts-qt-devel libcups-devel libjpeg-devel libldap-devel libpcre-devel libpcsclite-devel libpng-devel libqt3-devel libssl-devel libstdc++-devel libtiff-devel libutempter-devel libxml2-devel libxslt-devel netpbm qt3-designer qt3-doc su xml-utils zlib-devel
BuildRequires(pre): cmake kde-common-devel libtqt-devel libqt3-devel libart_lgpl-devel
BuildRequires: bzlib-devel doxygen aspell
BuildRequires: gcc-c++ libalsa-devel libcups-devel libltdl7-devel
BuildRequires: libjpeg-devel libldap-devel libpcre-devel
BuildRequires: libpng-devel libqt3-devel libssl-devel libstdc++-devel libtiff-devel
BuildRequires: libutempter-devel libxml2-devel libxslt-devel netpbm libnetpbm-devel
BuildRequires: qt3-doc xml-utils zlib-devel liblzma-devel libkrb5-devel libidn-devel
BuildRequires: libkrb5-devel libaspell-devel libacl-devel libattr-devel
BuildRequires: libavahi-qt3-devel pkg-config liblua5-devel libjasper-devel
BuildRequires: glibc-utils glibc-devel glib2-devel
BuildRequires: openexr-devel libXdmcp-devel libXcomposite-devel libgamin-devel
#BuildRequires: libqt3-devel-cxx = %__gcc_version_base
BuildRequires: libqt3 >= 3.2.0 libqt3-devel >= 3.2.0
BuildRequires: flex su sudo
%if %arts
BuildRequires: libarts-devel >= 1.5.8 libarts-qtmcop-devel >= 1.5.8
%endif
BuildRequires: djvu-common libgnutls-devel
# old
BuildRequires: openjade docbook-utils docbook-dtds
# hack against apt
#BuildRequires: libqt3-qsa > 3.0 libqt3-qsa-devel > 3.0

%description
Libraries for the K Desktop Environment.

%package devel
Group: Development/KDE and QT
Summary: Header files and documentation for compiling KDE applications
%if %arts
Requires: libarts-devel, libarts-qtmcop-devel
%endif
Requires: %name = %version-%release
Requires: libidn-devel libavahi-qt3-devel libart_lgpl-devel libpng-devel
Requires: kde-common-devel >= 0.2.0 libtqt-devel
Requires: libpcre-devel libacl-devel libattr-devel libutempter-devel
Requires: libXdmcp-devel libXcomposite-devel libXdamage-devel libxkbfile-devel libXtst-devel libXScrnSaver-devel
Requires: libXpm-devel libXxf86misc-devel libXxf86vm-devel libXt-devel imake xorg-cf-files
Provides: %name-devel-cxx = %__gcc_version_base

%description devel
This package includes the header files you will need to compile applications
for KDE. 

%package apidocs
Group: Development/KDE and QT
Summary: The KDE API Reference
Requires: %name-devel = %version

%description apidocs
This package included is the KDE %version API documentation
in HTML format for easy browsing.

%prep
%setup -q

%patch01 -p1
%patch02 -p1
#
%patch04 -p1
%patch05 -p1
#
%patch07 -p1
#
%patch10 -p1
#
%patch30 -p1
%patch31 -p1

%patch1003 -p0
#
# kderc
%patch1007 -p0
subst "s|kde@MAJOR@rc|kde%{major}rc|" kdecore/kconfigbackend.cpp
#
%patch1010 -p0
#
%patch1020 -p0

###%patch3009 -p1
%patch3010 -p1
###%patch3011 -p1

# corwin@micom.don.ru
%patch4600 -p1
%patch4601 -p1


# ALT
%patch5001 -p1
%patch5002 -p1 -b .exists_exe
%patch5003 -p1
%patch5004 -p1
%patch5005 -p1
###%patch5006 -p1
%patch5007 -p1
%patch5008 -p1
%patch5009 -p1
#
%patch5011 -p1
%patch5012 -p1
#%patch5013 -p1
#%patch5014 -p1
#
%patch5016 -p1
%patch5017 -p1
%patch5018 -p1
#
%patch5022 -p1 -b .menu
###%patch5023 -p1
# su exec
%patch5024 -p1
#
%patch5026 -p1
%if %bad_doc
%patch5027 -p1
%endif
%patch5028 -p1
%patch5029 -p1
%patch5030 -p1
%patch5031 -p1
%patch5032 -p1
%patch5033 -p1
#
%patch5035 -p1
%patch5036 -p1
%patch5037 -p1
%patch5038 -p1
%patch5039 -p1
%patch5040 -p1
%patch5041 -p1
%patch5042 -p1
%patch5043
%patch5044
%patch5045
%patch5046
%patch5047

# security
# end security

%if %versioning_hack
cat > kdecore/libkdecore_add.map <<__EOF__
CXX3 {
    global:
	extern "C++"  {
	    KApplication::KApplication*;
	    KConfig::KConfig*;
	    KLocale::KLocale*;
	    KURL::KURL*;
	    KAppDCOPInterface::KAppDCOPInterface*;
	    KAudioPlayer::KAudioPlayer*;
	};
};
__EOF__
%if %cmake
%else
grep -q -elibkdecore_la_LDFLAGS.*version-script kdecore/Makefile.am || \
perl -pi -e "s/(^libkdecore_la_LDFLAGS.*)/\1 -Wl,--version-script=libkdecore_add.map/" kdecore/Makefile.am
%endif
%endif

%if %cmake
%else
sed -i '\|\${kdeinit}_LDFLAGS[[:space:]]=[[:space:]].*-no-undefined|s|-no-undefined|-no-undefined -Wl,--warn-unresolved-symbols|' admin/am_edit
for f in `find $PWD -type f -name Makefile.am`
do
    sed -i -e '\|_la_LDFLAGS.*[[:space:]]-module[[:space:]]|s|-module|-module \$(KDE_PLUGIN) -Wl,--warn-unresolved-symbols|' $f
    #sed -i -e '\|_la_LDFLAGS.*[[:space:]]-no-undefined|s|-no-undefined|-no-undefined -Wl,--allow-shlib-undefined|' $f
    grep -q -e 'lib.*SOURCES' $f || continue
    RPATH_LINK_OPTS+=" -Wl,-rpath-link,`dirname $f`/.libs"
done
sed -i "s|\(-Wl,--as-needed\)| $RPATH_LINK_OPTS \1|g" admin/acinclude.m4.in
sed -i -e 's|\$USER_INCLUDES|-I%_includedir/tqtinterface \$USER_INCLUDES|' admin/acinclude.m4.in
make -f admin/Makefile.common cvs ||:
%endif

%build
%if %cmake
BD=%_builddir/%name-%version/BUILD

export LD_LIBRARY_PATH=$BD/kdecore:$BD/kdefx:$BD/kdeui:$BD/kio:$BD/dcop:$BD/kdesu:$BD/kwallet/client:$LD_LIBRARY_PATH
export PATH=%_K3bindir:$PATH
#add_optflags -DNEED_BZ2_PREFIX -DAVAHI_API_0_6 -I%_includedir/linux-libc-headers/include
export QTDIR=%qtdir
export LDFLAGS="-L%buildroot/%_libdir -L%buildroot/%_libdir/kde3 -L%qtdir/lib"
export DESTDIR=%buildroot
# export LIBDIR=/%_libdir/kde3

if ! [ -f $BD/CMakeCache.txt ]
then
%K3cmake \
    -DCMAKE_BUILD_TYPE=RelWithDebInfo \
    -DKDE_MALLOC=OFF \
    -DKDE_MALLOC_DEBUG=OFF \
    -DKDE_MALLOC_FULL=OFF \
%if %arts
    -DWITH_ARTS=ON \
%else
    -DWITH_ARTS=OFF \
%endif
    -DWITH_ALSA=ON \
    -DWITH_LIBART=ON \
    -DWITH_LIBIDN=OFF \
    -DWITH_SSL=ON \
    -DWITH_CUPS=ON \
    -DWITH_LUA=OFF \
    -DWITH_TIFF=ON \
    -DWITH_LZMA=ON \
    -DWITH_JASPER=ON \
    -DWITH_OPENEXR=ON \
    -DWITH_UTEMPTER=ON \
    -DWITH_AVAHI=ON \
    -DWITH_PCRE=ON \
    -DWITH_INOTIFY=OFF \
    -DWITH_GAMIN=OFF \
    -DWITH_ASPELL=ON \
    -DASPELL_DATADIR=%_libdir/aspell \
    -DWITH_HSPELL=OFF \
    -DKDE_DISTRIBUTION_TEXT="%distribution %_target_cpu"

#    -DDESTINATION="%distribution %_target_cpu" \

    # fix glibc functions detection
#    sed -i "s|.*#undef HAVE_STRLCAT_PROTO.*|#define HAVE_STRLCAT_PROTO 1|" $BD/config.h
#    sed -i "s|.*#undef HAVE_STRLCAT.*|#define HAVE_STRLCAT 1|" $BD/config.h
#    sed -i "s|.*#undef HAVE_STRLCPY_PROTO.*|#define HAVE_STRLCPY_PROTO 1|" $BD/config.h
#    sed -i "s|.*#undef HAVE_STRLCPY.*|#define HAVE_STRLCPY 1|" $BD/config.h
fi
%K3make

%else
# else if cmake

%add_optflags -I%_includedir/tqtinterface
export LD_LIBRARY_PATH=$QTDIR/%_lib:$LD_LIBRARY_PATH
export PATH=%_bindir:$PATH
#add_optflags -DNEED_BZ2_PREFIX -DAVAHI_API_0_6 -I%_includedir/linux-libc-headers/include
export QTDIR=%qtdir
export LDFLAGS="-L%buildroot/%_libdir -L%buildroot/%_libdir/kde3 -L%qtdir/lib"

if true
then
%K3configure \
		    --disable-gcc-hidden-visibility \
%if %unstable
                    --enable-debug=full \
%else
    		    --disable-debug \
                    --enable-final \
%endif
%if %arts
		    --with-arts \
%else
		    --without-arts \
%endif
		    --enable-fast-malloc=no \
                    --enable-mitshm \
                    --enable-cups \
                    --disable-libfam \
		    --enable-dnotify \
		    --enable-inotify \
		    --enable-sendfile \
		    --enable-openpty \
                    --enable-pcre \
		    --enable-dnssd \
                    --with-distribution="%distribution %_target_cpu" \
                    --with-alsa \
		    --with-rgbfile=%_x11x11dir/rgb.txt \
                    --x-includes=%_x11includedir \
                    --x-libraries=%_x11libdir
#		    --with-sudo-kdesu-backend \
fi
%make

%endif
# end if cmake

%install
%if %unstable
%set_strip_method none
%endif

%if %cmake
#export DESTDIR=%buildroot
%K3install

install -d -m0755 %buildroot/%_K3applnk
install -m0644 kioslave/iso/kio_iso.desktop %buildroot/%_K3applnk/
install -d -m0755 %buildroot/%_K3i18n
install -m0644 kdecore/all_languages.desktop %buildroot/%_K3i18n/all_languages
install -d -m0755 %buildroot/%_K3emo/Default
install -m0644 pics/emoticons/*.{png,xml} %buildroot/%_K3emo/Default

install -d -m0755 %buildroot/%_K3datadir/cmake
install -m0644 BUILD/kdelibs.cmake %buildroot/%_K3datadir/cmake/

ln -fs ../common %buildroot/%_K3doc/en/kspell/common

%else
# else if cmake
%K3install
%endif
# end if cmake

# move l10n files
#mkdir -p %buildroot/%_datadir/kde/locale
# mv %buildroot/%_datadir/locale/* %buildroot/%_datadir/kde/locale ||:
#if [ -d %buildroot/%_datadir/kde/locale/all_languages ]; then
#    rm -rf %buildroot/%_datadir/kde/locale/all_languages
#    > %buildroot/%_datadir/kde/locale/all_languages
#fi

# menu
mkdir -p %buildroot/%_kdeconfdir/xdg/menus/applications-merged/
mv %buildroot/%_sysconfdir/xdg/menus/applications.menu %buildroot/%_kdeconfdir/xdg/menus/applications-merged/

#if ls -1 %buildroot/%_iconsdir/hicolor/*/*/*.png
#then
#    for f in %buildroot/%_iconsdir/hicolor/*/*/*.png
#    do
#	newplace=`echo "$f"| sed "s|/hicolor/|/crystalsvg/|"`
#	[ -f "$newplace" ] || mv "$f" "$newplace"
#    done
#fi

# CA certificates bundle
[ -f %buildroot/%_K3apps/kssl/ca-bundle.crt ] || exit 1
ln -sf `relative %_datadir/ca-certificates/ca-bundle.crt %_K3apps/kssl/ca-bundle.crt` %buildroot/%_K3apps/kssl/ca-bundle.crt

# install crystal cursors
cp -ar altlinux/crystalcursors/* %buildroot/%_K3iconsdir/crystalsvg/


[ -f %buildroot/%_K3mimelnk/application/x-toc.desktop ] && exit 1
install -m0644 %SOURCE122 %buildroot/%_K3mimelnk/application/x-toc.desktop
[ -f %buildroot/%_K3mimelnk/application/x-icq.desktop ] && exit 1
install -m0644 %SOURCE123 %buildroot/%_K3mimelnk/application/x-icq.desktop
# resolve conflict with old djvu-common
[ -f %_K3mimelnk/image/x-djvu.desktop ] \
    && rm -f %buildroot/%_K3mimelnk/image/x-djvu.desktop ||:
# fix xcf mimetype
cp -ar %buildroot/%_K3mimelnk/image/x-xcf-gimp.desktop %buildroot/%_K3mimelnk/image/x-xcf.desktop
sed -i "s|^MimeType=.*|MimeType=image/x-xcf|" %buildroot/%_K3mimelnk/image/x-xcf.desktop

mkdir -p %buildroot/%_bindir
# symlinks to standart place
for n in kbuildsycoca kcmshell kcookiejar kde-config kded kdeinit kshell kwrapper meinproc
do
    ln -s `relative %_K3bindir/$n %_bindir/$n` %buildroot/%_bindir/$n
done


%files
%exclude %_kdeconfdir/xdg/menus/applications-merged/*
#
%_K3conf/*
#
%dir %_K3doc/en/
%doc %_K3doc/en/common/
%if !%bad_doc
%doc %_K3doc/en/kspell/

%endif
#
#
#
%_bindir/*
%_K3bindir/*
%exclude %_K3bindir/kgrantpty
#
%_K3libdir/*.so*
%_K3lib/*.so
#
%dir %_K3lib/plugins/
%dir %_K3lib/plugins/styles/
%_K3lib/plugins/styles/*.so
#
#
#
%_K3xdg_apps/kresources.desktop
%_K3applnk/kio_iso.desktop
%_K3apps/dcopidlng/
%_K3apps/kabc/
%_K3apps/kcm_componentchooser/
%_K3apps/kconf_update/
%_K3apps/kdeprint/
%_K3apps/kjava/
%_K3apps/kdeui/
%_K3apps/kdewidgets/
%_K3apps/khtml/
%_K3apps/kio_uiserver/
%_K3apps/knewstuff/
%_K3apps/knotify/
%_K3apps/konqueror/servicemenus/isoservice.desktop
%_K3apps/ksgmltools2/
%_K3apps/kssl/
%_K3apps/kstyle/
%_K3apps/ktexteditor_*/
%_K3apps/kcertpart/
%_K3apps/katepart/
%_K3apps/proxyscout/
%_K3start/*.desktop
#
%_iconsdir/crystalsvg
#
%_K3i18n/all_languages
#
%_K3mimelnk/magic
%_K3mimelnk/*/*.desktop
#
%dir %_K3emo
%_K3emo/Default
#
%dir %_K3srv/
%_K3srv/*.desktop
%_K3srv/*.kimgio
%_K3srv/*.protocol
#
%dir %_K3srv/kded
%_K3srv/kded/*.desktop
#
%dir %_K3srv/kresources
%_K3srv/kresources/kabc_*.desktop
%dir %_K3srv/kresources/kabc
%_K3srv/kresources/kabc/*.desktop
#
%dir %_K3srvtyp
%_K3srvtyp/*.desktop

%files devel
%_K3libdir/libkdefakes_nonpic.a
%_K3libdir/libkdefakes_pic.a
%_K3libdir/*.la
%_K3lib/*.la
%dir %_K3lib/plugins/designer/
%_K3lib/plugins/designer/*.so
%_K3lib/plugins/designer/*.la
#
%_K3includedir/*.h
#_K3includedir/*.pot
%_K3includedir/*.tcc
#
%if %arts
%_K3includedir/arts/
%endif
%_K3includedir/dnssd/
%_K3includedir/dom/
%_K3includedir/kdeprint/
%_K3includedir/kdesu/
%_K3includedir/khexedit
%_K3includedir/kio/
%_K3includedir/kjs/
%_K3includedir/kmdi/
%_K3includedir/kmediaplayer/
%_K3includedir/knewstuff/
%_K3includedir/kparts/
%_K3includedir/kresources
%_K3includedir/ksettings
%_K3includedir/kspell2/
%_K3includedir/ktexteditor/
%_K3includedir/kabc/
%_K3includedir/kate/
%_K3includedir/kunittest/
%_K3includedir/libkmid/
%_K3includedir/libkrandr/
%_K3includedir/libkrsync/
#
%if %cmake
%dir %_K3datadir/cmake
%_K3datadir/cmake/*.cmake
%endif

%files apidocs
#%doc %_K3doc/en/%name-*-apidocs

%changelog
