%undefine __libtoolize
%define qtdir %_qt3dir
%define _optlevel s
%define _keep_libtool_files 1

%define with_kmtrace 1
%define with_kunittest 1
%define unstable 0
%define cmake 1
%add_findpackage_path %_K3bindir
%add_findprov_lib_path %_K3lib
%add_findreq_skiplist %_K3bindir/kunittest_debughelper
%add_findreq_skiplist %_K3bindir/pprof2calltree

Name: kdesdk
Version: 3.5.13.2
Release: alt2
Packager: Sergey V Turchin <zerg at altlinux dot org>

Group: Development/KDE and QT
Summary: K Desktop Environment - Software Development Kit
Url: http://www.kde.org
License: GPL

Requires: %name-cervisia = %version-%release
Requires: %name-kio-svn = %version-%release
Requires: %name-kapptemplate = %version-%release
Requires: %name-kbabel = %version-%release
Requires: %name-kbugbuster = %version-%release
Requires: %name-kcachegrind = %version-%release
Requires: %name-kfile = %version-%release
%if %with_kmtrace
Requires: %name-kmtrace = %version-%release
%endif
Requires: %name-kompare = %version-%release
Requires: %name-kspy = %version-%release
Requires: %name-kuiviewer = %version-%release
Requires: %name-misc = %version-%release
Requires: %name-umbrello = %version-%release

Source: kdesdk-%version.tar
# ALT
Patch11: kdesdk-3.5.12-fix-linking.patch
Patch12: kdesdk-3.5.0-svn_libs.patch
Patch13: kdesdk-3.5.6-alt-find-libapr.patch
Patch14: kdesdk-3.5.13.2-trinityHomeToKDE.patch
Patch15: tde-3.5.13-build-defdir.patch
Patch16: kdesdk-3.5.13-fix-POD.patch

# Automatically added by buildreq on Thu Mar 18 2004 (-bi)
#BuildRequires: XFree86-devel XFree86-libs cvs flex fontconfig freetype2 gcc-c++ kde-settings kdelibs-devel less libarts-devel libdb4.2-devel libiberty-devel libjpeg-devel libpng-devel libqt3-devel libstdc++-devel perl-DBM python qt3-designer termutils xml-utils zlib-devel


BuildRequires(pre): cmake kdelibs-devel
BuildRequires: cvs gcc-c++
BuildRequires: libxml2-devel libxslt-devel
BuildRequires: libiberty-devel libjpeg-devel libpng-devel libqt3-devel libstdc++-devel
BuildRequires: perl-DBM perl-podlators python qt3-designer termutils xml-utils zlib-devel
BuildRequires: bison flex kdepim-devel
BuildRequires: libsubversion-devel libexpat-devel
#BuildRequires: libapr-devel libaprutil-devel
BuildRequires: libacl-devel libattr-devel libdb4-devel
#BuildRequires: perl(DCOP.pm)
#BuildRequires: kdelibs-devel-cxx = %__gcc_version_base
BuildRequires: kdelibs >= %version kdelibs-devel >= %version
BuildRequires: perl-Pod-Parser perl-Shell

%description
Software Development Kit for the K Desktop Environment.

%package common
Summary: Common empty package for %name
Group: Graphical desktop/KDE
Requires: kde-common >= 3.2
Conflicts: kdesdk <= 3.0.1
#
%description common
Common empty package for %name

%package kuiviewer
Summary: Viewer for Qt Designer user interface files
Group: Development/KDE and QT
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kuiviewer
KUIViewer is a utility to display and test the user interface (.ui)
files generated by Qt Designer. The interfaces can be displayed
in a variety of different widget styles.
	      
%package kcachegrind
Summary: KDE Frontend for Cachegrind, part of Valgrind.
Group: Development/KDE and QT
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
Requires: valgrind
Provides: kcachegrind = %version-%release
Obsoletes: kcachegrind
#
%description kcachegrind
KCachegrind is a KDE Frontend for Cachegrind, part of Valgrind.
	      
%package umbrello
Summary: UML Modeller
Group: Development/KDE and QT
Provides: umbrello = %version-%release
Obsoletes: umbrello
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description umbrello
Umbrello UML Modeller helps the software development process
by using the industry standard Unified Modelling Language (UML) to enable
you to create diagrams for designing and documenting your systems.

%package cervisia
Summary: Graphical CVS client
Group: Development/KDE and QT
License: GPL
Provides: cervisia = %version-%release
Obsoletes: cervisia
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
Requires: cvs kio-svn
#
%description cervisia
Cervisia is a KDE graphical frontend for the the CVS client. It
features checking out a module from a repository, updating or
retrieving the status of a working directory or single files, common
operations like add, remove and commit, diff against the repository
and between different revisions, annotated view of a file, view of the
log messages in tree and list form as well as resolving of conflicts
in a file.

%package kio-svn
Summary: KIO slave for svn:/ protocol in konqueror
Group: Development/Other
License: LGPL
Provides: kio-svn
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kio-svn
KIO slave for svn:/ protocol in konqueror

%package kbabel
Summary: Translator tools
Group: Development/KDE and QT
Obsoletes: kdesdk-devel
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kbabel
Translator tools.
kbabel includes a .po file editor, a catalog manager, message extraction
tools, and po file thumbnail views for Konqueror (the KDE file manager).

%package kbugbuster
Summary: KBugBuster - debugging tools
Group: Development/KDE and QT
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kbugbuster
Debugging tools

%package kapptemplate
Summary: Tool for creating a skeleton KDE application
Group: Development/KDE and QT
Requires: %name-common = %version-%release
AutoReq: noshell
#
%description kapptemplate
kapptemplate creates a skeleton KDE application (configure stuff, automake
stuff, etc.), allowing you to start writing the relevant code instead of
bothering with things that have already been done.

kapptemplate supports both standalone applications and plugins utilizing
KParts technology.

%package kfile
Summary: Kfile plugins
Group: Development/KDE and QT
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kfile
Plugin to allow the standard KDE file dialog to display
infirmation about .po .diff .cpp files

%package kmtrace
Summary: Malloc debugger for KDE
Group: Development/KDE and QT
Obsoletes: kdesdk-devel
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kmtrace
KMtrace is a malloc (memory allocation) debugger for KDE.

%package kompare
Summary: File comparison tool for KDE
Group: Development/KDE and QT
Obsoletes: kdiff
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kompare
A file comparison tool for KDE

%package kspy
Summary: Qt/KDE application state examination tool
Group: Development/KDE and QT
Obsoletes: kdesdk-devel
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kspy
KSpy is a utility intended to help developers examine the internal
state of a Qt/KDE application. KSpy graphically displays all the
QObjects in use, and allows you to browse their properties. Using KSpy
is very simple, include kspy.h and call KSpy::invoke() when you want
to looks inside your app. The KSpy function is inline and the main
part of KSpy is dynamically loaded, so you may even want to leave this
in the release build of an application.

%package misc
Summary: Misc utils for KDE development
Group: Development/KDE and QT
Provides: %name-utils = %version-%release
Obsoletes: %name-utils
Obsoletes: kdesdk-devel
Requires: %name-common = %version-%release
#
%description misc
Misc utils for KDE development

%prep
%setup -q -n kdesdk-%version
#cp -ar altlinux/admin ./
#
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15
%patch16 -p1

%if %cmake
%else
sed -i '\|\${kdeinit}_LDFLAGS[[:space:]]=[[:space:]].*-no-undefined|s|-no-undefined|-no-undefined -Wl,--warn-unresolved-symbols|' admin/am_edit
for f in `find $PWD -type f -name Makefile.am`
do
    sed -i -e '\|_la_LDFLAGS.*[[:space:]]-module[[:space:]]|s|-module|-module \$(KDE_PLUGIN)|' $f
    #sed -i -e '\|_la_LDFLAGS.*[[:space:]]-no-undefined|s|-no-undefined|-no-undefined -Wl,--allow-shlib-undefined|' $f
    grep -q -e 'lib.*SOURCES' $f || continue
    RPATH_LINK_OPTS+=" -Wl,-rpath-link,`dirname $f`/.libs"
done
sed -i "s|\(-Wl,--as-needed\)| $RPATH_LINK_OPTS \1|g" admin/acinclude.m4.in
sed -i -e 's|\$USER_INCLUDES|-I%_includedir/tqtinterface \$USER_INCLUDES|' admin/acinclude.m4.in

find ./ -type f -name Makefile.am | \
while read f
do
    sed -i -e 's|\(.*_la_LIBADD[[:space:]]*\)=\(.*\)|\1= -lkdeinit_kded -lkresources -lDCOP -lkdefx \$(LIB_KABC) \$(LIB_KUTILS) \$(LIB_KHTML) \$(LIB_KIO) \$(LIB_KDEUI) \$(LIB_KDECORE) \$(LIB_QT) \2|' $f
done

cp -Rp /usr/share/libtool/aclocal/libtool.m4 admin/libtool.m4.in
cp -Rp /usr/share/libtool/config/ltmain.sh admin/ltmain.sh
make -f admin/Makefile.common cvs ||:
%endif

%build
rm -rf %buildroot
export QTDIR=%qtdir
export KDEDIR=%prefix

export PATH=$QTDIR/bin:$KDEDIR/bin:$PATH

export LD_LIBRARY_PATH=$QTDIR/%_lib:$KDEDIR/%_lib:$LD_LIBRARY_PATH
export LDFLAGS="-L%buildroot/%_libdir -L%buildroot/%_Klibdir -L%_libdir"

%if %cmake
BD=%_builddir/%name-%version/BUILD

if ! [ -f $BD/CMakeCache.txt ]
then
%K3cmake \
    -DICON_INSTALL_DIR=%_kde3_iconsdir \
    -DCMAKE_BUILD_TYPE=RelWithDebInfo \
    -DCMAKE_VERBOSE_MAKEFILE="ON" \
    -DBUILD_ALL="ON" \
    -DWITH_DBSEARCHENGINE="ON" \
    -DWITH_KCAL="ON"
fi
%K3make

%else
# else if cmake

%K3configure  \
    --disable-gcc-hidden-visibility \
%if %unstable
    --enable-debug=full \
%else
    --disable-debug \
%endif
    --mandir=%_mandir \
    --enable-final

sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
%make_build

%endif
# end if cmake

%install
%if %unstable
%set_strip_method none
%endif

%K3install

# fix scripts for strong /usr/lib/rpm/find-requires
pushd %buildroot/%_K3bindir
for f in `(file ./* | grep bash; file ./* | grep shell) | awk -F: '{print $1}' | xargs grep -l ^=head`
do
    mv "$f" "$f.tmp"
    awk 'BEGIN{found=0;} /^=head/ {if (found==0){print "cat <<\\__EOF__";found=1;};} {print} END{if (found!=0) print "__EOF__";}' <"$f.tmp" >"$f"
    rm -f "$f.tmp"
    chmod a+x $f
done
popd

# resilve conflict with subversion-tools
mv %buildroot/%_K3bindir/svn-clean %buildroot/%_K3bindir/svnclean

# (cd /home/zerg/RPM/TMP/kdesdk-buildroot/usr/bin; for f in *; do awk 'BEGIN{found=0;} /^=head/ {if (found==0){print "cat <<\\__EOF__";found=1;};} {print} END{if (found!=0) print "__EOF__";}' <"$f" >"$f.new" && cmp -s "$f" "$f.new" && mv -f "$f.new" "$f"
# grep -rl '^=head' /home/zerg/RPM/TMP/kdesdk-buildroot/usr/bin/



%files
%files common
%_K3cfg/*

%files kcachegrind
%_K3bindir/dprof2calltree
%_K3bindir/hotshot2calltree
%_K3bindir/memprof2calltree
%_K3bindir/op2calltree
%_K3bindir/pprof2calltree
#
%_K3bindir/kcachegrind
%_K3apps/kcachegrind
%doc %_K3doc/*/kcachegrind
%_kde3_iconsdir/*/*/apps/kcachegrind.png
%_K3mimelnk/application/x-kcachegrind.desktop
%_K3xdg_apps/kcachegrind.desktop

%files kuiviewer
%_K3bindir/kuiviewer
%_K3lib/libkuiviewerpart.so*
%_K3lib/quithumbnail.so*
%_K3apps/kuiviewer
%_K3apps/kuiviewerpart
%_K3srv/designerthumbnail.desktop
%_K3srv/kuiviewer_part.desktop
%_kde3_iconsdir/*/*/apps/kuiviewer.png
%_K3xdg_apps/kuiviewer.desktop

%files umbrello
%_K3bindir/umbodoc
%_K3bindir/umbrello
%_K3apps/umbrello
%_K3iconsdir/crystalsvg/*/mimetypes/umbrello*
%_K3iconsdir/crystalsvg/*/actions/umbrello*
%_kde3_iconsdir/*/*/*/umbrello*
%_K3mimelnk/application/x-umbrello.desktop
%doc %_K3doc/*/umbrello
%_K3xdg_apps/umbrello.desktop

%files cervisia
%_K3bindir/cervisia
%_K3libdir/libkdeinit_cervisia.so*
%_K3libdir/libkdeinit_cvs*.so*
%_K3lib/cervisia.so*
%_K3lib/libcervisiapart.so*
%_K3apps/cervisia
%_K3apps/cervisiapart
%_K3apps/kconf_update/cervisia.upd
%_K3apps/kconf_update/change_colors.pl
%_K3apps/kconf_update/move_repositories.pl
%_K3apps/kconf_update/cervisia-change_repos_list.pl
%_K3apps/kconf_update/cervisia-normalize_cvsroot.pl
%_kde3_iconsdir/*/*/*/cervisia.png
%_K3iconsdir/crystalsvg/*/actions/vcs_*.*
%doc %_K3doc/*/cervisia
%doc %_man1dir/cervisia.*
%_K3xdg_apps/cervisia.desktop
#
%_K3bindir/cvsaskpass
%_K3bindir/cvsservice
%_K3lib/cvs*.so*
%_K3libdir/libcvsservice.so*
%_K3srv/cvsservice.desktop
%_K3includedir/cvsservice_stub.h
%_K3includedir/repository_stub.h
%_K3includedir/cvsjob_stub.h

%files kio-svn
%_K3bindir/kio_svn_helper
%_K3lib/kded_ksvnd.so*
%_K3lib/kio_svn.so*
%_K3srv/kded/ksvnd.desktop
%_K3srv/svn+*.protocol
%_K3srv/svn.protocol
%_K3apps/konqueror/servicemenus/subversion_toplevel.desktop
%_K3apps/konqueror/servicemenus/subversion.desktop
%_K3iconsdir/crystalsvg/*/actions/svn_*.*

%files kfile
%_K3lib/kfile_*.so*
%_K3srv/kfile_*.desktop

%files kbabel
%_K3bindir/kbabel*
%_K3bindir/catalogmanager
%_K3libdir/libkbabel*.so*
%_K3lib/kbabel_*.so*
%_K3lib/kbabeldict_*.so*
%_K3lib/pothumbnail.so*
%_K3includedir/kbabel
%_kde3_iconsdir/*/*/*/kbabel*
%exclude %_kde3_iconsdir/locolor/*/*/kbabel*
%_kde3_iconsdir/*/*/*/catalogmanager*
#%_kde3_iconsdir/*/*/*/gettext.png
%_K3xdg_apps/catalogmanager.desktop
%_K3xdg_apps/kbabel.desktop
%_K3xdg_apps/kbabeldict.desktop
%_K3apps/kconf_update/kbabel-project.upd
%_K3apps/kconf_update/kbabel-projectrename.upd
%_K3apps/kconf_update/kbabel-difftoproject.upd
%_K3apps/kbabel
#%_K3apps/kbabeldict
%_K3apps/catalogmanager
#%_K3mimelnk/application/x-gettext.desktop
%_K3srv/kbabel_*.desktop
%_K3srv/pothumbnail.desktop
%_K3srv/poauxiliary.desktop
%_K3srv/pocompendium.desktop
%_K3srv/tmxcompendium.desktop
%_K3srv/dbsearchengine.desktop
%_K3srvtyp/kbabel*.desktop
%doc %_K3doc/*/kbabel
# %doc %_K3doc/*/ktranslator

%files kbugbuster
%_K3bindir/kbugbuster
%_K3lib/kcal_bugzilla.so*
%_kde3_iconsdir/*/*/*/kbugbuster.png
%_K3apps/kbugbuster
%_K3srv/kresources/kcal/bugzilla.desktop
%_K3xdg_apps/kbugbuster.desktop
%doc %_K3doc/*/kbugbuster

%files kapptemplate
%_K3bindir/kapptemplate
%_K3apps/kapptemplate

%if %with_kmtrace
%files kmtrace
%_K3bindir/kmmatch
%_K3bindir/kmtrace
%_K3bindir/demangle
%_K3bindir/kminspector
%_K3libdir/kmtrace/libktrace*.so*
%_K3libdir/kmtrace/libktrace_s.a
%_K3apps/kmtrace
%_K3includedir/ktrace.h
%endif

%files kompare
%_K3bindir/kompare
%_K3libdir/libkompareinterface.so*
#%_K3libdir/libkomparepart*.so*
#%_K3lib/libdialogpages.*
%_K3lib/libkomparepart*.so*
%_K3lib/libkomparenavtreepart*.so*
%_K3srv/kompare*
%_K3srvtyp/kompare*part.desktop
%_K3apps/kompare
#%_K3apps/komparepart
%_kde3_iconsdir/*/*/*/kompare.*
%_K3xdg_apps/kompare.desktop
%doc %_K3doc/*/kompare

%files kspy
#%_K3bindir/testkspy
%_K3libdir/libkspy*.so*
%_K3includedir/kspy.h


%files misc
%_man1dir/cvs*
%_man1dir/kde-build.*
%_man1dir/kdesvn-build.*
%_man1dir/noncvslist.*
%_man1dir/includemocs.*
%_K3doc/*/kdesvn-build/
%doc scripts/completions
#
%if %with_kunittest
%_K3bindir/kunittest
%_K3bindir/kunittest_debughelper
%_K3bindir/kunittestguimodrunner
%_K3bindir/kunittestmod
%_K3includedir/kunittest/
%_K3libdir/libkunittestgui.so*
%endif
#
%_K3bindir/kstartperf
%_K3libdir/libkstartperf.so*

%_K3lib/kabcformat_kdeaccounts.so**
%_K3lib/plugins/styles/scheck.so*
%_K3apps/kabc/formats/kdeaccountsplugin.desktop
%_K3apps/kstyle/themes/scheck.themerc
%_K3apps/katepart/syntax/kdesvn-buildrc.xml
%_K3includedir/kprofilemethod.h
#
#%_datadir/kdepalettes
#
%_K3bindir/create_svnignore
%_K3bindir/nonsvnlist
%_K3bindir/svnclean
%_K3bindir/svn2dist
%_K3bindir/svnaddcurrentdir
%_K3bindir/svnbackport
%_K3bindir/svnchangesince
%_K3bindir/svnforwardport
%_K3bindir/svngettags
%_K3bindir/svnlastchange
%_K3bindir/svnlastlog
%_K3bindir/svnrevertlast
%_K3bindir/svnversions
%_K3bindir/kdesvn-build
%_K3bindir/colorsvn
%_K3bindir/adddebug
%_K3bindir/build-progress.sh
%_K3bindir/cheatmake
%_K3bindir/create_cvsignore
%_K3bindir/create_makefile
%_K3bindir/create_makefiles
#%_K3bindir/cvs2pack
%_K3bindir/cvs-clean
%_K3bindir/cvsbackport
%_K3bindir/cvsblame
%_K3bindir/cvscheck
%_K3bindir/cvsforwardport
%_K3bindir/cvslastchange
%_K3bindir/cvslastlog
%_K3bindir/cvsrevertlast
%_K3bindir/cvs2dist
%_K3bindir/cvsversion
%_K3bindir/cxxmetric
%_K3bindir/extend_dmalloc
%_K3bindir/extractrc
%_K3bindir/extractattr
#%_K3bindir/fixsgml
#%_K3bindir/fixincludes
%_K3bindir/includemocs
%_K3bindir/findmissingcrystal
%_K3bindir/fixuifiles
%_K3bindir/fixkdeincludes
%_K3bindir/kde-build
%_K3bindir/kdedoc
%_K3bindir/kdekillall
%_K3bindir/kdelnk2desktop.py*
%_K3bindir/kdemangen.pl
%_K3bindir/licensecheck
%_K3bindir/makeobj
%_K3bindir/noncvslist
%_K3bindir/package_crystalsvg
%_K3bindir/png2mng.pl
%_K3bindir/po2xml
%_K3bindir/pruneemptydirs
%_K3bindir/qtdoc
%_K3bindir/split2po
%_K3bindir/swappo
%_K3bindir/transxx
%_K3bindir/xml2pot
%_K3bindir/zonetab2pot.*

%changelog
