%undefine __libtoolize
%define _optlevel s
%define unstable 0
%define _keep_libtool_files 1

%define with_kdepasswd 0
%define with_userinfo 0

%define qtdir %_qt3dir
%add_findpackage_path %_K3bindir
%add_findprov_lib_path %_libdir/kde3
%add_python_req_skip - karamba

Name: kdeutils
Version: 3.5.13.2
Release: alt2

Group: Graphical desktop/KDE
Summary: K Desktop Environment - Utilities
License: GPL
URL: http://www.kde.org

Requires: %name-ark = %version-%release
Requires: %name-irkick = %version-%release
Requires: %name-kcalc = %version-%release
#Requires: %name-kcardchooser = %version-%release
Requires: %name-kcharselect = %version-%release
Requires: %name-kdessh = %version-%release
Requires: %name-kdf = %version-%release
Requires: %name-kedit = %version-%release
Requires: %name-kfloppy = %version-%release
Requires: %name-kgpg = %version-%release
Requires: %name-khexedit = %version-%release
Requires: %name-kjots = %version-%release
Requires: %name-kregexpeditor = %version-%release
Requires: %name-ksim = %version-%release
Requires: %name-ktimer = %version-%release
Requires: %name-kwallet = %version-%release
Requires: %name-laptop = %version-%release
Requires: %name-superkaramba = %version-%release
%if %with_userinfo
Requires: %name-userinfo = %version-%release
%endif
%if %with_kdepasswd
Requires: %name-kdepasswd = %version-%release
%endif

Source: kdeutils-%version.tar
Source10: klaptop_acpi_helper.control
Patch0: kdeutils-3.0-ktimer_icons.patch
Patch1: kdf-3.0.2-label.patch
#
# ALT
Patch101: kcharselect-3.5.0-fix-linking.patch
Patch103: kdeutils-3.5.1-alt-ksim-configure.patch
Patch104: kdeutils-3.5.1-alt-ksim-configure_snmp.patch
Patch105: kdeutils-3.5.13-Ark-Combained.patch
Patch106: kdeutils-3.5.13.2-trinityHomeToKDE.patch
Patch107: tde-3.5.13-build-defdir-autotool.patch

# Automatically added by buildreq on Mon Apr 08 2002
#BuildRequires: XFree86-devel XFree86-libs freetype2 gcc-c++ kde-common kdebase kdelibs-devel libarts-devel libjpeg-devel liblcms libmng libpng-devel libqt3-devel libstdc++-devel libtiff-devel zlib-devel

BuildRequires(pre): kdelibs-devel
BuildRequires: xorg-xproto-devel libXext-devel libX11-devel libICE-devel libXtst-devel
BuildRequires: gcc-c++ kde-common
BuildRequires: libjpeg-devel libpng-devel libqt3-devel libstdc++-devel
BuildRequires: libtiff-devel zlib-devel libart_lgpl-devel libgmp-devel python-devel
BuildRequires: libpcre-devel flex kdebase-devel
#BuildRequires: libpcsclite-devel
BuildRequires: libacl-devel libattr-devel
BuildRequires: libnet-snmp-devel libssl-devel
BuildRequires: doxygen qt3-doc desktop-file-utils
#BuildRequires: kdelibs-devel-cxx = %__gcc_version_base
BuildRequires: kdelibs >= %version kdelibs-devel >= %version

%description
Utilities for the K Desktop Environment.

%package common
Summary: Common empty package for %name
Group: Graphical desktop/KDE
Requires: kde-common >= 3.2
Conflicts: kdeutils <= 3.0.1
#
%description common
Common empty package for %name


%package superkaramba
Summary: Interactive eye-candy themes on your KDE desktop
Group: Graphical desktop/KDE
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
Provides: superkaramba = 0.37-%release
Obsoletes: superkaramba < 0.37
#
%description superkaramba
SuperKaramba is, in simple terms, a tool that allows you to easily
create interactive eye-candy on your KDE desktop. Theme writers create
themes, or text files that define their widget. Then, they can
optionally add python scripting to make their widget interactive. The
possibilities are endless!

%package irkick
Summary: KDE LIRC server
Group: Graphical desktop/KDE
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
Requires: lirc
#
%description irkick
This package contains KDE LIRC server and
configure modules of your remote controls
for use with applications.

%package kwallet
Summary: Wallet Management Tool
Group: Graphical desktop/KDE
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kwallet
Wallet Management Tool

%package kgpg
Summary: Simple graphical interface for GnuPG
Group: File tools
Requires: gnupg
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
Provides: kgpg = %version-%release
Obsoletes: kgpg
#
%description kgpg
Kgpg is a simple interface for GnuPG,
a powerful encryption utility.

%package ark
Summary: GUI frontend for handling archive files
Group: Archiving/Compression
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
Requires: zip unzip tar unrar bzip2 gzip ncompress p7zip arj
#
%description ark
Ark is a KDE tool for handling archive files.
It supports the following file formats:
  zip
  plain tar and tar with compressors lzop, gzip, bzip2, bzip, compress
  lha
  zoo
  single files compressed with compressors lzop, gzip, bzip2, bzip, compress
  rar
  ar

%package kcalc
Summary: KDE pocket calculator
Group: Office
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kcalc
A KDE pocket calculator.

%package kcardchooser
Summary: Smartcard Chooser
Group: Graphical desktop/KDE
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
Requires: pcsc-lite, opensc, openct
#
%description kcardchooser
Smartcard Chooser

%package kcharselect
Summary: Character Selector
Group: Graphical desktop/KDE
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kcharselect
KDE Character Selector - allows you to enter characters not found on your
keyboard.

%package kdepasswd
Summary: KDE frontend to changing your password
Group: Graphical desktop/KDE
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kdepasswd
KDE frontend to changing your password

%package userinfo
Summary: KControl module showing user account information
Group: Graphical desktop/KDE
Requires: %{get_dep kdelibs}
Requires: kdebase-kcontrol
Requires: shadow-change
Requires: %name-common = %version-%release
%if ! %with_kdepasswd
Requires: userpasswd
%endif
#
%description userinfo
KControl module showing user account information

%package kdessh
Summary: KDE frontend to ssh
Group: Networking/Remote access
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
Requires: openssh-clients
#
%description kdessh
KDE frontend to ssh (Secure Shell, an application to remotely control a
different Linux or Linux-like system securely).

%package kdf
Summary: Application and KDE applet to monitor available diskspace
Group: Graphical desktop/KDE
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
Provides: kdf = %version-%release
Obsoletes: kdf
#
%description kdf
kdeutils-kdf contains the kdf, kwikdisk and kcmdf tools for monitoring
available diskspace.

%package kedit
Summary: An easy to use text editor
Group: Editors
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kedit
An easy to use text editor

%package kfloppy
Summary: Floppy disk formatter
Group: System/Configuration/Hardware
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
Requires: dosfstools
#
%description kfloppy
KFloppy formats floppy disks and creates ext2 or DOS filesystems on them.

%package khexedit
Summary: Hex editor
Group: Editors
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description khexedit
A KDE hex editor. It allows you to edit binary files.

%package kjots
Summary: Virtual notepad
Group: Graphical desktop/KDE
Requires: %{get_dep kdelibs}
Requires: kdebase-wm
Requires: %name-common = %version-%release
#
%description kjots
KJots is a virtual notepad - you can put notes on your desktop.

%package laptop
Summary: Laptop utilities for KDE
Group: Graphical desktop/KDE
Requires: %{get_dep kdelibs}
Requires: kdebase-wm, control
Requires: %name-common = %version-%release
#Requires: powersave
%description laptop
Various laptop-related utilities for KDE.
kdeutils-laptop adds battery monitoring to kicker (the KDE panel) and allows
you to manage power management and PCMCIA cards from the KDE control center.

%package ksim
Summary: K System Information Monitor
Group: Monitoring
Requires: %{get_dep kdelibs}
Requires: kdebase-wm
Requires: %name-common = %version-%release
Provides: ksim =  %version-%release
Obsoletes: ksim
#
%description ksim
KSim is a plugin based system monitor that has
support for GKrellm (www.gkrellm.net) themes.

KSim can currently monitor these types:
  * Cpu usage (plugin)
  * Net (eth0, ppp0 etc) usage (plugin)
  * Filesystem usage (plugin)
  * Sensors information (plugin)
  * Disk information (plugin)
  * Mail monitor (plugin)
  * Clock & Date display
  * Hostname display
  * Uptime display
  * Memory/Free Memory display
  * Swap/Free Swap display
		    
%package kregexpeditor
Summary: Regular Expressions Editor
Group: Graphical desktop/KDE
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kregexpeditor
A Regular Expressions Editor.

%package ktimer
Summary: A timer (stop watch)
Group: Office
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description ktimer
A timer (stop watch).

%package devel
Summary: Development files for %name
Group: Development/KDE and QT
Requires: %name-common = %version-%release
Requires: %name = %version-%release
Provides: kdeutils-kregexpeditor-devel = %version-%release
Obsoletes: kdeutils-kregexpeditor-devel
#
%description devel
Development files for %name

%prep
%setup -q -n %name-%version
##cp -ar altlinux/admin ./
#%patch0 -p1
#%patch1 -p1
#
%patch101 -p1
#%patch103 -p1
#%patch104 -p1
#%patch105
%patch106 -p1
%patch107

sed -i '\|\${kdeinit}_LDFLAGS[[:space:]]=[[:space:]].*-no-undefined|s|-no-undefined|-no-undefined -Wl,--warn-unresolved-symbols|' admin/am_edit
for f in `find $PWD -type f -name Makefile.am`
do
    sed -i -e '\|_la_LDFLAGS.*[[:space:]]-module[[:space:]]|s|-module|-module \$(KDE_PLUGIN)|' $f
    #sed -i -e '\|_la_LDFLAGS.*[[:space:]]-no-undefined|s|-no-undefined|-no-undefined -Wl,--allow-shlib-undefined|' $f
    grep -q -e 'lib.*SOURCES' $f || continue
    RPATH_LINK_OPTS+=" -Wl,-rpath-link,`dirname $f`/.libs"
done
##sed -i "s|\(-Wl,--as-needed\)| $RPATH_LINK_OPTS \1|g" admin/acinclude.m4.in
##sed -i -e 's|\$USER_INCLUDES|-I%_includedir/tqtinterface \$USER_INCLUDES|' admin/acinclude.m4.in

find ./ -type f -name Makefile.am | \
while read f
do
    sed -i -e 's|\(.*_la_LIBADD[[:space:]]*\)=\(.*\)|\1= -lkdeinit_kded -lDCOP \$(LIB_KHTML) \$(LIB_KIO) \$(LIB_KDEUI) \$(LIB_KDECORE) \$(LIB_QT) \2|' $f
done

cp -Rp /usr/share/libtool/aclocal/libtool.m4 admin/libtool.m4.in
cp -Rp /usr/share/libtool/config/ltmain.sh admin/ltmain.sh
make -f admin/Makefile.common cvs ||:

%build
%if %unstable
%add_optflags -DDEBUG
%endif

export QTDIR=%qtdir
export KDEDIR=%_K3prefix

export PATH=$QTDIR/bin:$KDEDIR/bin:$PATH

export LD_LIBRARY_PATH=$QTDIR/%_lib:$KDEDIR/%_lib:$LD_LIBRARY_PATH
export LDFLAGS="-L%buildroot/%_libdir -L%buildroot/%_libdir/kde3 -L%_libdir"

%K3configure \
    --disable-gcc-hidden-visibility \
%if %unstable
    --enable-debug=full \
    --disable-final \
%else
    --disable-debug \
    --enable-final \
%endif
    --without-kdepasswd

sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
%make_build

%install
%if %unstable
%set_strip_method none
%endif
export PATH=%_K3bindir:$PATH

%K3install

install -pD -m755 %SOURCE10 %buildroot/etc/control.d/facilities/klaptop_acpi_helper

%__mkdir_p  %buildroot/%_K3apps/superkaramba/themes/
cp -a superkaramba/examples/{taskBar/cleanbar,popupMenu,autoHide,richtext,unicode} \
    %buildroot/%_K3apps/superkaramba/themes/
[ -f %buildroot/%_K3xdg_apps/superkaramba.desktop ] \
  || install -m 0644 superkaramba/src/superkaramba.desktop %buildroot/%_K3xdg_apps/superkaramba.desktop

# fix categories
desktop-file-install --dir %buildroot%_K3xdg_apps --add-category=Archiving --add-category=Compression %buildroot%_K3xdg_apps/ark.desktop
desktop-file-install --dir %buildroot%_K3xdg_apps --add-category=Calculator %buildroot%_K3xdg_apps/kcalc.desktop
desktop-file-install --dir %buildroot%_K3xdg_apps --add-category=Accessibility %buildroot%_K3xdg_apps/KCharSelect.desktop
desktop-file-install --dir %buildroot%_K3xdg_apps --add-category=Filesystem %buildroot%_K3xdg_apps/kcmdf.desktop
desktop-file-install --dir %buildroot%_K3xdg_apps --add-category=Filesystem %buildroot%_K3xdg_apps/kdf.desktop
desktop-file-install --dir %buildroot%_K3xdg_apps --add-category=Filesystem %buildroot%_K3xdg_apps/kwikdisk.desktop
desktop-file-install --dir %buildroot%_K3xdg_apps --add-category=Utility %buildroot%_K3xdg_apps/KEdit.desktop
desktop-file-install --dir %buildroot%_K3xdg_apps --add-category=Clock %buildroot%_K3xdg_apps/ktimer.desktop
desktop-file-install --dir %buildroot%_K3xdg_apps --add-category=Settings --add-category=X-PersonalSettings %buildroot%_K3xdg_apps/kgpg.desktop
desktop-file-install --dir %buildroot%_K3xdg_apps --add-category=Settings --add-category=X-PersonalSettings %buildroot%_K3xdg_apps/kwalletmanager.desktop
desktop-file-install --dir %buildroot%_K3xdg_apps --add-category=TextTools %buildroot%_K3xdg_apps/Kjots.desktop
desktop-file-install --dir %buildroot%_K3xdg_apps --add-category=Development %buildroot%_K3xdg_apps/kregexpeditor.desktop

#X-KDE-Utilities-File
desktop-file-install --dir %buildroot%_K3xdg_apps --add-category=FileTools %buildroot%_K3xdg_apps/khexedit.desktop

# X-KDE-Utilities-Peripherals
#desktop-file-install --dir %buildroot%_K3xdg_apps --add-category=Settings --add-category=HardwareSettings %buildroot%_K3xdg_apps/irkick.desktop
#desktop-file-install --dir %buildroot%_K3xdg_apps --add-category=Settings --add-category=HardwareSettings %buildroot%_K3xdg_apps/KFloppy.desktop

%pre laptop
/usr/sbin/groupadd -r laptop 2> /dev/null || :
[ $1 -eq 1 ] || /usr/sbin/control-dump klaptop_acpi_helper
%post laptop
[ $1 -eq 1 ] || /usr/sbin/control-restore klaptop_acpi_helper



%files
%files common
%_K3cfg/*
%_K3conf/*

%files superkaramba
%_K3bindir/superkaramba
%_K3applnk/Utilities/superkaramba.desktop
%_K3apps/superkaramba/
%doc %_K3doc/en/superkaramba/
%_K3iconsdir/*/*/apps/superkaramba.*
%_K3iconsdir/*/*/mimetypes/superkaramba_*.*
%_K3mimelnk/application/x-superkaramba.desktop
%_K3xdg_apps/superkaramba.desktop

%files kwallet
%_K3bindir/kwalletmanager
%_K3libdir/kde3/kcm_kwallet.so*
%_K3apps/kwalletmanager
%_K3srv/kwalletmanager_show.desktop
%_K3srv/kwallet_config.desktop
%_kde3_iconsdir/*/*/apps/kwalletmanager.png
%doc %_K3doc/en/kwallet/
%_K3xdg_apps/kwalletconfig.desktop
%_K3xdg_apps/kwalletmanager.desktop
%_K3xdg_apps/kwalletmanager-kwalletd.desktop

%files irkick
%_K3bindir/irkick
%_K3libdir/libkdeinit_irkick.so*
%_K3libdir/kde3/irkick.so*
%_K3libdir/kde3/kcm_kcmlirc.so*
%_K3start/irkick.desktop
%_K3apps/remotes
%_K3apps/profiles/profile.dtd
%_K3apps/profiles/noatun.profile.xml
%_K3apps/profiles/klauncher.profile.xml
%_K3apps/profiles/konqueror.profile.xml
%_K3apps/irkick
%_kde3_iconsdir/*/*/apps/irkick.png
%doc %_K3doc/en/irkick
%doc %_K3doc/en/kcmlirc
%_K3xdg_apps/irkick.desktop
%_K3xdg_apps/kcmlirc.desktop

%files kgpg
%_K3bindir/kgpg
%_K3apps/konqueror/servicemenus/encrypt*.desktop
%_K3apps/kgpg/
%_K3start/kgpg.desktop
%_kde3_iconsdir/*/*/apps/kgpg.png
%doc %_K3doc/en/kgpg
%_K3xdg_apps/kgpg.desktop

%files ark
%_K3bindir/ark
%_K3libdir/libkdeinit_ark.*so*
%_K3lib/*ark*.so*
%_K3apps/ark
#%_K3apps/konqueror/servicemenus/*
%_kde3_iconsdir/*/*/apps/ark.*
%_K3xdg_apps/ark.desktop
%_K3srv/ark_part.desktop
%doc %_K3doc/en/ark

%files kcalc
%_K3bindir/kcalc
%_K3libdir/libkdeinit_kcalc.*so*
%_K3lib/kcalc.so*
%_kde3_iconsdir/*/*/apps/kcalc.*
%_K3apps/kcalc
%_K3apps/kconf_update/kcalcrc.upd
%doc %_K3doc/en/kcalc
%_K3xdg_apps/kcalc.desktop

%files kcharselect
%_K3bindir/kcharselect
%_K3lib/kcharselect_panelapplet.so*
%_K3apps/kcharselect/
%_K3apps/kconf_update/kcharselect.upd
%_kde3_iconsdir/*/*/*/kcharselect.png
%_K3xdg_apps/KCharSelect.desktop
%doc %_K3doc/en/kcharselect
%_K3apps/kicker/applets/kcharselectapplet.desktop

#%files kcardchooser
#%_K3bindir/kcardchooser
#%_K3xdg_apps/kcardchooser.desktop

%files ksim
#%_K3bindir/ksim
#%_K3libdir/ksim.*
%_K3libdir/libksimcore.so*
%_K3lib/ksim_*.so*
%_K3apps/ksim
%_K3apps/kicker/extensions/ksim.desktop
%_K3iconsdir/*/*/*/ksim*.png
%doc %_K3doc/en/ksim
#%_K3xdg_apps/ksim.desktop

%if %with_kdepasswd
%files kdepasswd
%_K3bindir/kdepasswd
%_K3xdg_apps/kdepasswd.desktop
%endif

%if %with_userinfo
%files userinfo
%_K3lib/kcm_userinfo.so*
%_K3xdg_apps/userinfo.desktop
%endif

%files kdessh
%_K3bindir/kdessh

%files kdf
%_K3bindir/kdf
%_K3bindir/kwikdisk
%_K3lib/kcm_kdf*.so*
%_K3iconsdir/*/*/*/kcmdf.png
%_kde3_iconsdir/*/*/*/kdf.png
%_kde3_iconsdir/*/*/*/kwikdisk.png
%_K3apps/kdf
%_K3xdg_apps/kdf.desktop
%_K3xdg_apps/kwikdisk.desktop
%_K3xdg_apps/kcmdf.desktop
%doc %_K3doc/en/kdf
%doc %_K3doc/en/kinfocenter/blockdevices

%files kedit
%_K3bindir/kedit
%_K3libdir/libkdeinit_kedit.so*
%_K3lib/kedit.so*
%_kde3_iconsdir/*/*/*/kedit.png
%_K3xdg_apps/KEdit.desktop
%_K3apps/kedit
%doc %_K3doc/en/kedit

%files kfloppy
%_K3bindir/kfloppy
%_K3apps/konqueror/servicemenus/floppy_format.desktop
%_kde3_iconsdir/*/*/*/kfloppy.png
%_K3xdg_apps/KFloppy.desktop
%doc %_K3doc/en/kfloppy

%files khexedit
%_K3bindir/khexedit
%_K3libdir/libkhexeditcommon.so*
%_K3lib/libkbyteseditwidget.so*
%_K3lib/libkhexedit2part.so*
%_K3apps/khexedit/
%_K3apps/khexedit2part/
%_kde3_iconsdir/*/*/*/khexedit.png
%_K3srv/kbyteseditwidget.desktop
%_K3srv/khexedit2part.desktop
%_K3xdg_apps/khexedit.desktop
%doc %_K3doc/en/khexedit

%files kjots
%_K3bindir/kjots
%_kde3_iconsdir/*/*/*/kjots.png
%_K3apps/kjots
%_K3xdg_apps/Kjots.desktop
%doc %_K3doc/en/kjots

%files laptop
%config %_sysconfdir/control.d/facilities/klaptop_acpi_helper
#%_K3bindir/klaptopdaemon
%_K3bindir/klaptop_*
%_K3libdir/libkcmlaptop.so*
%_K3lib/kcm_laptop*.so*
%_K3lib/kded_klaptopdaemon.so*
%_K3apps/klaptopdaemon
#%_K3iconsdir/*/*/*/klaptopdaemon.png
%_K3iconsdir/*/*/apps/laptop_battery.*
%_K3iconsdir/*/*/*/laptop_pcmcia.png
%_K3xdg_apps/pcmcia.desktop
%_K3xdg_apps/laptop.desktop
%_K3srv/kded/klaptopdaemon.desktop
%doc %_K3doc/en/kcontrol/kcmlowbatcrit
%doc %_K3doc/en/kcontrol/kcmlowbatwarn
%doc %_K3doc/en/kcontrol/laptop
%doc %_K3doc/en/kcontrol/powerctrl
#
%_K3libdir/libkmilo.so*
%_K3lib/kmilo_*.so*
%_K3lib/kded_kmilod.so*
%_K3lib/kcm_kvaio.so*
%_K3srv/kmilo/
%_K3srv/kded/kmilod.desktop
%_K3srvtyp/kmilo/kmilopluginsvc.desktop
%_K3xdg_apps/kvaio.desktop
# kcm_thinkpad
%_K3lib/kcm_thinkpad.so*
%_K3xdg_apps/thinkpad.desktop

%files kregexpeditor
%_K3bindir/kregexpeditor
%_K3libdir/*kregexpeditor*.so*
%_K3lib/libkregexpeditorgui*.so*
%_K3apps/kregexpeditor
%_K3srv/kregexpeditorgui.desktop
%_kde3_iconsdir/*/*/apps/kregexpeditor.png
%doc %_K3doc/en/KRegExpEditor
%_K3xdg_apps/kregexpeditor.desktop

%files ktimer
%_K3bindir/ktimer
%_kde3_iconsdir/*/*/apps/ktimer.png
%doc %_K3doc/en/ktimer
%_K3xdg_apps/ktimer.desktop

%files devel
%if %_keep_libtool_files
%_K3libdir/*.la
%endif
%_includedir/*

%changelog
