%define _unpackaged_files_terminate_build 1
%define unstable 0
%define post_version 1

%define build_req_kde_ver 4.6.0
%define build_req_kdevplatform_ver 1.4.1
%define build_req_kdevelop_ver 4.4.1
%define build_req_kdev_pg_qt_ver 1.0.0

%if %unstable
%define pkg_sfx -pre4.4
%define pkg_sfx_other %nil
%define if_unstable() %{expand:%*}
%define if_stable() %nil
%else
%define pkg_sfx %nil
%define pkg_sfx_other -pre4.4
%define if_unstable()  %nil
%define if_stable() %{expand:%*}
%endif

%define kdevplatform kdevplatform%pkg_sfx
%define kdevplatform_other kdevplatform%pkg_sfx_other
%define kdevelop kdevelop%pkg_sfx
%define kdevelop_other kdevelop%pkg_sfx_other

%define kdevelop_pg_qt kdevelop-pg-qt

Name: %kdevelop-for-php
Version: 1.4.1
Release: alt1.git
Serial: 3

Summary: PHP Language Plugin for KDevelop/Quanta.
License: GPLv2
Group: Development/Other
Url: https://projects.kde.org/projects/extragear/kdevelop/plugins/kdev-php

Requires: %kdevelop-mini >= %build_req_kdevelop_ver
Requires: /usr/bin/php
Provides: kdev-php = %version-%release

Conflicts: %kdevelop_other-for-php
# Only stable package replaces unstable counterpart
%if_stable Obsoletes: %{kdevelop_other}-for-php < %serial:%version-%release

# Replace old -unstable
Conflicts: kdevelop-unstable-for-php

Source: kdev-php-%version.tar.gz
%if %post_version
Patch0: kdev-php-post-%version.patch
%endif
Patch1: kdev-php-alt-translations.patch
Source1: kdev-php-translations-%version.tar.gz
Source2: kdev-php-docs-%version.tar.gz

BuildRequires(pre): kde4libs-devel
BuildRequires: kde4libs-devel >= %build_req_kde_ver
BuildRequires: %kdevplatform-devel >= %build_req_kdevplatform_ver gcc-c++
BuildRequires: %kdevelop_pg_qt-devel >= %build_req_kdev_pg_qt_ver

%description
PHP Language Plugin for KDevelop/Quanta.

%prep
%setup -q -a1 -a2 -n kdev-php-%version
%if %post_version
%patch0 -p1
%endif
cd po
%patch1 -p1
cd ..

cat >>CMakeLists.txt <<EOF

include(MacroOptionalAddSubdirectory)
macro_optional_add_subdirectory( po )
add_subdirectory( docs )
EOF

%build
%K4cmake
%K4make

%install
%K4install

%K4find_lang --output=%name.lang --with-kde          kdevphp
%K4find_lang --output=%name.lang --with-kde --append kdevphpdocs

%files -f %name.lang
%doc AUTHORS HACKING TODO
%_K4apps/kdevappwizard/templates/simple_phpapp.tar.bz2
%_K4lib/kdevphpdocs.so
%_K4lib/kdevphpdocs_config.so
%_K4lib/kdevphplanguagesupport.so
%_libdir/*.so
%_K4apps/kdevphpsupport
%_K4cfg/phpdocssettings.kcfg
%_K4srv/*

%changelog
