Version: 4.4.1
Release: alt2.git
Serial: 3

%define _unpackaged_files_terminate_build 1
%define unstable 0
%define post_version 1
%define with_api_docs 0
%def_enable okteta
# from the Project's CMakeLists.txt
%define build_req_kde_ver_min 4.5.0
%define build_req_kdeplatform_min 1.4.1
%define req_kdev_php_min 1.4.0

%if %unstable
%define pkg_sfx -pre4.4
%define pkg_sfx_other %nil
%define if_unstable() %{expand:%*}
%define if_stable() %nil
%else
%define pkg_sfx %nil
%define pkg_sfx_other -pre4.4
%define if_unstable()  %nil
%define if_stable() %{expand:%*}
%endif

%define kdevplatform kdevplatform%{pkg_sfx}
%define kdevplatform_other kdevplatform%{pkg_sfx_other}
%define kdevelop kdevelop%{pkg_sfx}
%define kdevelop_other kdevelop%{pkg_sfx_other}

%add_python_req_skip gdb

%define desc_common \
KDevelop is a free, open source IDE (Integrated Development Environment)\
for MS Windows, Mac OS X, Linux, Solaris and FreeBSD.\
\
It is a feature-full, plugin extensible IDE for C/C++ and other \
programming languages.\
\
KDevelop provides a complete environment (development, debugging,\
profiling, testing) for C/C++ application development. It supports\
make- and CMake projects out of box, modules for other build systems\
are being developed.\
\
Also it has modules (packaged separately) for PHP, Python, Valgrind\
and other programming languages and development tools.

# this should be oneliner :/
%define req_normal %kdevelop-mini = %serial:%version-%release %kdevelop-for-debug = %serial:%version-%release %kdevplatform-subversion >= %build_req_kdeplatform_min %kdevplatform-git >= %build_req_kdeplatform_min 
%define req_normal_features \
  * debug module \
  * module for Subversion support \
  * module for Git support

%define req_big %kdevelop = %serial:%version-%release %kdevelop-for-kde = %serial:%version-%release %kdevelop-for-qt = %serial:%version-%release
%define req_big_features %req_normal_features \
  * module for QT apps development \
  * module for KDE apps development

%if_enabled okteta
%global req_big %req_big %kdevelop-okteta = %serial:%version-%release
%global req_big_features %req_big_features \
  * Okteta viewer module
%endif

# this one too :/
%define req_maxi %req_big %kdevplatform-cvs >= %build_req_kdeplatform_min %kdevelop-for-php >= %req_kdev_php_min
%define req_maxi_features %req_big_features \
  * module for CVS support \
  * module for PHP programming language support

Name: %kdevelop-src
Summary: A KDE-centric IDE - source package
License: GPLv2
Group: Development/Tools
Url: http://www.kdevelop.org/

Source: kdevelop-%version.tar.gz
Source1: kdevelop-translations-%version.tar.gz
%if %post_version
Patch0: kdevelop-post-%version.patch
%endif
Patch1: kdevelop-%version-%release-alt-fixes.patch
Patch2: kdevelop-alt-translations.patch

# Automatically added by buildreq on Tue Mar 30 2010 (-bi)
#BuildRequires: cvs gcc-c++ git-core glib2-devel glibc-devel-static kde4base-workspace-devel kdevplatform-devel libXScrnSaver-devel libXau-devel libXcomposite-devel libXdamage-devel libXdmcp-devel libXpm-devel libXt-devel libXtst-devel libXv-devel libXxf86misc-devel libqt3-devel libxkbfile-devel mercurial openssh qt4-assistant qt4-designer rpm-build-ruby subversion valgrind-devel xorg-xf86vidmodeproto-devel
BuildRequires(pre): kde4libs-devel
BuildRequires: cvs gcc-c++ glib2-devel glibc-devel kde4base-workspace-devel valgrind-devel cppunit-devel libcheck-devel
BuildRequires: kde4libs-devel >= %build_req_kde_ver_min
BuildRequires: %kdevplatform-devel >= %build_req_kdeplatform_min

# For Kasten plugin
BuildRequires: kde4utils-devel
# For Okteta plugin
%if_enabled okteta
BuildRequires: kde4sdk-devel
%endif

%description
%desc_common

This is a KDevelop source package

%package -n %kdevelop
Summary: A KDE-centric IDE - normal installation
Group: Development/Tools
Requires: %req_normal
BuildArch: noarch

Conflicts: %kdevelop_other
%if_stable Obsoletes: %{kdevelop_other} < %serial:%version-%release

# Drop previous -unstable
Conflicts: kdevelop-unstable

%description -n %kdevelop
%desc_common

This package provides a "medium" variant of KDevelop installation.
Besides a minimal installation it includes the following modules:
%req_normal_features

%package -n %kdevelop-devel
Group: Development/KDE and QT
Summary: Development libraries for KDevelop
Requires: %kdevelop-libs = %serial:%version-%release
BuildArch: noarch

Conflicts: %{kdevelop_other}-devel
# Only stable package replaces unstable counterpart
%if_stable Obsoletes: %{kdevelop_other}-devel < %serial:%version-%release

# Drop previous -unstable
Conflicts: kdevelop-unstable-devel

%description -n %kdevelop-devel
Development libraries for KDevelop.

# Drop previous -unstable
Conflicts: kdevelop-unstable-common

%package -n %kdevelop-mini
Group: Development/Tools
Summary:  A KDE-centric IDE - normal installation
Requires: kde4libs >= %{get_version kde4libs}
Requires: %kdevplatform >= %build_req_kdeplatform_min
Requires: %kdevelop-libs = %serial:%version-%release
Requires: gcc gcc-c++

Provides: %kdevelop-base = %serial:%version-%release
Obsoletes: %kdevelop-base < %release:%version-%release
Conflicts: %{kdevelop_other}-mini
Conflicts: %{kdevelop_other}-base
# Only stable package replaces unstable counterpart
%if !%unstable
Obsoletes: %{kdevelop_other}-base < %serial:%version-%release
Obsoletes: %{kdevelop_other}-mini < %serial:%version-%release
%endif

# Drop previous -unstable
Conflicts: kdevelop-unstable-base

Requires: make cmake
%description -n %kdevelop-mini
%desc_common

This package contains minimal installation of KDevelop IDE.
It provides only basic set of features and extensions modules.

%package -n %kdevelop-libs
Group: Development/Other
Summary: Base libraries for KDevelop
Requires: kde4libs >= %{get_version kde4libs}
Requires: kde-common >= 4
Requires: %kdevplatform-libs >= %build_req_kdeplatform_min
Conflicts: kdevelop <= 3.0.2-alt0.2

Conflicts: %{kdevelop_other}-libs
# Only stable package replaces unstable counterpart
%if_stable Obsoletes: %{kdevelop_other}-libs < %serial:%version-%release

# Drop previous -unstable
Conflicts: kdevelop-unstable-libs

# Drop -common subpackage
Conflicts: %kdevelop-common
Obsoletes: %kdevelop-common <= %serial:%version-%release
Conflicts: %{kdevelop_other}-common
# Only stable package replaces unstable counterpart
%if_stable Obsoletes: %{kdevelop_other}-common <= %serial:%version-%release

%description -n %kdevelop-libs
This package contains base libraries for %name

%package -n %kdevelop-maxi
Group: Development/Tools
Summary: A KDE-centric IDE - maximal installation
Requires: %req_maxi
BuildArch: noarch

Conflicts: %{kdevelop_other}-maxi
# Only stable package replaces unstable counterpart
%if_stable Obsoletes: %{kdevelop_other}-maxi < %serial:%version-%release

# Drop previous -unstable
Conflicts: kdevelop-unstable-maxi

%description -n %kdevelop-maxi
%desc_common

This meta-package provides a full KDevelop installation
by depending on other KDevelop-related packages.
Besides an usual KDevelop features it provides the following
list of modules: %req_maxi_features

%package -n %kdevelop-big
Group: Development/Tools
Summary: A KDE-centric IDE - extended installation
Requires: %req_big
BuildArch: noarch

Conflicts: %{kdevelop_other}-big
# Only stable package replaces unstable counterpart
%if_stable Obsoletes: %{kdevelop_other}-big < %serial:%version-%release

# Drop previous -unstable
Conflicts: kdevelop-unstable-big

%description -n %kdevelop-big
%desc_common

This package provides an extended KDevelop installation
by depending on other KDevelop-related packages.
Besides an usual KDevelop features it provides the following
list of modules: %req_big_features

%package -n %kdevelop-for-debug
Group: Development/Debug
Summary: KDevelop module for debugging
Requires: %kdevelop-mini = %serial:%version-%release
Requires: valgrind gdb

Conflicts: %{kdevelop_other}-for-debug
# Only stable package replaces unstable counterpart
%if_stable Obsoletes: %{kdevelop_other}-for-debug < %serial:%version-%release

# Drop previous -unstable
Conflicts: kdevelop-unstable-for-debug

%description -n %kdevelop-for-debug
This KDevelop module provides KDevelop with debugging capabilities
using GDB and Valgrind as backends.

%package -n %kdevelop-for-qt
Group: Development/KDE and QT
Summary: Templates for developing Qt applications with KDevelop
Requires: %kdevelop-mini = %serial:%version-%release
Requires: qt4-devel qt4-doc

Conflicts: %{kdevelop_other}-for-qt
# Only stable package replaces unstable counterpart
%if_stable Obsoletes: %{kdevelop_other}-for-qt < %serial:%version-%release

# Drop previous -unstable
Conflicts: kdevelop-unstable-for-qt

%description -n %kdevelop-for-qt
Templates for developing Qt applications with KDevelop

%package -n %kdevelop-for-kde
Group: Development/KDE and QT
Summary: Templates for developing KDE applications with KDevelop
Requires: %kdevelop-mini = %serial:%version-%release
Requires: %kdevelop-for-qt = %serial:%version-%release
Requires: kde4sdk-kapptemplate
Requires: kde4libs-devel kde4pimlibs-devel kde4base-runtime-devel kde4base-workspace-devel kde4base-devel
Requires: kde4multimedia-devel kde4graphics-devel kde4network-devel
BuildArch: noarch
# kde4libs-apidocs kde4graphics-kiconedit

Conflicts: %{kdevelop_other}-for-kde
# Only stable package replaces unstable counterpart
%if_stable Obsoletes: %{kdevelop_other}-for-kde < %serial:%version-%release

# Drop previous -unstable
Conflicts: kdevelop-unstable-for-kde

%description -n %kdevelop-for-kde
Templates for developing KDE applications with KDevelop

%package -n %kdevelop-okteta
Group: Development/Other
Summary: Okteta KDevelop plugin
Requires: %kdevelop-mini = %serial:%version-%release

Conflicts: %{kdevelop_other}-okteta
# Only stable package replaces unstable counterpart
%if_stable Obsoletes: %{kdevelop_other}-okteta < %serial:%version-%release

# Drop previous -unstable
Conflicts: kdevelop-unstable-okteta

%description -n %kdevelop-okteta
Okteta KDevelop plugin provides simple Hex Editing

%prep
%setup -q -a 1 -n kdevelop-%version
%if %post_version
%patch0 -p1
%endif
%patch1 -p1
cd po
%patch2 -p1
cd ..

cat >>CMakeLists.txt <<EOF

include(MacroOptionalAddSubdirectory)
macro_optional_add_subdirectory( po )
EOF

%if_disabled okteta
find po -name 'kdevokteta.po' -exec rm {} \;
%endif

%build
%K4cmake
%K4make

%if %with_api_docs
%make_build apidox
%endif

%install
%K4install
%if %with_api_docs
%make_build DESTDIR=%buildroot install-apidox
%endif

# Fix permissions of desktop files
chmod -x %buildroot%_K4xdg_apps/*

# remove all desktop_extragear-* translations, zerg@ told they aren't needed at all
find %buildroot -name 'desktop_extragear*.mo' -exec rm {} \;

%K4find_lang --output=%name.lang --with-kde          kdevelop
for m in \
kdevcmakebuilder kdevcmake kdevcpp kdevcustommake kdevformatters \
 kdevmakebuilder kdevelopsessions kdevmanpage plasma_runner_kdevelopsessions
do
    %K4find_lang --output=%name.lang --with-kde --append $m
done

%if_enabled okteta
%K4find_lang --output=kdevokteta.lang --with-kde kdevokteta
%endif

%K4find_lang --output=kdevqthelp.lang --with-kde kdevqthelp

%K4find_lang --output=kdevgdb.lang --with-kde kdevgdb

%files -n %kdevelop
%files -n %kdevelop-maxi
%files -n %kdevelop-big
%files -n %kdevelop-for-debug -f kdevgdb.lang
%_K4lib/kdevgdb.so
%_K4apps/kdevgdb
%_K4srv/kdevgdb.desktop

%files -n %kdevelop-for-kde

%files -n %kdevelop-for-qt -f kdevqthelp.lang
%_K4lib/kdevqthelp.so
%_K4lib/kdevqthelp_config.so
%_K4srv/kdevqthelp*.desktop
%_K4apps/kdevappwizard/templates/*make_qt4*.tar.bz2
%_K4conf/kdevelop-qthelp.knsrc

%files -n %kdevelop-mini -f %name.lang
%doc AUTHORS ChangeLog NEWS README HACKING TODO
%_K4bindir/kdevelop
%_K4bindir/kdevelop!
%_K4lib/kcm_kdev_makebuilder.so
%_K4lib/kcm_kdevcmake_settings.so
%_K4lib/kdevcmakebuilder.so
%_K4lib/kdevcmakemanager.so
%_K4lib/kdevcpplanguagesupport.so
%_K4lib/kdevcustommakemanager.so
%_K4lib/kdevmakebuilder.so
%_K4lib/kdevastyle.so
%_K4lib/kdevcustomscript.so
%_K4lib/kdevmanpage.so
%_K4lib/kdevcmakedocumentation.so
%_K4lib/krunner_kdevelopsessions.so
%_K4lib/plasma_engine_kdevelopsessions.so
%_K4srv/*.desktop
%exclude %_K4srv/kdevqthelp*.desktop
%if_enabled okteta
%exclude %_K4srv/kdevokteta*.desktop
%endif
%exclude %_K4srv/kdevgdb.desktop

%_K4apps/kdevcmakebuilder
%_K4apps/kdevcmakemanager
%_K4apps/kdevcustommakemanager
%_K4apps/kdevelop
%_K4apps/kdevcppsupport
%_K4apps/plasma
%_K4apps/kdevappwizard/templates/cmake_plaincpp.tar.bz2
%_K4xdg_apps/kdevelop.desktop
%_K4xdg_apps/kdevelop_ps.desktop
%_K4conf/kdeveloprc
%_K4iconsdir/hicolor/*/*/*.*
%_K4xdg_mime/kdevelop.xml

%files -n %kdevelop-libs
%_K4lib/kdevkdeprovider.so
%_K4libdir/libkdev4cmakecommon.so
%_K4libdir/libkdev4cppduchain.so
%_K4libdir/libkdev4cppparser.so
%_K4libdir/libkdev4cpprpp.so

%if_enabled okteta
%files -n %kdevelop-okteta -f kdevokteta.lang
%_K4lib/kdevokteta.so
%_K4apps/kdevokteta
%_K4srv/kdevokteta*.desktop
%endif

%files -n %kdevelop-devel
%_K4apps/cmake/modules/*.cmake
%_K4includedir/kdevelop
#%doc %_K4doc/en/kdevelop-apidocs/

%changelog
