Name: kdiff3
Version: 0.9.95
Release: alt2.qa1

Summary: Compares and merges 2 or 3 files or directories
License: GPL
Group: Text tools
Url: http://kdiff3.sourceforge.net
Packager: Ilya Mashkin <oddity at altlinux dot ru>

Source0: %name-%version.tar.gz
# Our patches
Patch0:  kdiff3-0.9.95-localization.patch
Patch1:  kdiff3-%version-%release-cumulative.patch
Patch2: kdiff3-0.9.95-alt-docbook_version.patch
# Patches from KDiff3 Tracker
Patch10: kdiff3-0.9.95_log10.diff
Patch11: kdiff3-0.9.95_mimatched_delete.diff
Patch12: kdiff3-0.9.95_avoid_equal_files_dialog.diff
Patch13: kdiff3-avoid-dirmerge-dialog.patch

# Patches from Ubuntu package
Patch20: create_qm_files.patch
Patch21: kdiff3.pro.patch


BuildRequires: gcc-c++ kde4base-workspace-devel kde4base-devel cmake cmake-modules

%description
KDiff3 is a program that
- compares and merges two or three input files or directories,
- shows the differences line by line and character by character (!),
- provides an automatic merge-facility and
  an integrated editor for comfortable solving of merge-conflicts
- has support for KDE-KIO (ftp, sftp, http, fish, smb...)
- and has an intuitive graphical user interface.

%prep
%setup -q

%patch0 -p2
%patch1 -p2
%patch2 -p1

%patch10 -p1
%patch11 -p0
%patch12 -p5
%patch13 -p1

%patch20 -p0
%patch21 -p1

%build
%K4cmake
%K4make

%install
%K4install

%K4find_lang --with-kde %name
%K4find_lang --with-kde --append --output %name.lang %{name}plugin

# Fix absolute links
pushd %buildroot
for l in .%_K4doc/*/%name/common; do
  t=$(readlink $l)
  # unfortunately ${var:pos} is a bash'ism
  r=$(relative $t $(echo $l | cut -c 2-))
  rm -f $l
  ln -s $r $l
done

%files -f %name.lang
%doc AUTHORS ChangeLog INSTALL NEWS README TODO
%_bindir/%name
%_K4lib/libkdiff3*.so
%_K4apps/%name
%_K4xdg_apps/%name.desktop
%_K4srv/*.desktop

%_iconsdir/*/*/apps/%name.png

%changelog
