Name: kernel-headers-common
Version: 1.2.4
Release: alt1

Summary: Common header files for the Linux kernel
License: GPL
Group: Development/Kernel
ExclusiveArch: %ix86 x86_64 %arm

Source0: adjust_kernel_headers
Source1: adjust_kernel_headers.8
Source2: kheaders.init
Source3: kheaders.service
Source4: kheaders.filetrigger

%define base_arch %_target_cpu
%ifarch %ix86 x86_32 x86_64
%define base_arch x86
%endif
%ifarch %arm
%define base_arch arm
%endif
%ifarch ppc ppc64
%define base_arch powerpc
%endif

%define _unpackaged_files_terminate_build 1

%add_findreq_skiplist %_includedir/*
%add_findreq_skiplist /etc/sysconfig/kernel/include
Requires: glibc-kernheaders
Conflicts: kernel-headers-alsa

%description
This package contains common directories and C header files from
various versions of the linux kernel.

%install
mkdir -p %buildroot{%_sbindir,%_man8dir,%systemd_unitdir}
install -pm755 %_sourcedir/adjust_kernel_headers %buildroot%_sbindir/
sed -i 's/@VERSION@/%version/g' -- \
	%buildroot%_sbindir/adjust_kernel_headers
install -pm644 %_sourcedir/adjust_kernel_headers.8 %buildroot%_man8dir/
install -pm644 %_sourcedir/kheaders.service %buildroot%systemd_unitdir/
install -pD -m755 %_sourcedir/kheaders.init %buildroot%_initdir/kheaders
mkdir -p %buildroot%_rpmlibdir/
install -m755 %_sourcedir/kheaders.filetrigger %buildroot%_rpmlibdir/
mkdir -p %buildroot%_includedir
mkdir -p %buildroot%_sysconfdir/sysconfig/kernel
mkdir -p %buildroot%_prefix/lib/kernel
mkdir -p %buildroot/var/run/kernel

ln -s %_sysconfdir/sysconfig/kernel/include/asm{,-generic,-%base_arch} \
	%buildroot%_includedir/

ln -s %_sysconfdir/sysconfig/kernel/include/{drm,linux,mtd,sound,video} \
	%buildroot%_includedir/

[ "%base_arch" = "%_target_cpu" ] ||
	ln -s asm-%base_arch %buildroot%_includedir/asm-%_target_cpu

ln -s %_includedir/linux-default/include \
	%buildroot%_sysconfdir/sysconfig/kernel/

touch %buildroot%_sysconfdir/sysconfig/kernel/include_manual_mode

for f in {autoconf,modversions,version}.{h,ph} _h2ph_pre.ph; do
        touch "%buildroot/var/run/kernel/$f"
done

%pre
for n in asm{,-generic,-%base_arch,-%_target_cpu} drm linux mtd sound video; do
	d="%_includedir/$n"
	[ -d "$d" -a ! -L "$d" ] || continue
	rmdir "$d" 2> /dev/null ||:
done

%post
%post_service kheaders

%preun
%preun_service kheaders

%triggerin -- glibc-kernheaders, kernel-headers-std-up, kernel-headers-std-smp, kernel22-headers, kernel24-headers
%_sbindir/adjust_kernel_headers ||:

%triggerpostun -- glibc-kernheaders, kernel-headers-std-up, kernel-headers-std-smp, kernel22-headers, kernel24-headers, kernel22-up, kernel22-up-secure, kernel22-smp, kernel22-smp-secure, kernel24-up, kernel24-smp
%_sbindir/adjust_kernel_headers ||:

%triggerpostun -- kernel-headers-common < 0:1.1-alt1
/sbin/chkconfig --add kheaders
/sbin/service kheaders start ||:

%files
%systemd_unitdir/kheaders.service
%_rpmlibdir/kheaders.filetrigger
%_initdir/kheaders
%_sbindir/adjust_kernel_headers
%_man8dir/*
%dir %_sysconfdir/sysconfig/kernel
%ghost %_sysconfdir/sysconfig/kernel/include
%ghost %_sysconfdir/sysconfig/kernel/include_manual_mode
%_includedir/asm
%_includedir/asm-generic
%_includedir/asm-%base_arch
%if "%base_arch" != "%_target_cpu"
%_includedir/asm-%_target_cpu
%endif
%_includedir/drm
%_includedir/linux
%_includedir/mtd
%_includedir/sound
%_includedir/video
%dir %_prefix/lib/kernel
%dir /var/run/kernel
%ghost /var/run/kernel/*

%changelog
