%define module_name	bcmwl
%define module_version	6.30.223.248
%define module_release alt5

%define flavour		std-def
BuildRequires(pre): rpm-build-kernel
BuildRequires(pre): kernel-headers-modules-std-def

%setup_kernel_module %flavour

%define norm_version	%kversion

%define module_dir /lib/modules/%kversion-%flavour-%krelease/net

Summary: Modules for Broadcom-based WiFi .11a/b/g adapters
Name: kernel-modules-%module_name-%flavour
Version: %module_version
Release: %module_release.%kcode.%kbuildrelease
License: Proprietary
Group: System/Kernel and hardware

Packager: Kernel Maintainer Team <kernel@packages.altlinux.org>

ExclusiveOS: Linux
Url: http://www.broadcom.com/support/802.11/linux_sta.php
Patch1: bcmwl-build-kernel3.15.patch
Patch2: bcmwl-build-kernel3.17.patch
BuildRequires: perl sharutils
BuildRequires(pre): rpm-build-kernel
BuildRequires: kernel-source-%module_name = %module_version
BuildRequires: kernel-headers-modules-%flavour = %kepoch%kversion-%krelease

Provides: kernel-modules-%module_name-%kversion-%flavour-%krelease = %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease < %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease > %version-%release

PreReq: kernel-image-%flavour = %kepoch%kversion-%krelease
ExclusiveArch: %karch

%description
These packages contain Broadcom's IEEE 802.11a/b/g/n hybrid Linux device
driver for use with Broadcom's BCM4311-, BCM431i2-,
BCM4321-, and BCM4322-based hardware.

NOTE: You must read the LICENSE.TXT file in the lib directory before
using this software.
%prep
rm -rf kernel-source-%module_name-%module_version

tar -jxvf %kernel_src/kernel-source-%module_name-%module_version.tar.bz2

%setup -D -T -n kernel-source-%module_name-%module_version
pushd bcmwl
%patch1 -p1
%patch2 -p1
popd

%build
cd bcmwl
mkdir lib
if [ "$(arch)" = "x86_64" ] ; then
   cp src/lib/wlc_hybrid.o_shipped_x86_64 lib/wlc_hybrid.o_shipped
else
   cp src/lib/wlc_hybrid.o_shipped_i386 lib/wlc_hybrid.o_shipped
fi
. %_usrsrc/linux-%kversion-%flavour/gcc_version.inc
make -C %_usrsrc/linux-%kversion-%flavour SUBDIRS=`pwd` modules

%install
mkdir -p $RPM_BUILD_ROOT%module_dir/

cd bcmwl
. %_usrsrc/linux-%kversion-%flavour/gcc_version.inc
make -C %_usrsrc/linux-%kversion-%flavour INSTALL_MOD_PATH=%buildroot INSTALL_MOD_DIR=net SUBDIRS=`pwd`  modules_install

# blacklist several modules (see ALT bugs #26265, #26250)
mkdir -p %buildroot/%_sysconfdir/modprobe.d
cat > %buildroot/%_sysconfdir/modprobe.d/blacklist-bcm.conf << __EOF__
blacklist bcm43xx
blacklist ssb
blacklist b43
__EOF__
cat > %buildroot/%_sysconfdir/modprobe.d/blacklist-bcm2.conf << __EOF__
blacklist b44
blacklist b43legacy
blacklist bcma
blacklist brcmsmac
blacklist bcma-pci-bridge
__EOF__

%files
%module_dir
%config(noreplace) %_sysconfdir/modprobe.d/blacklist-bcm.conf
%config(noreplace) %_sysconfdir/modprobe.d/blacklist-bcm2.conf

%changelog
