%define _unpackaged_files_terminate_build	1

%define module_name	dahdi
%define module_version	2.10.2
%define module_release alt1.M70P.2

%define flavour	ovz-el
BuildRequires(pre): rpm-build-kernel
BuildRequires(pre): kernel-headers-modules-ovz-el

%setup_kernel_module %flavour

%define module_dir /lib/modules/%kversion-%flavour-%krelease/%module_name

%define kernel_headers_dir %prefix/src/linux-%kversion-%flavour-%krelease
%define module_headers_dir %kernel_headers_dir/drivers/%module_name

Summary: %module_name modules
Name: kernel-modules-%module_name-%flavour
Version: %module_version
Release: %module_release.%kcode.%kbuildrelease
License: GPL
Group: System/Kernel and hardware

Packager: Kernel Maintainer Team <kernel@packages.altlinux.org>

Requires: dahdi-udev

ExclusiveOS: Linux
Url: http://www.asterisk.org/index.php?menu=download

# Automatically added by buildreq on Sun Nov 07 2004
BuildRequires: kernel-source-%module_name
BuildRequires(pre): rpm-build-kernel
BuildRequires: kernel-headers-modules-%flavour = %kepoch%kversion-%krelease
ExclusiveArch: %karch

Provides: kernel-modules-%module_name-%kversion-%flavour-%krelease = %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease < %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease > %version-%release

PreReq: kernel-image-%flavour = %kepoch%kversion-%krelease

%description
dahdi modules, that needed for all Digium hardware, and some compatible
devices for telephony.

%package -n kernel-headers-%module_name-%flavour
Summary: dahdi driver headers
Group: Development/Kernel
PreReq: kernel-headers-modules-%flavour = %kversion-%krelease
Requires(postun): kernel-headers-modules-%flavour = %kversion-%krelease
Provides: kernel-headers-%module_name-%kversion-%flavour-%krelease = %version-%release

%description -n kernel-headers-%module_name-%flavour
This package contains dahdi driver headers and other files needed for
compiling kernel modules which interface with dahdi drivers.

%prep
rm -rf kernel-source-%module_name-%module_version

tar -jxvf %kernel_src/kernel-source-%module_name-%module_version.tar.bz2

%setup -D -T -n kernel-source-%module_name-%module_version

%build
pushd dahdi
export KERNEL_SOURCE=%_usrsrc/linux-%kversion-%flavour
subst s!-I/usr/src/linux-2.4/!-I%_usrsrc/linux-%kversion-%flavour!g Makefile
subst s!^KINCLUDES=.*$/!KINCLUDES=%_usrsrc/linux-%kversion-%flavour!g Makefile
subst 's! # ztdummy! ztdummy!' Makefile
subst 's!PRIMARY=.*!PRIMARY=ztdummy!' Makefile

. %_usrsrc/linux-%kversion-%flavour/gcc_version.inc

#chmod +x menuselect/configure

#./configure
#make version.h
#make tones.h tor2fw.h radfw.h
make \
	KVERS=%kversion \
	KSRC=%_usrsrc/linux-%kversion-%flavour

#make -C %_usrsrc/linux-%kversion-%flavour SUBDIRS=`realpath .` modules \
popd


%install
. %_usrsrc/linux-%kversion-%flavour/gcc_version.inc
pushd dahdi
make \
	KVERS=%kversion \
	KSRC=%_usrsrc/linux-%kversion-%flavour \
	DESTDIR=%buildroot \
	install-modules

#make -C %_usrsrc/linux-%kversion-%flavour \
#    SUBDIRS=`realpath .`/kernel \
#    DESTDIR=%buildroot \
#    install

#    INSTALL_MOD_PATH=%buildroot/%module_dir \

#mv %buildroot/%module_dir/lib/modules/*/extra/* %buildroot/%module_dir/
#rmdir %buildroot/%module_dir/lib/modules/*/extra
rm -f %buildroot/lib/modules/%kversion-%flavour-%krelease/modules.*
#rmdir %buildroot/%module_dir/lib/modules/*
#rmdir %buildroot/%module_dir/lib/modules
#rmdir %buildroot/%module_dir/lib

mkdir -p %buildroot%module_headers_dir
pushd include/dahdi
cp -p *.h \
	%buildroot%module_headers_dir/

echo "%name = %version-%release" \
	> %buildroot%kernel_headers_dir/kernel-modules-%module_name.release
popd
pushd drivers/dahdi
sed -e 's|%_builddir/||' < Module.symvers \
	> %buildroot%kernel_headers_dir/kernel-modules-%module_name.symvers
sed -e 's|%_builddir/||' < Module.symvers \
	> %buildroot%module_headers_dir/Module.symvers
popd

%files
%defattr(644,root,root,755)
%dir %module_dir
%dir %module_dir/oct612x
%dir %module_dir/voicebus
%dir %module_dir/wcb4xxp
%dir %module_dir/wct4xxp
%dir %module_dir/wctc4xxp
%dir %module_dir/wctdm24xxp
%dir %module_dir/wcte12xp
%dir %module_dir/xpp

%module_dir/dahdi.ko
%module_dir/dahdi_*.ko
%module_dir/dahdi_dynamic_ethmf.ko
%module_dir/oct612x/oct612x.ko
%module_dir/pciradio.ko
%module_dir/tor2.ko
%module_dir/voicebus/dahdi_voicebus.ko
%module_dir/wcaxx.ko
%module_dir/wcb4xxp/wcb4xxp.ko
%module_dir/wcfxo.ko
%module_dir/wct1xxp.ko
%module_dir/wct4xxp/wct4xxp.ko
%module_dir/wctc4xxp/wctc4xxp.ko
%module_dir/wctdm.ko
%module_dir/wctdm24xxp/wctdm24xxp.ko
%module_dir/wcte11xp.ko
%module_dir/wcte12xp/wcte12xp.ko
%module_dir/wcte13xp.ko
%module_dir/wcte43x.ko
%module_dir/xpp/xpd_bri.ko
%module_dir/xpp/xpd_echo.ko
%module_dir/xpp/xpd_echo.ko
%module_dir/xpp/xpd_fxo.ko
%module_dir/xpp/xpd_fxs.ko
%module_dir/xpp/xpd_pri.ko
%module_dir/xpp/xpp.ko
%module_dir/xpp/xpp_usb.ko

%files -n kernel-headers-%module_name-%flavour
%module_headers_dir
%kernel_headers_dir/kernel-modules-%module_name.release
%kernel_headers_dir/kernel-modules-%module_name.symvers

%changelog
