%define module_name             lsadrv
%define module_version          1.2.3
%define module_release 		alt0.M70P.1

%define flavour		un-def
BuildRequires(pre): rpm-build-kernel
BuildRequires(pre): kernel-headers-modules-un-def

%setup_kernel_module %flavour

%define module_dir /lib/modules/%kversion-%flavour-%krelease/%module_name

Name: kernel-modules-%module_name-%flavour
Version: %module_version
Release: %module_release.%kcode.%kbuildrelease
Epoch: 1

Summary: Linux Kernel drivers supporting Hitachi StarBoard interactive whiteboard
License: GPL
Group: System/Kernel and hardware
Url: http://www.charmexdocs.com/int/software/SBS0962_LINUX.zip

Packager: Kernel Maintainer Team <kernel@packages.altlinux.org>

Patch1: ioctl_and_mutex.patch
Patch2: lsadrv-build-3.10.patch

ExclusiveOS: Linux
BuildRequires(pre): rpm-build-kernel
BuildRequires: kernel-headers-modules-%flavour = %kepoch%kversion-%krelease
BuildRequires: kernel-source-%module_name-%module_version

Provides: kernel-modules-%module_name-%kversion-%flavour-%krelease = %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease < %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease > %version-%release

PreReq: kernel-image-%flavour = %kepoch%kversion-%krelease
ExclusiveArch: %karch

%description
%module_name kernel driver for Linux.
This is usable for Hitachi StarBoard interactive whiteboard.
    FX-63/77(G)/82(WG) Wired
    FX-DUO-63/77/88W Wired
    FX-TRIO-77/77(S)/88W

This is module for your ALT Linux system.

%prep
rm -rf kernel-source-%module_name-%module_version
tar -jxvf %kernel_src/kernel-source-%module_name-%module_version.tar.bz2
%setup -D -T -n kernel-source-%module_name-%module_version

%patch1 -p1
%patch2

%build
. %_usrsrc/linux-%kversion-%flavour/gcc_version.inc
%make KERNEL_SRC=%_usrsrc/linux-%kversion-%flavour-%krelease \
    KERNELRELEASE=%kversion-%flavour-%krelease \
    %kversion-%flavour-%krelease/%module_name.ko

%install
install -d %buildroot/%module_dir
cp -a %kversion-%flavour-%krelease/%module_name.ko %buildroot/%module_dir/

%files
%module_dir

%changelog
