%define module_name	mt7601u
%define module_version	2015.09.24
%define module_release alt2

%define flavour		un-def
BuildRequires(pre): rpm-build-kernel
BuildRequires(pre): kernel-headers-modules-un-def

%setup_kernel_module %flavour

%define norm_version	%kversion

%define module_dir /lib/modules/%kversion-%flavour-%krelease/kernel/net/wireless

Summary: Module for MediaTek MT7601U Wi-Fi USB dongle
Name: kernel-modules-%module_name-%flavour
Version: %module_version
Release: %module_release.%kcode.%kbuildrelease
License: GPL
Group: System/Kernel and hardware

Packager: Motsyo Gennadi <drool@altlinux.ru>

Source1: mt7601u.bin

ExclusiveOS: Linux
Url: https://github.com/kuba-moo/mt7601u.git

BuildRequires(pre): rpm-build-kernel
BuildRequires: kernel-source-%module_name = %module_version
BuildRequires: kernel-headers-modules-%flavour = %kepoch%kversion-%krelease

Provides: kernel-modules-%module_name-%kversion-%flavour-%krelease = %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease < %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease > %version-%release

PreReq: kernel-image-%flavour = %kepoch%kversion-%krelease
ExclusiveArch: %karch

%description
This is a Linux driver for MediaTek MT7601U USB dongle. It was written from scratch based on the vendor
GPL-driver. Unlike the vendor driver this driver uses modern Linux WiFi infrastructure and should work
flawlessly with NetworkManager, wicd, wpa_supplicant and such. This driver was merged into mainline and
is part of official Linux kernel since version v4.2. If you are using Linux 4.2 or later there is no
need to install this driver.

%package -n firmware-%module_name
Summary: Firmware for MediaTek MT7601U Wi-Fi USB dongle
Group: System/Kernel and hardware
Url: https://github.com/porjo/mt7601/
BuildArch: noarch
Provides: firmware-mt7601u

%description -n firmware-%module_name
Firmware for MediaTek MT7601U Wi-Fi USB dongle

%prep
rm -rf kernel-source-%module_name-%module_version

tar -jxvf %kernel_src/kernel-source-%module_name-%module_version.tar.bz2

%setup -D -T -n %module_name

%build
. %_usrsrc/linux-%kversion-%flavour/gcc_version.inc
export CFLAGS+="%optflags"
make -C %_usrsrc/linux-%kversion-%flavour SUBDIRS=`pwd`

%install
mkdir -p $RPM_BUILD_ROOT%module_dir/
install -Dp -m 0644 %module_name.ko %buildroot/%module_dir/%module_name.ko

install -Dp -m 0644 %SOURCE1 %buildroot/lib/firmware/mt7601u.bin

%files
%module_dir/*.ko

%files -n firmware-%module_name
/lib/firmware/mt7601u.bin

%changelog
