%define nvIF_ver_gt() %if "%(rpmvercmp '%1' '%2')" > "0"
%define nvIF_ver_gteq() %if "%(rpmvercmp '%1' '%2')" >= "0"
%define nvIF_ver_lt() %if "%(rpmvercmp '%2' '%1')" > "0"
%define nvIF_ver_lteq() %if "%(rpmvercmp '%2' '%1')" >= "0"

%define module_name	nvidia
%define module_version	331.79
%define module_release	alt2
%define flavour		led-ws

%setup_kernel_module %flavour
%define module_srcver	%(echo %module_version | tr -d .)
%define xorg_ver %{get_version xorg-server}
%if "%xorg_ver" == ""
%define xorg_ver %{get_version xorg-x11-server}
%endif
%nvIF_ver_lt %xorg_ver 1.6
%define legacy1 71.86.13
%else
%define legacy1 %nil
%endif
%define legacy1_src %(echo %legacy1 | tr -d .)
%nvIF_ver_lt %xorg_ver 1.13
%define legacy2 96.43.23
%else
%define legacy2 %nil
%endif
%define legacy2_src %(echo %legacy2 | tr -d .)
%nvIF_ver_lt %xorg_ver 1.16
%define legacy3 173.14.39
%else
%define legacy3 %nil
%endif
%define legacy3_src %(echo %legacy3 | tr -d .)
%nvIF_ver_lt %xorg_ver 1.16
%define legacy4 304.121
%else
%define legacy4 %nil
%endif
%define legacy4_src %(echo %legacy4 | tr -d .)
%define mod_ver_list %version %legacy1 %legacy2 %legacy3 %legacy4

%define module_dir /lib/modules/%kversion-%flavour-%krelease/nVidia
%define module_local_dir /lib/modules/nvidia
%define module_version_dir /lib/modules/%kversion-%flavour-%krelease/.versions
%define nvidia_workdir %_localstatedir/nvidia
%define module_ext .ko
%nvIF_ver_lt "%kversion" "2.5.0"
%define module_ext .o
%endif

Summary:	nVidia video card drivers
Name:		kernel-modules-%module_name-%flavour
Version:	%module_version
Release:	%module_release.%kcode.%kbuildrelease
License:	Proprietary
Group:		System/Kernel and hardware
URL:		http://www.nvidia.com

Packager:       Kernel Maintainer Team <kernel@packages.altlinux.org>

ExclusiveArch: %karch

BuildRequires(pre): rpm-build-kernel xorg-x11-server
BuildRequires(pre): kernel-headers-modules-led-ws
BuildRequires: rpm-utils
BuildRequires: kernel-headers-modules-%flavour = %kepoch%kversion-%krelease
BuildRequires: kernel-source-%module_name-%module_srcver
%if "%legacy1" != "%nil"
BuildRequires: kernel-source-%module_name-%legacy1_src
%endif
%if "%legacy2" != "%nil"
BuildRequires: kernel-source-%module_name-%legacy2_src
%endif
%if "%legacy3" != "%nil"
BuildRequires: kernel-source-%module_name-%legacy3_src
%endif
%if "%legacy4" != "%nil"
BuildRequires: kernel-source-%module_name-%legacy4_src
%endif

Provides:  	kernel-modules-%module_name-%kversion-%flavour-%krelease = %version-%release
Conflicts: 	kernel-modules-%module_name-%kversion-%flavour-%krelease < %version-%release
Conflicts: 	kernel-modules-%module_name-%kversion-%flavour-%krelease > %version-%release

Conflicts: modutils < 2.4.27-alt4

PreReq: kernel-image-%flavour = %kepoch%kversion-%krelease
Requires:       nvidia_glx_%version
%if "%legacy1" != "%nil"
Requires:       nvidia_glx_%legacy1
%endif
%if "%legacy2" != "%nil"
Requires:       nvidia_glx_%legacy2
%endif
%if "%legacy3" != "%nil"
Requires:       nvidia_glx_%legacy3
%endif
%if "%legacy4" != "%nil"
Requires:       nvidia_glx_%legacy4
%endif

%description
nVidia video card drivers that provide 3d and 2d graphics support for XFree86
Xserver.


%prep
%setup -cT
for ver in %mod_ver_list
do
    sffx=`echo "$ver"| sed -e "s|\.||g"`
    rm -rf kernel-source-%module_name-$sffx
    tar -jxvf %_usrsrc/kernel/sources/kernel-source-%module_name-$sffx.tar.bz2

    pushd kernel-source-%module_name-$sffx
    rm -f makefile
    if [ -f Makefile.kbuild ]; then
	rm -f Makefile
	ln -s Makefile.kbuild Makefile
    fi
    popd
done


%build
for ver in %mod_ver_list
do
    sffx=`echo "$ver"| sed -e "s|\.||g"`
    pushd kernel-source-%module_name-$sffx
    %make_build -C %_usrsrc/linux-%kversion-%flavour modules \
	SUBDIRS=$PWD TEMP_DIR=$PWD/ \
	ARCH=%base_arch \
	SYSSRC=%_usrsrc/linux-%kversion-%flavour
    popd
done

%install
mkdir -p %buildroot/%module_dir
mkdir -p %buildroot/%module_local_dir
mkdir -p %buildroot/%module_version_dir
mkdir -p %buildroot/%nvidia_workdir

for ver in %mod_ver_list
do
    sffx=`echo "$ver"| sed -e "s|\.||g"`
    pushd kernel-source-%module_name-$sffx
    install -p -m644 %module_name%module_ext %buildroot/%module_local_dir/%kversion-%flavour-%krelease-$ver
popd
done

echo -n "%version" >%buildroot/%nvidia_workdir/%kversion-%flavour-%krelease
ln -s %nvidia_workdir/%kversion-%flavour-%krelease %buildroot/%module_version_dir/%module_name
ln -s %module_local_dir/%kversion-%flavour-%krelease-%version %buildroot/%module_dir/%module_name%module_ext


%post
# switch nvidia driver and libraries
if [ -z "$DURING_INSTALL" ]; then
    if [ "`uname -r`" == "%kversion-%flavour-%krelease" ] ; then
	X11PRESETDRV=`which x11presetdrv 2>/dev/null`
	if [ -n "$X11PRESETDRV" ]; then
	    $X11PRESETDRV ||:
	else
	    echo "Warning! x11presetdrv program not found!" >&2
	fi
    fi
fi

%postun
if [ -z "$DURING_INSTALL" ]; then
    if [ "`uname -r`" == "%kversion-%flavour-%krelease" ] ; then
	X11PRESETDRV=`which x11presetdrv 2>/dev/null`
	if [ -n "$X11PRESETDRV" ]; then
	    $X11PRESETDRV ||:
	else
	    echo "Warning! x11presetdrv program not found!" >&2
	fi
    fi
fi

%files
%defattr(644,root,root,755)
%module_dir
%module_version_dir/%module_name
%module_local_dir/%kversion-%flavour-%krelease-*
%config(noreplace) %nvidia_workdir/%kversion-%flavour-%krelease

%changelog
