%define module_name             tp_smapi
%define module_version          0.41
%define module_release alt2

%define flavour		ovz-el
BuildRequires(pre): rpm-build-kernel
BuildRequires(pre): kernel-headers-modules-ovz-el

%setup_kernel_module %flavour

%define module_dir /lib/modules/%kversion-%flavour-%krelease/%module_name

Name: kernel-modules-%module_name-%flavour
Version: %module_version
Release: %module_release.%kcode.%kbuildrelease

Summary: IBM ThinkPad SMAPI Driver
License: GPL
Group: System/Kernel and hardware
Url: http://tpctl.sourceforge.net

Packager: Kernel Maintainer Team <kernel@packages.altlinux.org>

ExclusiveOS: Linux
BuildRequires(pre): rpm-build-kernel
BuildRequires: kernel-headers-modules-%flavour = %kepoch%kversion-%krelease
BuildRequires: kernel-source-%module_name-%module_version

Provides: kernel-modules-%module_name-%kversion-%flavour-%krelease = %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease < %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease > %version-%release

PreReq: kernel-image-%flavour = %kepoch%kversion-%krelease
ExclusiveArch: %karch

%description
ThinkPad laptops include a proprietary interface called SMAPI BIOS
(System Management Application Program Interface) which provides some
hardware control functionality that is not accessible by other means.

This driver exposes some features of the SMAPI BIOS through a sysfs
interface. It is suitable for newer models, on which SMAPI is invoked
through IO port writes. Older models use a different SMAPI interface;
for those, try the "thinkpad" module.

These are modules for your ALT Linux system.

%prep
rm -rf kernel-source-%module_name-%module_version
tar -jxvf %kernel_src/kernel-source-%module_name-%module_version.tar.bz2
%setup -D -T -n kernel-source-%module_name-%module_version

%build
. %_usrsrc/linux-%kversion-%flavour/gcc_version.inc
%make_build KSRC=%_usrsrc/linux-%kversion-%flavour \
	KBUILD=%_usrsrc/linux-%kversion-%flavour \
	HDAPS=1

%install
install -d %buildroot/%module_dir
cp -a {thinkpad_ec,tp_smapi,hdaps}.ko %buildroot/%module_dir/

%files
%module_dir
%exclude %module_dir/hdaps.ko
%doc README CHANGES

%changelog
