%define module_name	virtualbox
%define module_version	4.3.26

%define module_release	alt2

%define drv_module_name	vboxdrv
%define pci_module_name	vboxpci
%define net_module_name	vboxnetflt
%define net_module_adaptor_name	vboxnetadp

%define flavour		un-def
BuildRequires(pre): rpm-build-kernel >= 0.100-alt1
BuildRequires(pre): kernel-headers-modules-un-def

%setup_kernel_module %flavour

%define module_dir /lib/modules/%kversion-%flavour-%krelease/misc

Summary: VirtualBox modules
Name: kernel-modules-%module_name-%flavour
Version: %module_version
Release: %module_release.%kcode.%kbuildrelease
License: GPL
Group: System/Kernel and hardware

Packager: Kernel Maintainer Team <kernel@packages.altlinux.org>

ExclusiveOS: Linux
Url: http://www.virtualbox.org/

BuildPreReq: gcc-c++
BuildRequires: perl
BuildRequires: rpm >= 4.0.2-75
BuildRequires: kernel-headers-modules-%flavour = %kepoch%kversion-%krelease
BuildRequires: kernel-source-%drv_module_name = %module_version
BuildRequires: kernel-source-%pci_module_name = %module_version
BuildRequires: kernel-source-%net_module_name = %module_version
BuildRequires: kernel-source-%net_module_adaptor_name = %module_version

Patch0: vbox-kernel-4.1-build.patch

Provides: kernel-modules-%module_name-%kversion-%flavour-%krelease = %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease < %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease > %version-%release

PreReq: kernel-image-%flavour = %kepoch%kversion-%krelease
ExclusiveArch: %karch

Requires: %module_name-common

%description
This package contains VirtualBox modules (vboxdrv) that are needed
for VirtualBox to run. Note that you have to compile these modules on the
system with your VirtualBox version installed or you will have to specify
your VirtualBox version as `version' parameter when loading these modules
or in your /etc/modules.conf file.

%prep
%setup -T -c -n kernel-source-%module_name-%module_version
tar jxvf %kernel_src/kernel-source-%drv_module_name-%module_version.tar.bz2
tar jxvf %kernel_src/kernel-source-%pci_module_name-%module_version.tar.bz2
tar jxvf %kernel_src/kernel-source-%net_module_name-%module_version.tar.bz2
tar jxvf %kernel_src/kernel-source-%net_module_adaptor_name-%module_version.tar.bz2
pushd kernel-source-vboxpci-%module_version/linux/
%patch0 -p0
popd

%build
. %_usrsrc/linux-%kversion-%flavour/gcc_version.inc
%make -C kernel-source-%drv_module_name-%module_version \
    KERN_DIR=%_usrsrc/linux-%kversion-%flavour/
cp kernel-source-%drv_module_name-%module_version/Module.symvers \
    kernel-source-%pci_module_name-%module_version
%make -C kernel-source-%pci_module_name-%module_version \
    KERN_DIR=%_usrsrc/linux-%kversion-%flavour/
cp kernel-source-%drv_module_name-%module_version/Module.symvers \
    kernel-source-%net_module_name-%module_version
%make -C kernel-source-%net_module_name-%module_version \
    KERN_DIR=%_usrsrc/linux-%kversion-%flavour/
cp kernel-source-%drv_module_name-%module_version/Module.symvers \
    kernel-source-%net_module_adaptor_name-%module_version
%make -C kernel-source-%net_module_adaptor_name-%module_version \
    KERN_DIR=%_usrsrc/linux-%kversion-%flavour/

%install
mkdir -p %buildroot/%module_dir
install -pD -m644 kernel-source-%drv_module_name-%module_version/vboxdrv.ko \
    %buildroot%module_dir/
install -pD -m644 kernel-source-%pci_module_name-%module_version/vboxpci.ko \
    %buildroot%module_dir/
install -pD -m644 kernel-source-%net_module_name-%module_version/vboxnetflt.ko \
    %buildroot%module_dir/
install -pD -m644 kernel-source-%net_module_adaptor_name-%module_version/vboxnetadp.ko \
    %buildroot%module_dir/

%files
%defattr(644,root,root,755)
%module_dir

%changelog
