%define original_kernel_version	3.9
%define kernel_version		3.9
%define patch_level		%nil

%define testing			0

%if %testing
%define kernel_fullversion	%kernel_version%patch_level
%else
%define kernel_fullversion	%kernel_version
%endif

# Numeric extra version scheme developed by Alexander Bokovoy:
# 0.0.X -- preX
# 0.X.0 -- rcX, testX
# 1.0.0 -- release
%define patch_level_numeric     1.0.0

Name: kernel-source-%kernel_version
Version: %patch_level_numeric
Release: alt1

Summary: Linux kernel %kernel_fullversion sources
License: GPL
Group: Development/Kernel
Packager: Kernel Maintainers Team <kernel@packages.altlinux.org>

Source0: linux-%original_kernel_version.tar.bz2

BuildArch: noarch
BuildPreReq: kernel-build-tools

%description
Kernel sources for Linux kernel %kernel_fullversion

%prep
%setup -qc
mv linux-%original_kernel_version kernel-source-%kernel_version
%if %testing
pushd kernel-source-%kernel_version
popd
%endif


%install
mkdir -p %kernel_srcdir
tar --owner=root --group=root --mode=u+w,go-w,go+rX -cjf \
	%kernel_srcdir/kernel-source-%kernel_version.tar.bz2 \
	kernel-source-%kernel_version

%files
%kernel_src/kernel-source-%kernel_version.tar.bz2

%changelog
