%define cfgdir		%_sysconfdir/%name

Name: kismet
Version: 2010.07.R1
Release: alt1.1.qa1

Summary: Kismet wireless tools
License: GPLv2+
Group: Security/Networking

Url: http://www.kismetwireless.net/

Packager: Andrey Rahmatullin <wrar@altlinux.ru>

Source: %name-%version.tar

BuildPreReq: control gcc-c++ libcap-devel libncurses-devel libnl-devel
BuildPreReq: libpcap-devel libpcre-devel libssl-devel setproctitle-devel
BuildPreReq: libbluez-devel

Requires: kismet-client = %version-%release
Requires: kismet-server = %version-%release
Requires: kismet-drone = %version-%release
Requires: kismet-plugins = %version-%release

%define _unpackaged_files_terminate_build 1


%description
Kismet is an 802.11 layer2 wireless network detector, sniffer, and
intrusion detection system. Kismet will work with any wireless card
which supports raw monitoring (rfmon) mode, and can sniff 802.11b,
802.11a, and 802.11g traffic.

Kismet identifies networks by passively collecting packets and detecting
standard named networks, detecting (and given time, decloaking) hidden
networks, and infering the presence of nonbeaconing networks via data
traffic.

This package is a virtual package requiring all the kismet files to be
installed. You may want to install it in the first time using kismet.

%package common
Summary: Common files for both client/server of kismet
Group: Security/Networking

%description common
Kismet is an 802.11 layer2 wireless network detector, sniffer, and
intrusion detection system. Kismet will work with any wireless card
which supports raw monitoring (rfmon) mode, and can sniff 802.11b,
802.11a, and 802.11g traffic.

This package contains common files for client/server of kismet.

%package client
Summary: Client user interface for kismet
Group: Security/Networking
Requires: kismet-common = %version-%release

%description client
Kismet is an 802.11 layer2 wireless network detector, sniffer, and
intrusion detection system. Kismet will work with any wireless card
which supports raw monitoring (rfmon) mode, and can sniff 802.11b,
802.11a, and 802.11g traffic.

This package contains user interface for kismet.

%package server
Summary: Server side of kismet project
Group: Security/Networking
Requires: kismet-common = %version-%release

%description server
Kismet is an 802.11 layer2 wireless network detector, sniffer, and
intrusion detection system. Kismet will work with any wireless card
which supports raw monitoring (rfmon) mode, and can sniff 802.11b,
802.11a, and 802.11g traffic.

This package contains server side of kismet project.

%package drone
Summary: Drone part of kismet project
Group: Security/Networking

%description drone
Kismet is an 802.11 layer2 wireless network detector, sniffer, and
intrusion detection system. Kismet will work with any wireless card
which supports raw monitoring (rfmon) mode, and can sniff 802.11b,
802.11a, and 802.11g traffic.

This package contains drone part of kismet project.

%package plugins
Summary: Plugins for kismet
Group: Security/Networking
Requires: %name-common = %version-%release

%description plugins
Kismet is an 802.11 layer2 wireless network detector, sniffer, and
intrusion detection system. Kismet will work with any wireless card
which supports raw monitoring (rfmon) mode, and can sniff 802.11b,
802.11a, and 802.11g traffic.

This package contains plugins shipped by the kismet package.


%prep
%setup

sed -i \
	-e '\!^ouifile=/etc/manuf!d' \
	-e '\!^ouifile=/usr/share/wireshark/wireshark/manuf!d' \
    		conf/kismet.conf.in conf/kismet_drone.conf

bzip2 CHANGELOG
%autoreconf

%build
export ac_cv_lib_uClibcpp_main=no	# we do not want to build against uClibc++, even when available
%configure \
	--sysconfdir=%cfgdir \
	--with-pcreheaders=%_includedir/pcre

%make_build dep
%make_build HOME="$HOME"

for i in plugin-{autowep,btscan,ptw,spectools}; do
	%make_build -C $i KIS_SRC_DIR=`pwd` \
		CFLAGS="-I\$(KIS_SRC_DIR) -I%_includedir/pcre -fPIC %optflags"
done

%install
%makeinstall_std \
	INSTUSR="$(id -un)" INSTGRP="$(id -gn)" MANGRP="$(id -gn)"

for i in plugin-{autowep,btscan,ptw,spectools}; do
	%make install -C $i \
		INSTUSR="$(id -un)" INSTGRP="$(id -gn)" \
		KIS_SRC_DIR=`pwd` DESTDIR=`pwd`/_tmp
	install -pD -m644 $i/README %buildroot%_docdir/%name-plugins-%version/$i/README
done

mkdir -p %buildroot%_libdir/kismet{,_client}
install -pD -m755 _tmp/usr/lib/kismet/* %buildroot%_libdir/kismet/
install -pD -m755 _tmp/usr/lib/kismet_client/* %buildroot%_libdir/kismet_client/

install -pD -m755 %name-capture.control %buildroot%_controldir/%name-capture
install -pD -m755 kismet_capture %buildroot%_bindir/

rm -f %buildroot%_bindir/%name


%pre server
/usr/sbin/groupadd -r -f netadmin
%pre_control %name-capture

%post server
%post_control -s netadmin %name-capture


%files

%files common
%dir %cfgdir
%dir %_libdir/kismet/
%dir %_libdir/kismet_client/
%_datadir/kismet
%_man1dir/kismet.1*
%doc CHANGELOG* README* docs/ extra/old/

%files client
%_bindir/kismet_client

%files server
%config %_controldir/%name-capture
%_bindir/kismet_server
%attr(700,root,root) %verify(not mode,group) %_bindir/kismet_capture
%config(noreplace) %cfgdir/kismet.conf
%_man5dir/kismet.conf*

%files drone
%_bindir/kismet_drone
%_man1dir/kismet_drone*
%_man5dir/kismet_drone*
%config(noreplace) %cfgdir/kismet_drone.conf

%files plugins
%_libdir/kismet/*.so
%_libdir/kismet_client/*.so
%_docdir/%name-plugins-%version/

%changelog
