Name: klibc
Version: 2.0.2
Release: alt2
Summary: A minimal libc subset for use with initramfs
License: BSD/GPL
Group: System/Libraries
URL: http://www.zytor.com/mailman/listinfo/%name
# git://git.kernel.org/pub/scm/libs/klibc/klibc
Source0: %name-%version.tar
Source1: %name-find-provides
Source2: %name-find-requires
Patch: %name-%version-%release.patch

# due to %%base_arch
BuildPreReq: rpm-build-kernel

%define klibcdir  %_libdir/%name
%define libdocdir %_docdir/%name-%version-%release
%define bindocdir %_docdir/%name-utils-%version-%release

# Use special scripts to find dependencies on klibc-*.so (default RPM scripts
# do not pick up these dependencies).
%global __find_provides %_builddir/%name-%version/%name-find-provides %__find_provides
%global __find_requires %_builddir/%name-%version/%name-find-requires %__find_requires

%description
%name is intended to be a minimalistic libc subset for use with initramfs.
It is deliberately written for small size, minimal entanglement, and portability,
not speed.


%package devel
Summary: Libraries and tools needed to compile applications against klibc
Group: Development/C
Requires: %name = %version-%release
AutoReq: nocpp
Provides: klcc = %version-%release
Provides: %name-devel-static = %version-%release

%description devel
This package contains the link libraries, header files, and gcc wrapper scripts
needed to compile applications against klibc.


%package utils
Summary: Small utilities built with klibc
Group: System/Kernel and hardware
Requires: %name = %version-%release

%description utils
This package contains a collection of programs that are linked against klibc.
These duplicate some of the functionality of a regular Linux toolset, but are
typically much smaller than their full-function counterparts. They are intended
for inclusion in initramfs images and embedded systems.


%package utils-initramfs
Summary: Utilities for initramfs images generated by mkinitrd
Group: System/Kernel and hardware
Requires: %name = %version-%release
PreReq: mkinitrd-initramfs

%description utils-initramfs
This package contains utilities for use in initramfs images generated by
mkinitrd.


%prep
%setup
%patch -p1
# Install fixed scsi headers
install -d -m 0755 usr/include/scsi
for f in %_includedir/scsi/*; do
	sed '/^#[[:blank:]]*include/s|features.h|sys/stat.h|' "$f" > usr/include/scsi/$(basename "$f")
done

install -p -m 0755 %{S:1} ./%name-find-provides
install -p -m 0755 %{S:2} ./%name-find-requires

# Assume that adjust_kernel_headers --first has been run.
install -d -m 0755 linux
ln -s "$(readlink -ev /usr/include/linux/../..)"/include linux/

cat > defconfig <<__EOF__
CONFIG_KLIBC=y
# CONFIG_KLIBC_ERRLIST is not set
# CONFIG_KLIBC_ZLIB is not set
# CONFIG_KLIB_ZIP is not set
# CONFIG_KINIT_LOAD_INITRD is not set
# i386 option
CONFIG_REGPARM=y
# ARM options
CONFIG_AEABI=y
# CONFIG_KLIBC_THUMB is not set
__EOF__


%build
%define optflags_debug %nil
%make_build V=1 \
	KLIBCARCH=%base_arch prefix=%prefix bindir=%_bindir \
	SHLIBDIR=/%_lib \
	INSTALLDIR=%klibcdir mandir=%_mandir INSTALLROOT=%buildroot


%install
%make_install KLIBCARCH=%base_arch prefix=%prefix bindir=%_bindir \
	SHLIBDIR=/%_lib \
	INSTALLDIR=%klibcdir mandir=%_mandir INSTALLROOT=%buildroot \
	install
rm -f %buildroot%klibcdir/include/Kbuild

install -p -m 0755 %name-find-requires %buildroot%klibcdir/

# Install the docs
install -d -m 0755 %buildroot{%bindocdir,%libdocdir}
install -p -m 0644 README usr/%name/{,arch/}README.%{name}* %buildroot%libdocdir/
for f in usr/{gzip/{COPYING,README},kinit{,/ipconfig}/README*}; do
	install -p -m 0644 $f %buildroot%bindocdir/$(basename $f).$(basename $(dirname $f))
done

# Install mkinitrd-klibc files
install -d -m 0755 %buildroot/lib/mkinitrd/%name/{bin,sbin,%_lib}
klibc_soname=$(basename $(ls %buildroot/%_lib/%name-*.so))
ln -s {,%buildroot/lib/mkinitrd/%name}/%_lib/$klibc_soname
ln -sf {/%_lib,%buildroot%klibcdir/lib}/$klibc_soname
install -p -m 0755 usr/dash/sh.shared %buildroot/lib/mkinitrd/%name/bin/sh
install -p -m 0755 usr/utils/shared/{cat,false,kill,ln,mkdir,mknod,mount,nuke,readlink,sleep,true,umount} \
	%buildroot/lib/mkinitrd/%name/bin/
install -p -m 0755 usr/utils/shared/halt %buildroot/lib/mkinitrd/%name/sbin/
for p in fstype ipconfig md_run nfsmount resume run-init; do
	install -p -m 0755 usr/kinit/$p/shared/$p %buildroot/lib/mkinitrd/%name/bin/
done

Symlinks()
{
	local src=$1 dir=$2
	shift 2
	while [ -n "$1" ]; do
		ln -sf $src %buildroot$dir/$1
		shift
	done
}

Symlinks gzip %klibcdir/bin gunzip zcat
for d in %klibcdir/bin /lib/mkinitrd/%name/sbin; do
	Symlinks halt $d poweroff reboot
done

# This file must have normal symbols - they are used for linking
# (klibc does not use the dynamic symbol table).
strip -g %buildroot%klibcdir/lib/libc.so
%ifdef brp_strip_none
%brp_strip_none %klibcdir/lib/libc.so
%else
%add_strip_skiplist %klibcdir/lib/libc.so
%endif


%check
#make_build test


%files
/%_lib/%name-*.so


%files devel
%klibcdir
%exclude %klibcdir/bin
%klibcdir/%name-find-requires
%_bindir/klcc
%_man1dir/*
%doc %libdocdir


%files utils
%dir %klibcdir
%klibcdir/bin
%doc %bindocdir


%files utils-initramfs
/lib/mkinitrd/%name


%changelog
