%define __libtoolize true
%define unstable 0
%define _optlevel s
%define glibc_core_ver %{get_version glibc-core}
%define _keep_libtool_files 1
%_K_if_ver_lt %glibc_core_ver 2.11
%define _keep_libtool_files 0
%endif
%def_disable gmagick

%add_findprov_lib_path %_libkde
%add_findpackage_path %_K3bindir
%add_findreq_skiplist %_K3apps/kross/python/RestrictedPython/*
%add_findreq_skiplist %_K3apps/chalk/scripts/*/*.rb
%add_verify_elf_skiplist %_libdir/libkexiformutils.so*
%add_verify_elf_skiplist %_libdir/libkexirelationsview.so*
%add_verify_elf_skiplist %_libdir/libkexidb.so*
%add_verify_elf_skiplist %_libdir/libkrossapi.so*
%add_verify_elf_skiplist %_libdir/libkexiguiutils.so*
%set_verify_elf_method no

%define qtdir %_qt3dir
%define kdedir %_K3prefix

%define rname koffice
Name: %{rname}16
Version: 1.6.3
%define rlz alt27
%define beta %nil
Serial: 4

%if "%beta" == "%nil"
Release: %rlz
%else
Release: %rlz.%beta
%endif

Group: Office
Summary: Set of office applications for KDE
URL: http://www.koffice.org/
License: GPL

Requires: %name-kexi = %version-%release
Requires: %name-kivio = %version-%release
Requires: %name-karbon = %version-%release
Requires: %name-kchart = %version-%release
Requires: %name-chalk = %version-%release
Requires: %name-kformula = %version-%release
Requires: %name-libs = %version-%release
Requires: %name-kpresenter = %version-%release
Requires: %name-kspread = %version-%release
Requires: %name-kugar = %version-%release
Requires: %name-kword = %version-%release
Requires: %name-kplato = %version-%release

%if "%beta" == "%nil"
Source: koffice-%version.tar
%else
Source: koffice-%version-%beta.tar
%endif

# ALT
Patch20: koffice-1.6.2-alt-desktop-categories.patch
Patch21: koffice-1.6.2-alt-no-kexi-examples.patch
Patch22: koffice-1.6.3-alt-new-imagick.patch
Patch23: koffice-1.6.3-alt-new2-imagick.patch
Patch24: koffice-1.6.3-alt-new3-imagick.patch
Patch25: koffice-1.6.3-alt-disable-gm.patch
Patch27: koffice-1.6.3-alt-no-tools.patch
Patch30: tde-3.5.13-build-defdir-autotool.patch
Patch31: koffice-1.6.3-alt-automake.patch
Patch32: tde-3.5.13-disable-arts.patch

BuildRequires(pre): kdelibs-devel
BuildRequires: bzlib-devel doxygen openexr-devel
BuildPreReq: libX11-devel libXaw-devel libXext-devel libXv-devel libICE-devel
BuildRequires: fontconfig-devel freetype2-devel gcc-c++ glib2-devel
BuildRequires: libImageMagick-devel
%if_enabled gmagick
BuildRequires: libGraphicsMagick-c++-devel
%endif
BuildRequires: kdelibs-devel libart_lgpl-devel
BuildRequires: libaspell-devel libexif-devel libgsf-devel libjpeg-devel liblcms-devel
BuildRequires: libpng-devel libqt3-devel libstdc++-devel libtiff-devel
#libwv2-devel	# For disable MS Office import
BuildRequires: libxml2-devel libxslt-devel pkg-config python-devel ruby libruby-devel
BuildRequires: libMySQL-devel libwpd-devel
BuildRequires: qt3-designer qt3-doc xml-utils zlib-devel libreadline-devel
BuildRequires: kdelibs >= 3.0.0 kdelibs-devel >= 3.0.0

%description
Office applications for the K Desktop Environment.

KOffice contains:
   * KWord: word processor
   * KSpread: spreadsheet
   * KPresenter: presentations
   * KChart: diagram generator
   * Kontour
   * Krayon
   * Kugar
   * Kivio
   * Some filters (Excel 97, Winword 97/2000, etc.)

%package common
Summary: Common empty package for %{rname}
Group: Graphical desktop/KDE
Requires: kde-common >= 3.2
Conflicts: koffice <= 1.2.1-alt4
%description common
Common empty package for %{rname}

%package devel
Group: Development/KDE and QT
Summary: Header files for developing koffice applications
Requires: %name-common = %serial:%version-%release
#
%description devel
Header files needed for developing koffice applications.

%package libs
Group: System/Libraries
Summary: Common libraries for koffice
Requires: kdelibs >= %{get_version kdelibs}
Requires: %name-common = %serial:%version-%release
%description libs
Common libraries for koffice

%package kplato
Group: Office
Summary: Project planning and management application
Requires: kdelibs >= %{get_version kdelibs}
Requires: %name-common = %serial:%version-%release
#
%description kplato
Kplato is a project management application and a planning tool.
As an integrated component of Koffice, Kplato can
be used within larger documents of other Koffice components.

%package karbon
Group: Graphics
Summary: Vector graphics application
Requires: kdelibs >= %{get_version kdelibs}
Requires: %name-common = %serial:%version-%release
#
%description karbon
Vector graphics application

%package kchart
Group: Office
Summary: Chart generator
Requires: kdelibs >= %{get_version kdelibs}
Requires: %name-common = %serial:%version-%release
#
%description kchart
Chart generator

%package kformula
Group: Office
Summary: Formula editor
Requires: kdelibs >= %{get_version kdelibs}
Requires: %name-common = %serial:%version-%release
#
%description kformula
Formula editor

%package kivio
Group: Office
Summary: Flowcharting tool
Requires: kdelibs >= %{get_version kdelibs}
Requires: %name-common = %serial:%version-%release
%description kivio
Flowcharting tool

%package kontour
Group: Office
Summary: Illustration tool
Obsoletes: kontour
Requires: kdelibs >= %{get_version kdelibs}
Requires: %name-common = %serial:%version-%release
#
%description kontour
Illustration tool

%package koshell
Group: Office
Summary: Koffice workspace
Requires: kdelibs >= %{get_version kdelibs}
Requires: %name-common = %serial:%version-%release
#
%description koshell
Koffice workspace

%package kpresenter
Group: Office
Summary: Presentation tool
Requires: kdelibs >= %{get_version kdelibs}
Requires: %name-common = %serial:%version-%release
#
%description kpresenter
Presentation tool

%package kspread
Group: Office
Summary: Spreadsheet application
Requires: kdelibs >= %{get_version kdelibs}
Requires: %name-common = %serial:%version-%release
#
%description kspread
Spreadsheet application

%package kugar
Group: Office
Summary: A template driven report viewer for XML data
Requires: kdelibs >= %{get_version kdelibs}
Requires: %name-common = %serial:%version-%release
#
%description kugar
A template driven report viewer for XML data

%package chalk
Group: Graphics
Summary: Paint application for bitmap images.
Requires: kdelibs >= %{get_version kdelibs}
Requires: %name-common = %serial:%version-%release
#
%description chalk
Chalk is a paint application for bitmap images.

%package kword
Group: Office
Summary: Word processor
Requires: kdelibs >= %{get_version kdelibs}
Requires: %name-common = %serial:%version-%release
#
%description kword
Word processor

%package kexi
Group: Office
Summary: Database management
Requires: kdelibs >= %{get_version kdelibs}
Requires: %name-common = %serial:%version-%release
AutoReq: noshell
%description kexi
Office database management program

%prep
%if "%beta" == "%nil"
%setup -q -n %{rname}-%version
%else
%setup -q -n %{rname}-%version-%beta
%endif

%patch20 -p1
%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch24 -p1
%if_disabled gmagick
%patch25 -p1
%endif
%patch27 -p1
%patch30
%patch31 -p0
%patch32 -p1

# fix compile with qt-3.3.8d
sed -i "s|QSplitterLayoutStruct|KDGanttSplitterLayoutStruct|g" kdgantt/KDGanttMinimizeSplitter.*

%if %_keep_libtool_files
for f in `find $PWD -type f -name Makefile.am`
do
    grep -q LDFLAGS $f || continue
    RPATH_LINK_OPTS+=" -Wl,-rpath-link,`dirname $f`/.libs"
done
sed -i "s|\(-Wl,--as-needed\)| $RPATH_LINK_OPTS \1|g" admin/acinclude.m4.in
%else
#subst "s/\(Wl,--no-undefined\)/-Wl,--warn-unresolved-symbols \1/g" admin/acinclude.m4.in
subst "s/\(Wl,--no-undefined\)/ -Wl,--allow-shlib-undefined \1/g" admin/acinclude.m4.in
subst "s/\-lkdeui/-lkdeui -lpthread/g" admin/acinclude.m4.in
subst "s/\.la/.so/g" admin/acinclude.m4.in
%endif

cp -Rp /usr/share/libtool/aclocal/libtool.m4 admin/libtool.m4.in
cp -Rp /usr/share/libtool/config/ltmain.sh admin/ltmain.sh
make -f admin/Makefile.common cvs

%build
export QTDIR=%qtdir KDEDIR=%kdedir
export PATH=$QTDIR/bin:$KDEDIR/bin:$PATH
export LDFLAGS="-L%qtdir/lib"
export CXXFLAGS="-I%_includedir/poppler/qt3"

%K3configure \
%if "%beta" != "%nil" || %unstable
    --disable-final \
%else
    --enable-final \
%endif
    \
%if %unstable
    --enable-debug=full \
%else
    --enable-debug=no \
%endif
%if "%beta" != "%nil"
    --enable-debug=yes \
%endif
    \
%ifarch x86_64
    --enable-libsuffix=64 \
%endif
    --disable-static \
    --enable-shared \
    --disable-embedded \
    --disable-palmtop \
    --with-xinerama \
    --with-gnu-ld \
    --enable-new-ldflags \
    --with-pic \
    --disable-rpath \
    --program-transform-name="" \
    --mandir=%_mandir \
    --enable-mysql \
    --enable-scripting \
    --without-arts

%make_build

%install
%if %unstable
%set_strip_method none
%endif

%K3install

mv %buildroot/%_iconsdir/crystalsvg %buildroot/%_kde3_iconsdir

%files
%files common

%files libs
%doc %_K3doc/en/koffice
%_K3bindir/krossrunner
%_Klibdir/clipartthumbnail.so*
%_Klibdir/kodocinfopropspage.so*
%_Klibdir/kofficescan.so*
%_Klibdir/kofficethumbnail.so*
%_Klibdir/krosspython.so*
%_Klibdir/libgenerickofilter.so*
%_Klibdir/libkounavailpart.so*
%_Klibdir/libthesaurustool.so*
%_Klibdir/libxsltexport.so*
%_Klibdir/libxsltimport.so*
%_Klibdir/libolefilter.so*
%_libdir/libkformulalib.so*
%_libdir/libkochart.so*
%_libdir/libkofficecore.so*
%_libdir/libkofficeui.so*
%_libdir/libkopainter.so*
%_libdir/libkopalette.so*
%_libdir/libkoproperty.so*
%_libdir/libkotext.so*
%_libdir/libkowmf.so*
%_libdir/libkrossapi.so*
%_libdir/libkrossmain.so*
%_libdir/libkstore.so*
%_libdir/libkwmf.so*
%_K3apps/koffice/
%_K3apps/kofficewidgets/
%_K3apps/kross/
%_K3apps/thesaurus/
%_K3apps/xsltfilter/
%_kde3_iconsdir/*/*/actions/abs.png
%_kde3_iconsdir/*/*/actions/brackets.png
%_kde3_iconsdir/*/*/actions/frac.png
%_kde3_iconsdir/*/*/actions/gsub.png
%_kde3_iconsdir/*/*/actions/gsup.png
%_kde3_iconsdir/*/*/actions/int.png
%_kde3_iconsdir/*/*/actions/lsub.png
%_kde3_iconsdir/*/*/actions/lsup.png
%_kde3_iconsdir/*/*/actions/matrix.png
%_kde3_iconsdir/*/*/actions/multiline.png
%_kde3_iconsdir/*/*/actions/onetwomatrix.png
%_kde3_iconsdir/*/*/actions/over.png
%_kde3_iconsdir/*/*/actions/paren.png
%_kde3_iconsdir/*/*/actions/prod.png
%_kde3_iconsdir/*/*/actions/rsub.png
%_kde3_iconsdir/*/*/actions/rsup.png
%_kde3_iconsdir/*/*/actions/sqrt.png
%_kde3_iconsdir/*/*/actions/sum.png
%_kde3_iconsdir/*/*/actions/under.png
%_kde3_iconsdir/*/*/actions/inscol.png
%_kde3_iconsdir/*/*/actions/insrow.png
%_kde3_iconsdir/*/*/actions/remcol.png
%_kde3_iconsdir/*/*/actions/remrow.png
%_K3services/clipartthumbnail.desktop
%_K3services/generic_filter.desktop
%_K3services/kodocinfopropspage.desktop
%_K3services/kofficethumbnail.desktop
%_K3services/kounavail.desktop
%_K3services/thesaurustool.desktop
%_K3services/xslt_export.desktop
%_K3services/xslt_import.desktop
%_K3services/ole_powerpoint97_import.desktop
%_K3srvtyp/kochart.desktop
%_K3srvtyp/kofficepart.desktop
%_K3srvtyp/kofilter.desktop
%_K3srvtyp/kofilterwrapper.desktop
%_K3srvtyp/koplugin.desktop
# ---------- kfile ------------
%_Klibdir/kfile_abiword.so*
%_Klibdir/kfile_gnumeric.so*
%_Klibdir/kfile_koffice.so*
%_Klibdir/kfile_ooo.so*
%_K3services/kfile_abiword.desktop
%_K3services/kfile_gnumeric.desktop
%_K3services/kfile_koffice.desktop
%_K3services/kfile_ooo.desktop
# ---------- koshell ------------
%doc %_K3doc/en/koshell
%_K3bindir/koshell
%_libdir/libkdeinit_koshell.so*
%_Klibdir/koshell.so*
%_K3cfg/koshell.kcfg
%_K3xdg_apps/koffice.desktop
%_K3xdg_apps/koshell.desktop
%_K3apps/koshell
%_kde3_iconsdir/*/*/apps/koshell.*
#
%doc %_K3doc/en/thesaurus
#%_Klibdir/kthesaurus.so*
#%_libdir/libkdeinit_kthesaurus.so*
#%_K3xdg_apps/KThesaurus.desktop
#%_K3bindir/koconverter
#%_K3bindir/kthesaurus
#%_Klibdir/krossruby.so*
#%_Klibdir/libolefilter.so*
%_libdir/libkchartimageexport.so*
%_libdir/libkchartcommon.so*
%_libdir/libkdchart.so*
%_libdir/libkspreadcommon.so*


%files kivio
%_Klibdir/libkivioimageexport.so*
%_K3services/kivio_image_export.desktop
%_K3datadir/apps/konqueror/servicemenus/kivio_konqi.desktop
%_K3cfg/kivio.kcfg
#
%doc %_K3doc/en/kivio
%_K3bindir/kivio
%_Klibdir/kivio.so*
%_Klibdir/libkivioconnectortool.so*
%_Klibdir/libkiviopart.so*
%_Klibdir/libkivioselecttool.so*
%_Klibdir/libkiviotargettool.so*
%_Klibdir/libkiviotexttool.so*
%_Klibdir/libkiviozoomtool.so*
%_Klibdir/straight_connector.so*
%_libdir/libkdeinit_kivio.so
%_libdir/libkiviocommon.so*
%_K3xdg_apps/kivio.desktop
%_K3apps/kivio/
%_kde3_iconsdir/*/*/apps/kivio.png
%_K3services/kivioconnectortool.desktop
%_K3services/kiviopart.desktop
%_K3services/kivioselecttool.desktop
%_K3services/kiviotargettool.desktop
%_K3services/kiviotexttool.desktop
%_K3services/kiviozoomtool.desktop

%files kexi
%_K3datadir/apps/konqueror/servicemenus/kexi_konqi.desktop
#
%doc %_K3doc/en/kexi
%_K3bindir/kexi
%_K3bindir/kexi_*
%_K3bindir/ksqlite*
%_Klibdir/kexidb_*.so*
%_Klibdir/kexihandler_*.so*
%_Klibdir/keximigrate_*.so*
%_Klibdir/kexi.so*
%_Klibdir/kformdesigner_*.so*
%_Klibdir/krosskexiapp.so*
%_Klibdir/krosskexidb.so*
%_libdir/libkdeinit_kexi.so*
%_libdir/libkexidbparser.so*
%_libdir/libkexidb.so*
%_libdir/libkexiutils.so*
%_libdir/libkexicore.so*
%_libdir/libkexidatatable.so*
%_libdir/libkexiextendedwidgets.so*
%_libdir/libkexiformutils.so*
%_libdir/libkexiguiutils.so*
%_libdir/libkeximain.so*
%_libdir/libkeximigrate.so*
%_libdir/libkexirelationsview.so*
%_libdir/libkexisql2.so*
%_libdir/libkexisql3.so*
%_libdir/libkformdesigner.so*
%_K3xdg_apps/kexi.desktop
%_K3datadir/apps/kexi/
%config %_K3datadir/config/kexirc
%config %_K3datadir/config/magic/kexi.magic
%_kde3_iconsdir/*/*/mimetypes/kexiproject_*.*
%_kde3_iconsdir/*/*/apps/kexi.*
%_K3mimelnk/application/x-kexiproject-*.desktop
%_K3mimelnk/application/x-kexi-connectiondata.desktop
%_K3services/kexidb_*.desktop
%_K3services/kexi/
%_K3services/keximigrate_*.desktop
%_K3services/kformdesigner/
%_K3srvtyp/kexidb_driver.desktop
%_K3srvtyp/kexihandler.desktop
%_K3srvtyp/keximigration_driver.desktop
%_K3srvtyp/widgetfactory.desktop

%files karbon
%_K3datadir/apps/konqueror/servicemenus/karbon_konqi.desktop
%_K3datadir/templates/Illustration.desktop
%_K3datadir/templates/.source/Illustration.karbon
#
%_Klibdir/libkarbon*import.so*
%_Klibdir/libkarbon*export.so*
%_Klibdir/liboodrawimport.so*
%_Klibdir/libwmfexport.so*
%_Klibdir/libwmfimport.so*
%_K3services/karbon_*_import.desktop
%_K3services/karbon_*_export.desktop
#
%doc %_K3doc/en/karbon
%_K3bindir/karbon
%_Klibdir/karbon_*.so*
%_Klibdir/karbon.so*
%_Klibdir/libkarbonpart.so*
%_libdir/libkarboncommon.so*
%_libdir/libkdeinit_karbon.so*
%_K3xdg_apps/karbon.desktop
%_K3apps/karbon/
%_kde3_iconsdir/*/*/apps/karbon.*
%_K3services/karbondefaulttools.desktop
%_K3services/karbonimagetool.desktop
%_K3services/karbonpart.desktop
%_K3services/karbonzoomtool.desktop
%_K3srvtyp/karbon_module.desktop

%files kchart
%doc %_K3doc/en/kchart
%_K3apps/konqueror/servicemenus/kchart_konqi.desktop
%_Klibdir/libkchart*export.so*
%_K3datadir/services/kchart_*_export.desktop
#
%_K3bindir/kchart
%_Klibdir/kchart.so*
%_Klibdir/libkchartpart.so*
%_libdir/libkdeinit_kchart.so*
%_K3xdg_apps/kchart.desktop
%_K3apps/kchart
%_kde3_iconsdir/*/*/apps/kchart.png
%_K3services/kchartpart.desktop

%files chalk
%_K3datadir/apps/konqueror/servicemenus/chalk_konqi.desktop
#
%_Klibdir/libchalk*export.so*
%_Klibdir/libchalk*import.so*
%_Klibdir/chalkselectopaque.so*
#%_K3applnk/.hidden/chalk_magick.desktop
%_K3applnk/.hidden/chalk_jpeg.desktop
%_K3applnk/.hidden/chalk_openexr.desktop
%_K3applnk/.hidden/chalk_png.desktop
%_K3applnk/.hidden/chalk_raw.desktop
%_K3applnk/.hidden/chalk_tiff.desktop
#%_K3applnk/.hidden/chalk_pdf.desktop
%_K3services/chalk_*_export.desktop
%_K3services/chalk_*_import.desktop
%_K3services/chalkselectopaque.desktop
#
%doc %_K3doc/en/chalk
%_K3bindir/chalk
%_Klibdir/chalkbumpmap.so*
%_Klibdir/chalkcimg.so*
%_Klibdir/chalkcmykplugin.so*
%_Klibdir/chalkcolorrange.so*
%_Klibdir/chalkcolorsfilters.so*
%_Klibdir/chalkcolorspaceconversion.so*
%_Klibdir/chalkconvolutionfilters.so*
%_Klibdir/chalkdefaultpaintops.so*
%_Klibdir/chalkdefaulttools.so*
%_Klibdir/chalkdropshadow.so*
%_Klibdir/chalkembossfilter.so*
%_Klibdir/chalkexample.so*
%_Klibdir/chalkfiltersgallery.so*
%_Klibdir/chalkgrayplugin.so*
%_Klibdir/chalkhistogramdocker.so*
%_Klibdir/chalkhistogram.so*
%_Klibdir/chalkimageenhancement.so*
%_Klibdir/chalkimagesize.so*
%_Klibdir/chalk_*_plugin.so*
%_Klibdir/chalkoilpaintfilter.so*
%_Klibdir/chalkpixelizefilter.so*
%_Klibdir/chalkraindropsfilter.so*
%_Klibdir/chalkrgbplugin.so*
%_Klibdir/chalkrotateimage.so*
%_Klibdir/chalkroundcornersfilter.so*
%_Klibdir/chalkscreenshot.so*
%_Klibdir/chalkscripting.so*
%_Klibdir/chalkselectiontools.so*
%_Klibdir/chalkseparatechannels.so*
%_Klibdir/chalkshearimage.so*
%_Klibdir/chalksmalltilesfilter.so*
#%_Klibdir/chalksmearybrush.so*
%_Klibdir/chalk.so*
%_Klibdir/chalksobelfilter.so*
%_Klibdir/chalktoolcrop.so*
%_Klibdir/chalktoolfilter.so*
%_Klibdir/chalktoolpolygon.so*
%_Klibdir/chalktoolpolyline.so*
%_Klibdir/chalktoolselectsimilar.so*
%_Klibdir/chalktoolstar.so*
%_Klibdir/chalktooltransform.so*
%_Klibdir/chalkwetplugin.so*
%_Klibdir/krosschalkcore.so*
%_Klibdir/libchalkpart.so*
%_Klibdir/chalkcolorify.so*
%_Klibdir/chalklevelfilter.so*
%_Klibdir/chalkblurfilter.so*
%_Klibdir/chalkextensioncolorsfilters.so*
%_Klibdir/chalkfastcolortransfer.so*
%_Klibdir/chalklenscorrectionfilter.so*
%_Klibdir/chalkmodifyselection.so*
%_Klibdir/chalknoisefilter.so*
%_Klibdir/chalkrandompickfilter.so*
%_Klibdir/chalksubstrate.so*
%_Klibdir/chalktoolcurves.so*
%_Klibdir/chalktoolperspectivegrid.so*
%_Klibdir/chalktoolperspectivetransform.so*
%_Klibdir/chalkunsharpfilter.so*
%_Klibdir/chalkwavefilter.so*
%_libdir/libkdeinit_chalk.so*
%_libdir/libchalkcolor.so*
%_libdir/libchalkcommon.so*
%_libdir/libchalkgrayscale.so*
%_libdir/libchalk_*.so*
%_libdir/libchalkimage.so*
%_libdir/libchalkrgb.so*
%_libdir/libchalkscripting.so*
%_libdir/libchalkui.so*
%_K3xdg_apps/chalk.desktop
%_K3apps/chalk/
%_K3apps/chalkplugins/
%_kde3_iconsdir/*/*/apps/chalk.*
%_K3services/chalkbumpmapfilter.desktop
%_K3services/chalkcimg.desktop
%_K3services/chalkcmykplugin.desktop
%_K3services/chalk_*_plugin.desktop
%_K3services/chalkcolorrange.desktop
%_K3services/chalkcolorsfilter.desktop
%_K3services/chalkcolorifyfilter.desktop
%_K3services/chalkcolorspaceconversion.desktop
%_K3services/chalkconvolutionfilters.desktop
%_K3services/chalkdefaultpaintops.desktop
%_K3services/chalkdefaulttools.desktop
%_K3services/chalkdropshadow.desktop
%_K3services/chalkembossfilter.desktop
%_K3services/chalkexample.desktop
%_K3services/chalkfiltersgallery.desktop
%_K3services/chalkgrayplugin.desktop
%_K3services/chalkhistogram.desktop
%_K3services/chalkhistogramdocker.desktop
%_K3services/chalkimageenhancement.desktop
%_K3services/chalkimagesize.desktop
%_K3services/chalkoilpaintfilter.desktop
%_K3services/chalklevelfilter.desktop
%_K3services/chalkpart.desktop
#%_Klibdir/chalkperftest.so*
#%_K3services/chalkperftest.desktop
%_K3services/chalkpixelizefilter.desktop
%_K3services/chalkraindropsfilter.desktop
%_K3services/chalkrgbplugin.desktop
%_K3services/chalkrotateimage.desktop
%_K3services/chalkroundcornersfilter.desktop
%_K3services/chalkscreenshot.desktop
%_K3services/chalkscripting.desktop
%_K3services/chalkselectiontools.desktop
%_K3services/chalkseparatechannels.desktop
%_K3services/chalkshearimage.desktop
%_K3services/chalksmalltilesfilter.desktop
#%_K3services/chalksmearybrush.desktop
%_K3services/chalksobelfilter.desktop
%_K3services/chalktoolcrop.desktop
%_K3services/chalktoolfilter.desktop
%_K3services/chalktoolpolygon.desktop
%_K3services/chalktoolpolyline.desktop
%_K3services/chalktoolselectsimilar.desktop
%_K3services/chalktoolstar.desktop
%_K3services/chalktooltransform.desktop
%_K3services/chalkwetplugin.desktop
%_K3services/chalkblurfilter.desktop
%_K3services/chalkextensioncolorsfilters.desktop
%_K3services/chalkfastcolortransfer.desktop
%_K3services/chalklenscorrectionfilter.desktop
%_K3services/chalkmodifyselection.desktop
%_K3services/chalknoisefilter.desktop
%_K3services/chalkrandompickfilter.desktop
%_K3services/chalksubstrate.desktop
%_K3services/chalktoolcurves.desktop
%_K3services/chalktoolperspectivegrid.desktop
%_K3services/chalktoolperspectivetransform.desktop
%_K3services/chalkunsharpfilter.desktop
%_K3services/chalkwavefilter.desktop
%_K3srvtyp/chalk_*.desktop


####%if 0
%files kformula
%_K3datadir/apps/konqueror/servicemenus/kformula_konqi.desktop
%_Klibdir/libkfolatexexport.so*
%_Klibdir/libkfomathmlexport.so*
%_Klibdir/libkfomathmlimport.so*
%_Klibdir/libkfopngexport.so*
%_Klibdir/libkfosvgexport.so*
%_K3datadir/services/kformula_*_import.desktop
%_K3datadir/services/kformula_*_export.desktop
#
%doc %_K3doc/en/kformula
%_K3bindir/kformula
%_Klibdir/kformula.so*
%_Klibdir/libkformulapart.so*
%_libdir/libkdeinit_kformula.so*
%_K3xdg_apps/kformula.desktop
%_K3apps/kformula/
%_kde3_iconsdir/*/*/apps/kformula.png
%_K3services/kformulapart.desktop



%files kpresenter
%_K3datadir/apps/konqueror/servicemenus/kpresenter_konqi.desktop
%_K3datadir/templates/.source/Presentation.kpt
%_K3datadir/templates/Presentation.desktop
#
%_Klibdir/libkpresenterbmpexport.so*
%_Klibdir/libkpresenterjpegexport.so*
%_Klibdir/libkpresentermngexport.so*
%_Klibdir/libkpresenterpngexport.so*
%_Klibdir/libkpresentersvgexport.so*
%_Klibdir/libkpresenterxbmexport.so*
%_Klibdir/libkpresenterxpmexport.so*
%_Klibdir/libkprkword.so*
%_Klibdir/libooimpressexport.so*
%_Klibdir/libooimpressimport.so*
#%_Klibdir/libpowerpointimport.so*
%_libdir/libkpresenterimageexport.so*
%_K3services/kpresenter_*_export.desktop
%_K3services/kpresenter_*_import.desktop
%_K3services/kprkword.desktop
#
%doc %_K3doc/en/kpresenter
%_K3bindir/kpresenter
%_K3bindir/kprconverter.pl
%_Klibdir/kpresenter.so*
%_Klibdir/libkpresenterpart.so*
%_libdir/libkdeinit_kpresenter.so*
%_libdir/libkpresenterprivate.so*
%_K3apps/kpresenter/
%_K3xdg_apps/kpresenter.desktop
%_kde3_iconsdir/*/*/apps/kpresenter.png
%_K3services/kpresenterpart.desktop


%files kspread
%_K3apps/konqueror/servicemenus/kspread_konqi.desktop
%_K3datadir/templates/SpreadSheet.desktop
%_K3datadir/templates/.source/SpreadSheet.kst
#
%_K3datadir/services/kspread_*_import.desktop
%_K3datadir/services/kspread_*_export.desktop
%_Klibdir/libcsvexport.so*
%_Klibdir/libcsvimport.so*
%_Klibdir/libapplixspreadimport.so
%_Klibdir/libdbaseimport.so
%_Klibdir/libexcelimport.so*
%_Klibdir/libgnumericexport.so*
%_Klibdir/libgnumericimport.so*
%_Klibdir/libkspread*export.so*
%_Klibdir/libopencalcexport.so*
%_Klibdir/libopencalcimport.so*
%_Klibdir/libqproimport.so*
%_Klibdir/krosskspreadcore.so*
%_Klibdir/kspreadscripting.so*
%_Klibdir/libkspreadkexiimport.so*
#
%doc %_K3doc/en/kspread
%_K3bindir/kspread
%_libdir/libkdeinit_kspread.so*
%_Klibdir/libkspreadinsertcalendar.so*
%_Klibdir/libkspreadpart.so*
%_Klibdir/kspread.so*
%_K3xdg_apps/kspread.desktop
%_K3datadir/apps/kspread/
%_kde3_iconsdir/*/*/apps/kspread.png
%_K3services/kspreadpart.desktop
%_K3services/kspreadscripting.desktop


%files kugar
%_Klibdir/libkugarnopimport.so*
%_K3services/kugar_kugar_import.desktop
#
%doc %_K3doc/en/kugar
%_K3bindir/kugar
%_K3bindir/kudesigner
%_Klibdir/kugar.so*
%_Klibdir/kudesigner.so*
%_Klibdir/libkudesignerpart.so*
%_Klibdir/libkugarpart.so*
%_libdir/libkdeinit_kugar.so*
%_libdir/libkdeinit_kudesigner.so*
%_libdir/libkudesignercore.so*
%_libdir/libkugarlib.so*
%_K3xdg_apps/kugar.desktop
%_K3xdg_apps/kudesigner.desktop
%_K3apps/kudesigner/
%_K3apps/kugar
%_kde3_iconsdir/*/*/apps/kugar.png
%_kde3_iconsdir/*/*/apps/kudesigner.png
%_kde3_iconsdir/*/*/mimetypes/kugardata.png
%_K3services/kugarpart.desktop


%files kword
%_K3apps/konqueror/servicemenus/kword_*.desktop
%_K3datadir/templates/.source/TextDocument.kwt
%_K3datadir/templates/TextDocument.desktop
#
%_libdir/libkwordexportfilters.so*
%_Klibdir/libabiwordexport.so*
%_Klibdir/libabiwordimport.so*
%_Klibdir/libamiproexport.so*
%_Klibdir/libamiproimport.so*
%_Klibdir/libapplixwordimport.so*
%_Klibdir/libasciiexport.so*
%_Klibdir/libasciiimport.so*
%_Klibdir/libdocbookexport.so*
%_Klibdir/libhancomwordimport.so*
%_Klibdir/libhtmlexport.so*
%_Klibdir/libhtmlimport.so*
%_Klibdir/libkwordkword1dot3import.so*
%_Klibdir/libkwordlatexexport.so*
#_Klibdir/libmswordimport.so*
%_Klibdir/libmswriteexport.so*
%_Klibdir/libmswriteimport.so*
%_Klibdir/liboowriterexport.so*
%_Klibdir/liboowriterimport.so*
%_Klibdir/libpalmdocexport.so*
%_Klibdir/libpalmdocimport.so*
%_Klibdir/libpdfimport.so*
%_Klibdir/librtfexport.so*
%_Klibdir/librtfimport.so*
%_Klibdir/libwmlexport.so*
%_Klibdir/libwmlimport.so*
%_Klibdir/libwpexport.so*
%_Klibdir/libwpimport.so*
%_K3services/kword_*_export.desktop
%_K3services/kword_*_import.desktop
#
%doc %_K3doc/en/kword
%_K3bindir/kword
%_Klibdir/kwmailmerge_*.so*
%_Klibdir/kword.so*
%_Klibdir/libkwordpart.so*
%_libdir/libkdeinit_kword.so*
%_libdir/libkwmailmerge_interface.so*
%_libdir/libkwordprivate.so*
%_K3apps/kword/
%_kde3_iconsdir/*/*/apps/kword.png
%_K3xdg_apps/kword.desktop
%_K3services/kwmailmerge_*.desktop
%_K3services/kwordpart.desktop
%_K3services/kwserialletter_*
%_K3srvtyp/kwmailmerge.desktop


%files kplato
%doc %_K3doc/en/kplato
%_K3bindir/kplato
%_libdir/libkdeinit_kplato.so*
%_Klibdir/kplato.so*
%_Klibdir/libkplatopart.so*
%_K3apps/kplato/
%_K3services/kplatopart.desktop
%_kde3_iconsdir/*/*/apps/kplato.*
%_K3xdg_apps/kplato.desktop

%files devel
%doc %_K3doc/en/koffice-apidocs/
%_includedir/*
%if %_keep_libtool_files
%_libdir/*.la
%_Klibdir/*.la
%endif

###%endif

%changelog
