Name: kqemu
Version: 1.4.0
Release: alt0.1.pre1
%define upstream_version	1.4.0pre1

Summary: QEMU x86 virtualization module
License: GPL
Group: Emulators
URL: http://fabrice.bellard.free.fr/qemu/kqemu-doc.html
Packager: Sergey Vlasov <vsu@altlinux.ru>
BuildArch: noarch

Source0: %name-%upstream_version.tar

Source1: %name-extra-%version-%release.tar

BuildPreReq: kernel-build-tools

%package common
Summary: QEMU x86 virtualization module - support files and documentation
Group: System/Configuration/Other
# due to new_summary function and is_builtin_mode bugfix
PreReq: control >= 0.7.2-alt1
PreReq: shadow-utils
# due to /bin/mountpoint (SysVinit >= 2.86-alt1)
PreReq: sysvinit-utils

%package -n kernel-source-%name
Summary: QEMU x86 virtualization module - sources
Group: Development/Kernel

%description
QEMU Accelerator (KQEMU) is a driver allowing the QEMU PC emulator to
run much faster when emulating a PC on an x86 host.

%description common
QEMU Accelerator (KQEMU) is a driver allowing the QEMU PC emulator to
run much faster when emulating a PC on an x86 host.

This package contains scripts and other support files which are
required to use the kqemu kernel module in the ALT Linux system.
The kernel module itself is not included - you need to install the
appropriate kernel-modules-kqemu-* package for your kernel.

This package also contains documentation for the kqemu kernel module.

%description -n kernel-source-%name
QEMU Accelerator (KQEMU) is a driver allowing the QEMU PC emulator to
run much faster when emulating a PC on an x86 host.

This package contains sources for building the kqemu kernel module.

%prep
%setup -c -q -a 1
mv %name-%upstream_version kernel-source-%name-%version
cd kernel-source-%name-%version
cd ..

%install
mkdir -p %kernel_srcdir
tar --owner=root --group=root --mode=u+w,go-w,go+rX -cjf \
	%kernel_srcdir/kernel-source-%name-%version.tar.bz2 \
	kernel-source-%name-%version

install -Dp %name-extra/%name.control %buildroot%_controldir/%name
install -Dp %name-extra/%name.init %buildroot%_initdir/%name
install -Dp -m644 %name-extra/%name.rules \
	%buildroot%_sysconfdir/udev/rules.d/90-%name.rules

%pre common
/usr/sbin/groupadd -r -f kqemu
%pre_control %name

%post common
%post_control -s kqemu %name
%post_service %name

%preun common
%preun_service %name

%triggerin common -- dev
# If using static /dev, select the same status again to fix permissions
mountpoint -q /dev || {
	status="`/usr/sbin/control %name status`" || status=
	[ -n "$status" ] && /usr/sbin/control %name "$status" ||:
}

%files common
%_controldir/%name
%_initdir/%name
%config %_sysconfdir/udev/rules.d/90-%name.rules
%doc %name-extra/README.ALT
%doc kernel-source-%name-%version/LICENSE
%doc kernel-source-%name-%version/Changelog
%doc kernel-source-%name-%version/*.html

%files -n kernel-source-%name
%_usrsrc/*

%changelog
