
Name: krb5
Version: 1.13.7
Release: alt0.M70P.1

%define _docdir %_defaultdocdir/%name-%version

Summary: The Kerberos network authentication system
License: MIT
Group: System/Libraries
Url: http://web.mit.edu/kerberos/www/

Source0: %name-%version.tar
Source2: %name-alt.tar

Patch1: krb5-1.10.1-alt-export-krb5int_get_fq_local_hostname.patch

# fedora patches:
Patch6: krb5-1.12-fedora-ksu-path.patch
Patch12: krb5-1.12-fedora-ktany.patch
Patch23: krb5-1.3.1-fedora-dns.patch
Patch39: krb5-1.12-fedora-api.patch
Patch60: krb5-1.12.1-fedora-pam.patch
Patch63: krb5-1.13-fedora-selinux-label.patch
Patch71: krb5-1.13-fedora-dirsrv-accountlock.patch
Patch86: krb5-1.9-fedora-debuginfo.patch
Patch105: krb5-fedora-kvno-230379.patch
Patch129: krb5-1.11-fedora-run_user_0.patch
Patch134: krb5-1.11-fedora-kpasswdtest.patch

# alt patches:
Patch200: krb5-1.14.4-alt-default_keytab_group.patch

BuildRequires: /dev/pts /proc
BuildRequires: flex libcom_err-devel libkeyutils-devel
BuildRequires: libldap-devel libsasl2-devel
BuildRequires: libncurses-devel libss-devel libssl-devel libtinfo-devel
BuildRequires: libverto-devel libselinux-devel
BuildRequires: libpam-devel

BuildRequires: python-module-sphinx
BuildRequires: texlive-latex-base texlive-base-bin texlive-latex-recommended

%ifarch %{ix86} x86_64
BuildRequires: yasm
%endif

# for tests
BuildRequires: libverto-libev python-modules gcc-c++
# dejagnu tests disabled
# BuildRequires: dejagnu tcl-devel

%description
Kerberos V5 is a trusted-third-party network authentication system,
which can improve your network's security by eliminating the insecure
practice of cleartext passwords.

# {{{ subpackages

%package -n lib%name
Summary: The shared libraries used by Kerberos 5
Group: System/Libraries
Requires: gawk

%package -n lib%name-ldap
Summary: The shared Kerberos 5 libraries, LDAP support
Group: System/Libraries
Requires: lib%name = %version-%release

%package -n lib%name-devel
Summary: Development files needed to compile Kerberos 5 programs
Group: System/Libraries
Requires: lib%name = %version-%release
Requires: lib%name-ldap = %version-%release
Requires: libcom_err-devel
Provides: %name-services = %version-%release
Provides: %name-clients = %version-%release
Obsoletes: %name-services < %version-%release
Obsoletes: %name-clients < %version-%release

%package kdc
Group: System/Servers
Summary: The Kerberos 5 Key Distribution Center
Requires: %name-kadmin = %version-%release
Requires: lib%name = %version-%release
Requires: lib%name-ldap = %version-%release
Requires: libverto-libev
Provides: %name-server = %version-%release
Obsoletes: %name-server < %version-%release

%package kadmin
Group: System/Servers
Summary: The KDC admin programs for Kerberos 5
Requires: %name-kinit = %version-%release
Requires: lib%name = %version-%release

%package kinit
Summary: Kerberos 5 programs for use on workstations
Group: System/Base
Requires: lib%name = %version-%release
Provides: %name-workstation = %version-%release
Obsoletes: %name-workstation < %version-%release


%package doc
Group: Books/Computer books
Summary: Kerberos 5 documentation
BuildArch: noarch

%description -n lib%name
Kerberos is a network authentication system.  This package contains
the shared libraries needed by Kerberos 5.  If you are using Kerberos,
you need to install this package.

%description -n lib%name-ldap
Kerberos is a network authentication system.  This package contains
the shared Kerberos 5 libraries needed for LDAP backend support.

%description -n lib%name-devel
Kerberos is a network authentication system.  This package contains the
header files and libraries needed for compiling Kerberos 5 programs.
If you want to develop Kerberos-aware programs, you need to install
this package.

%description kdc
Kerberos is a network authentication system.
This package contains the programs that must be installed
on a Kerberos 5 Key Distribution Center.

%description kadmin
Kerberos is a network authentication system.
This package contains set of programs helping to manage
a Kerberos 5 Key Distribution Center.

%description kinit
Kerberos is a network authentication system.
This package contains the basic Kerberos programs.
If your network uses Kerberos, this package should be installed
on every workstation.

%description doc
Kerberos is a network authentication system.
This packages contains documentation bundled with
MIT Kerberos.

# }}}

%prep
%setup

%patch1 -p2

# fedora patches:
%patch60 -p1 -b .pam
%patch63 -p1 -b .selinux-label
%patch6  -p1 -b .ksu-path
%patch12 -p1 -b .ktany
%patch23 -p1 -b .dns
%patch39 -p1 -b .api
%patch71 -p1 -b .dirsrv-accountlock
%patch86 -p0 -b .debuginfo
%patch105 -p1 -b .kvno
# Apply when the hard-wired or configured default location is
# DIR:/run/user/%%{uid}/krb5cc.
%patch129 -p1 -b .run_user_0
%patch134 -p1 -b .kpasswdtest

%patch200 -p2 -b .default_keytab_group

%build
# Go ahead and supply tcl info, because configure doesn't know how to find it.
# . %_libdir/tclConfig.sh

DEFINES="-D_FILE_OFFSET_BITS=64" ; export DEFINES
%add_optflags -I/usr/include/et
%add_optflags -DKRB5_DNS_LOOKUP

# Set this so that configure will have a value even if the current version of
# autoconf doesn't set one.
runstatedir=%_runtimedir; export runstatedir

pushd src
util/reconf --verbose --force
%configure \
	--enable-shared --disable-static \
	--localstatedir=%_localstatedir/kerberos \
	--with-system-et \
	--with-system-ss \
	--with-ldap \
	--enable-dns-for-realm \
	--with-dirsrv-account-locking \
	--enable-pkinit \
	--with-pkinit-crypto-impl=openssl \
	--with-tls-impl=openssl \
	--with-pam \
	--with-netlib=-lresolv \
	--disable-rpath \
	--with-selinux
	#

# dejagnu tests disabled
# 	--with-tcl=%_libdir \
%make
popd

# Sanity check the KDC_RUN_DIR.
configured_kdcrundir=`grep KDC_RUN_DIR src/include/osconf.h | awk '{print $NF}'`
configured_kdcrundir=`eval echo $configured_kdcrundir`
if test "$configured_kdcrundir" != %_runtimedir/krb5kdc ; then
    exit 1
fi

# Build the docs.
make -C src/doc paths.py version.py
cp src/doc/paths.py doc/
mkdir -p build-man build-html build-pdf
sphinx-build -a -b man   -t pathsubs doc build-man
sphinx-build -a -b html  -t pathsubs doc build-html
rm -fr build-html/_sources
sphinx-build -a -b latex -t pathsubs doc build-pdf
# Build the PDFs if we didn't have pre-built ones.
for pdf in admin appdev basic build plugindev user ; do
    test -s build-pdf/$pdf.pdf || make -C build-pdf
done

%check
make -C src runenv.py
# NOTE(iv@): this test hangs for too long, look at this later
echo > src/tests/t_iprop.py

# skip this test, because getaddrinfo with flag AI_ADDRCONFIG return error in hasher
echo > src/tests/t_kprop.py
make -C src check TMPDIR=%_tmppath OFFLINE=yes PYTESTFLAGS="-v"

%install

make -C src install \
    DESTDIR=%buildroot \
    INSTALL_SETUID='install -m0755' \
    EXAMPLEDIR=%_docdir/examples

# Server init scripts, sample client config file and sample KDC config files.
tar xf %SOURCE2 -C %buildroot

# Fix preporcessor loop
# sed -i 's,<krb5/krb5.h>,<krb5/krb5/krb5.h>,' %buildroot%_includedir/krb5/krb5.h

# Relocate *some* shared libraries
mkdir -p %buildroot/%_lib
for lib in libgssapi_krb5 libk5crypto libkrb5 libkrb5support; do
  mv %buildroot%_libdir/${lib}.so.* %buildroot/%_lib
  ln -snf ../../%_lib/`readlink %buildroot%_libdir/${lib}.so` %buildroot%_libdir/${lib}.so
done

# Fix binaries clashes
mv -f %buildroot%_bindir/uuclient %buildroot%_bindir/%name-uuclient
mv -f %buildroot%_sbindir/uuserver %buildroot%_sbindir/%name-uuserver

# Where per-user keytabs live by default.
mkdir -p %buildroot%_localstatedir/kerberos/krb5/user

# Parent of configuration file for list of loadable GSS mechs ("mechs").  This
# location is not relative to sysconfdir, but is hard-coded in g_initialize.c.
mkdir -m 755 -p %buildroot%_sysconfdir/gss
# Parent of groups of configuration files for a list of loadable GSS mechs
# ("mechs").  This location is not relative to sysconfdir, and is also
# hard-coded in g_initialize.c.
mkdir -m 755 -p %buildroot%_sysconfdir/gss/mech.d

# Install docs
mkdir -p %buildroot%_docdir/pdf
cp build-pdf/*.pdf %buildroot%_docdir/pdf/
cp -R build-html/ %buildroot/%_docdir/
cp -p src/plugins/kdb/ldap/libkdb_ldap/kerberos.{ldif,schema} %buildroot%_docdir/

# cleanups
rm -rf %buildroot%_datadir/gnats
rm -rf %buildroot%_mandir/cat*
touch %buildroot%_sysconfdir/krb5.keytab

%find_lang mit-krb5

%post kdc
%post_service krb5kdc
%post_service kadmin
%post_service kprop

%preun kdc
%preun_service krb5kdc
%preun_service kadmin
%preun_service kprop

%pre -n lib%name
/usr/sbin/groupadd -r -f _keytab

%triggerpostun -n lib%name -- lib%name < 1.14.4-alt2
if [ -f %_sysconfdir/krb5.keytab ]; then
    chown :_keytab %_sysconfdir/krb5.keytab
    chmod g+r %_sysconfdir/krb5.keytab
fi

%files -n lib%name -f mit-krb5.lang
%config(noreplace) %_sysconfdir/krb5.conf
%ghost %config(noreplace) %attr(640,root,_keytab) %_sysconfdir/krb5.keytab
%dir /etc/gss
%dir /etc/gss/mech.d
%dir %_localstatedir/kerberos
%dir %_localstatedir/kerberos/krb5
%dir %_localstatedir/kerberos/krb5/user

/%_lib/lib*.so.*

%_libdir/libgssrpc.so.*
%_libdir/libkadm5clnt_mit.so.*
%_libdir/libkadm5srv_mit.so.*
%_libdir/libkdb5.so.*
%_libdir/libkrad.so.*

%dir %_libdir/%name
%dir %_libdir/%name/plugins
%dir %_libdir/%name/plugins/kdb
%dir %_libdir/%name/plugins/preauth
%dir %_libdir/%name/plugins/tls
%_libdir/%name/plugins/kdb/db2.so
%_libdir/%name/plugins/preauth/pkinit.so
%_libdir/%name/plugins/preauth/otp.so
%_libdir/%name/plugins/tls/k5tls.so

%_man5dir/krb5.conf.5*

%files -n lib%name-ldap
%_libdir/libkdb_ldap.so.*
%_libdir/%name/plugins/kdb/kldap.so

%files -n lib%name-devel
%_includedir/*
%_libdir/lib*.so
%_bindir/gss-client
%_bindir/sclient
%_bindir/krb5-config
%_bindir/sim_client
%_bindir/%name-uuclient
%_sbindir/%name-uuserver
%_sbindir/gss-server
%exclude %_sbindir/krb5-send-pr
%_sbindir/sim_server
%_sbindir/sserver
%_man1dir/sclient.1*
%_man1dir/krb5-config.1*
%_man8dir/sserver.8*
%_pkgconfigdir/*

%files kdc
%dir %_localstatedir/kerberos/krb5kdc
%config(noreplace) %_localstatedir/kerberos/krb5kdc/kdc.conf
%config(noreplace) %_localstatedir/kerberos/krb5kdc/kadm5.acl

%config(noreplace) %_sysconfdir/sysconfig/kadmin
%config(noreplace) %_sysconfdir/sysconfig/krb5kdc

%_initdir/kadmin
%_initdir/krb5kdc
%_initdir/kprop

%systemd_unitdir/kadmin.service
%systemd_unitdir/kprop.service
%systemd_unitdir/krb5kdc.service

%_sbindir/kadmin.local
%_sbindir/kadmind
%_sbindir/kdb5_util
%_sbindir/kdb5_ldap_util
%_sbindir/kprop
%_sbindir/kproplog
%_sbindir/kpropd
%_sbindir/krb5kdc

%_man5dir/kadm5.acl.5*
%_man5dir/kdc.conf.5*
%_man8dir/kadmin.local.8*
%_man8dir/kadmind.8*
%_man8dir/kdb5_util.8*
%_man8dir/kdb5_ldap_util.8*
%_man8dir/kprop.8*
%_man8dir/kproplog.8*
%_man8dir/kpropd.8*
%_man8dir/krb5kdc.8*

%files kadmin
%_bindir/kadmin
%_bindir/ktutil
%_man1dir/kadmin.1*
%_man1dir/ktutil.1*

%_bindir/k5srvutil
%_man1dir/k5srvutil.1*

%files kinit
%_bindir/kdestroy
%_bindir/kinit
%_bindir/klist
%_bindir/kpasswd
%_bindir/ksu
%_bindir/kvno
%_bindir/kswitch
%config(noreplace) %_sysconfdir/pam.d/ksu

%_man1dir/kdestroy.1*
# %%_man1dir/kerberos.1*
%_man1dir/kinit.1*
%_man1dir/klist.1*
%_man1dir/kpasswd.1*
%_man1dir/ksu.1*
%_man1dir/kvno.1*
%_man1dir/kswitch.1*
%_man5dir/.k5login.5*
%_man5dir/k5login.5*
%_man5dir/.k5identity.5*
%_man5dir/k5identity.5*

%files doc
%doc %_docdir

# {{{ changelog

%changelog
