Name: lablGL
Version: 1.04
Release: alt1
Packager: Veaceslav Grecea <slavutich@altlinux.org>

Summary: OpenGL library for OCaml
License: BSD-style
Group: Development/ML
Url: http://wwwfun.kurims.kyoto-u.ac.jp/soft/olabl/lablgl.html

Source: http://wwwfun.kurims.kyoto-u.ac.jp/soft/olabl/dist/lablgl-%version.tar.gz
Patch1: lablgl-1.03-alt-togl.patch

Requires: %name-runtime = %version-%release

# Automatically added by buildreq on Thu Jul 07 2011
# optimized out: fontconfig labltk-runtime libGL-devel libGLU-devel libX11-devel ocaml ocaml-runtime tcl-devel tcl-togl tk-devel xorg-xproto-devel
BuildRequires: camlp4 labltk libXext-devel libXmu-devel libfreeglut-devel tcl-togl-devel
BuildRequires: libXxf86vm-devel

%package runtime
Summary: runtime part of LablGL library
Group: Development/ML

%description
LablGL is an OpenGL interface for Objective Caml.  It includes two
interfaces: the Togl widget, for comfortable use with LablTk, and
LablGlut for standalone applications not using Tcl/Tk.

%description runtime
LablGL is an OpenGL interface for Objective Caml.  It includes two
interfaces: the Togl widget, for comfortable use with LablTk, and
LablGlut for standalone applications not using Tcl/Tk.

%prep
%setup -n lablgl-%version
rm -r Togl/src/Togl/
%patch1 -p1
cat > Makefile.config <<EOF
CAMLC = ocamlc.opt
CAMLOPT = ocamlopt.opt
BINDIR = %{_bindir}
XINCLUDES =
XLIBS = -lXext -lXmu -lX11
TKINCLUDES = -I%{_includedir}
GLINCLUDES =
GLLIBS = -lGL -lGLU
GLUTLIBS = -lglut -lXxf86vm
RANLIB = :
LIBDIR = %{_libdir}/ocaml
DLLDIR = %{_libdir}/ocaml/stublibs
INSTALLDIR = %{_libdir}/ocaml/site-lib/lablGL
TOGLDIR=Togl
COPTS = $RPM_OPT_FLAGS
EOF

%build
make all opt INSTALLDIR=%_libdir/ocaml/site-lib/lablGL \
	TCLLIBDIR=%_tcllibdir TOGLVERSION=%{get_version tcl-togl}

%install
mkdir -p %buildroot%_libdir/ocaml/stublibs
mkdir -p %buildroot%_bindir
%make_install install \
	INSTALLDIR=%buildroot%_libdir/ocaml/site-lib/lablGL \
	DLLDIR=%buildroot%_libdir/ocaml/stublibs \
	BINDIR=%buildroot%_bindir

# Make and install a META file.
cat <<EOM >META
version="%{version}"
directory="+lablgl"
archive(byte) = "lablgl.cma"
archive(native) = "lablgl.cmxa"

package "togl" (
  requires = "labltk lablgl"
  archive(byte) = "togl.cma"
  archive(native) = "togl.cmxa"
)

package "glut" (
  requires = "lablgl"
  archive(byte) = "lablglut.cma"
  archive(native) = "lablglut.cmxa"
)
EOM
install -p -m644 META %buildroot%_libdir/ocaml/site-lib/lablGL/META

%files
%doc CHANGES COPYRIGHT README Togl/examples/ LablGlut/examples/
%dir %_libdir/ocaml/site-lib/lablGL
%_libdir/ocaml/site-lib/lablGL/META
%_libdir/ocaml/site-lib/lablGL/*.mli
%_libdir/ocaml/site-lib/lablGL/*.cmi
%_libdir/ocaml/site-lib/lablGL/*.cma
%_libdir/ocaml/site-lib/lablGL/*.cmxa
%_libdir/ocaml/site-lib/lablGL/*.a
%exclude %_libdir/ocaml/site-lib/lablGL/*.ml
%exclude %_libdir/ocaml/site-lib/lablGL/*.cmx
%_bindir/lablgl*

%files runtime
%_libdir/ocaml/stublibs/dll*.so

%changelog
