%define cfg %_builddir/%name-%version/
%define rev 51665

Name:       lazarus
Version:    1.6.2
Release:    alt0.M70P.1
Epoch:      1

Summary:    Lazarus Component Library and IDE
License:    GPL and modified LGPL
Group:      Development/Other
Url:        http://www.lazarus-ide.org/

Packager:   Andrey Cherepanov <cas@altlinux.org>

Source:     %name-%version.tar
Source2:    extra.tar
Source3:    environmentoptions.xml
Source4:    projectoptions.xml

Patch0:     %name-0.9.22-alt-relax-onwine.patch
Patch2:     %name-fix-desktop-file.patch
Patch3:     %name-fix-install-path-in-Makefile.patch
Patch4:     %name-1.0.8-fix-fpc-search.patch
Patch6:	    %name-set-user-TestBuildDirectory.patch

# Patches from Debian
Patch11: lazarus-default-config.patch
Patch12: lazarus-lcl-with-multple-widget-sets.patch

BuildRequires: fpc >= 2.6.4 fpc-utils glibc-devel libgtk+2-devel libXi-devel desktop-file-utils 
BuildRequires: libXext-devel libXtst-devel libGL-devel libGLU-devel libode-devel

Requires:   fpc >= 2.6.4 fpc-src fpc-utils gdb libGL-devel libXi-devel libXext-devel libgtk+2-devel
Requires:   glibc-devel glib-devel libGLU-devel libode-devel
Requires:   fonts-bitmap-terminus
Requires:   libdbus-devel
Requires:   xterm

Provides:   %name-docs = %version
Obsoletes:  %name-docs < %version
Provides:   %name-examples = %version
Obsoletes:  %name-examples < %version

%add_findreq_skiplist %_libdir/%name/examples/* %_libdir/%name/components/*

%description
Lazarus is a free and open source Rapid Application Development tool
for the FreePascal compiler using the Lazarus component library - LCL.
The LCL is included in this package.

%description -l ru_RU.UTF8
Lazarus - свободно-распространяемая, с открытым исходным кодом,
среда для быстрой разработки прикладных программ (Rapid Application
Development tool) на FreePascal, использующая библиотеки компонет LCL
(Lazarus component library).  LCL входят в состав данного пакета.

%prep
%setup
%patch0 -p1

tar xf %SOURCE2
%patch2 -p2
%patch3 -p2
subst 's|/usr/lib/|%{_libdir}/|' %PATCH4
%patch4 -p2
%patch6 -p2
%patch11 -p1
%patch12 -p1

install -D -p -m 0644 %SOURCE3 tools/install/linux/environmentoptions.xml
#sed -i -e 's,@version@,%version,g' tools/install/linux/helpoptions.xml docs/index.ru.html

# Replace xterm call with real path
find . -name *.lpi -print0 -o -name *.kof -print0 | xargs -0 -L 1 subst 's,[\\/]usr[\\/]\(X11R6[\\/]\)\?bin[\\/]\(xterm\|gnome-terminal\),/usr/bin/xterm,'

%build
MAKEOPTS="-Fl/opt/gnome/lib"
if [ -n "$FPCCfg" ]; then
  MAKEOPTS="$MAKEOPTS -n @$FPCCfg"
fi
#CHMHELP:MAKEOPTS="$MAKEOPTS -dUseCHMHelp"

# Put SVN revision into revision.inc
echo "const RevisionStr = '%rev';" > ide/revision.inc

# Make IDE
make bigide OPT="$MAKEOPTS" USESVN2REVISIONINC=0

# Make other program and utilites
sed -e "s#__LAZARUSDIR__#%{cfg}#" tools/install/linux/environmentoptions.xml > environmentoptions.xml

# Build apiwizz
make -C tools/apiwizz/

# Build explorateur_lrs
./lazbuild --ws="$LCL_PLATFORM" --pcp=%cfg tools/explorateur_lrs/LRS_Explorer.lpr
mv tools/explorateur_lrs/release/* tools/explorateur_lrs
rm -rf tools/explorateur_lrs/release/

# Build lazdatadesktop
mkdir -p tools/lazdatadesktop/lib
./lazbuild --ws="$LCL_PLATFORM" --pcp=%cfg tools/lazdatadesktop/lazdatadesktop.lpr

# Generate documentation
pushd docs/html
../../lazbuild --ws="$LCL_PLATFORM" --pcp=%cfg build_lcl_docs.lpi
sh build_html.sh
popd

export LCL_PLATFORM=
#export LCL_PLATFORM=gtk2
#export FPCDIR=%%_libdir/fpc
strip lazarus
strip startlazarus
strip lazbuild
strip tools/lazres
strip tools/updatepofiles
strip tools/lrstolfm
strip tools/svn2revisioninc
if [ -f components/chmhelp/lhelp/lhelp ]; then
  strip components/chmhelp/lhelp/lhelp
fi

rm -f environmentoptions.xml

%install
LAZARUSDIR=%_libdir/%name
mkdir -p %{buildroot}$LAZARUSDIR
mkdir -p %{buildroot}%{_bindir}
mkdir -p %{buildroot}%{_datadir}/pixmaps
mkdir -p %{buildroot}%{_datadir}/applications
mkdir -p %{buildroot}%{_datadir}/mime/packages
mkdir -p %{buildroot}%{_mandir}/man1
mkdir -p %{buildroot}%{_sysconfdir}/lazarus
cp -a * %{buildroot}$LAZARUSDIR/
install -m 644 images/icons/lazarus128x128.png %{buildroot}%{_datadir}/pixmaps/lazarus.png
install -m 644 install/lazarus.desktop %{buildroot}%{_datadir}/applications/lazarus.desktop
install -m 644 install/lazarus-mime.xml $LazBuildDir%{buildroot}%{_datadir}/mime/packages/lazarus.xml
ln -sf $LAZARUSDIR/lazarus %{buildroot}%{_bindir}/lazarus-ide
ln -sf lazarus-ide %{buildroot}%{_bindir}/lazarus
ln -sf $LAZARUSDIR/startlazarus %{buildroot}%{_bindir}/startlazarus
ln -sf $LAZARUSDIR/lazbuild %{buildroot}%{_bindir}/lazbuild
ln -sf $LAZARUSDIR/tools/explorateur_lrs/LRS_Explorer %buildroot%_bindir/LRS_Explorer
ln -sf $LAZARUSDIR/tools/explorateur_lrs/LRS_Explorer %buildroot%_bindir/lrsexplorer
ln -sf $LAZARUSDIR/tools/apiwizz/apiwizz %buildroot%_bindir/apiwizz
ln -sf $LAZARUSDIR/tools/lazres %buildroot%_bindir/lazres
ln -sf $LAZARUSDIR/tools/lrstolfm %buildroot%_bindir/lrstolfm
ln -sf $LAZARUSDIR/tools/svn2revisioninc %buildroot%_bindir/svn2revisioninc
ln -sf $LAZARUSDIR/tools/updatepofiles %buildroot%_bindir/updatepofiles
ln -sf $LAZARUSDIR/tools/lazdatadesktop/lazdatadesktop %buildroot%_bindir/lazdatadesktop
cat install/man/man1/lazbuild.1 | gzip > %{buildroot}%{_mandir}/man1/lazbuild.1.gz
cat install/man/man1/lazarus-ide.1 | gzip > %{buildroot}%{_mandir}/man1/lazarus-ide.1.gz
cat install/man/man1/startlazarus.1 | gzip > %{buildroot}%{_mandir}/man1/startlazarus.1.gz
install tools/install/linux/editoroptions.xml %{buildroot}%{_sysconfdir}/lazarus/editoroptions.xml
cat tools/install/linux/environmentoptions.xml | sed -e "s#__LAZARUSDIR__#$LAZARUSDIR/#" -e "s#__FPCSRCDIR__#%{_datadir}/fpcsrc/#" > %{buildroot}%{_sysconfdir}/lazarus/environmentoptions.xml

# fix bug 13256
mkdir -p %buildroot%_datadir/fpcsrc/packages/fcl-base
mkdir -p %buildroot%_datadir/fpcsrc/rtl/inc

# fix navigate to line with error (see https://bugs.altlinux.org/25991#c20)
install -D -p -m 0644 %SOURCE4 %buildroot%_sysconfdir/lazarus/projectoptions.xml
subst 's|/usr/lib/|%{_libdir}/|' %buildroot%_sysconfdir/lazarus/projectoptions.xml

#Docs
mv docs/index.html docs/index.en.html
#mv docs/index.ru.html docs/index.html

# cleanup installation
rm -rf %buildroot$LAZARUSDIR/debian
rm -rf %buildroot$LAZARUSDIR/tools/install
rm -rf %buildroot$LAZARUSDIR/localize.bat

# generate correct compilertest.pas
echo -e "begin\nend." > %buildroot$LAZARUSDIR/compilertest.pas

%files
%_libdir/%name
%_bindir/*
%_sysconfdir/%name/*
%_mandir/*/*
%_pixmapsdir/lazarus.png
%_desktopdir/lazarus.desktop
%_datadir/mime/packages/lazarus.xml
%_man1dir/*
# fix bug 13256
%dir %_datadir/fpcsrc/rtl/inc
%dir %_datadir/fpcsrc/packages/fcl-base

%changelog
