Name: leafnode
Version: 1.11.8
Release: alt1.qa1

Summary: Leafnode - a leafsite NNTP server
License: Artistic
Group: System/Servers

Url: http://www.leafnode.org
Source: ftp://wpxx02.toxi.uni-wuerzburg.de/pub/%name-%version.tar.bz2
Source1: %name.texpire
Source2: %name.filters
Source3: %name.xinetd
Packager: Michael Shigorin <mike@altlinux.org>

Summary(ru_RU.KOI8-R): Leafnode -  NNTP-
Summary(uk_UA.KOI8-U): Leafnode -  NNTP-

# NOTE: buildreq would catch %_sbindir/tcpd from and add tcp_wrappers :-/
# So don't run that on this. -- mike

BuildRequires: libpcre-devel
Conflicts: inn

%define nntp_server news.talk.ru
%define leafgroup news
%define leafuser news

%description
Leafnode is a small NNTP server for leaf sites without permanent
connection to the internet. It supports a subset of NNTP and is able to
automatically fetch the newsgroups the user reads regularly from the
newsserver of the ISP and push the posted messages.

%description -l ru_RU.KOI8-R
Leafnode -  NNTP-  ""   
   Internet.     NNTP
       
   news- .

%description -l uk_UA.KOI8-U
Leafnode -  NNTP-  "Φ"   צԦ
Ԧ '  Internet.   Цդ Ц NNTP 
Ѥ      צ  
 news- .

%prep
%setup

%build
%configure \
	--sysconfdir=%_sysconfdir/%name \
	--with-spooldir=%_spooldir/news \
	--with-lockfile=%_lockdir/news/fetchnews.lck
%make_build

%install
install -d %buildroot%_sysconfdir/{cron.daily,leafnode}
# carefully working around horrors in Makefile...
make INSTALL="install -p" \
        prefix=%buildroot%prefix \
	SPOOLDIR=%_spooldir/news \
	LOCKFILE=%buildroot%_lockdir/news/fetchnews.lck \
	DESTDIR=%buildroot \
	install

install -pDm600 filters.example %buildroot%_sysconfdir/leafnode/filters
install -pDm755 %SOURCE1 %buildroot%_sysconfdir/cron.daily/texpire
install -pDm644 %SOURCE3 %buildroot%_sysconfdir/xinetd.d/%name

sed \
	-e 's,news.hiof.no,%nntp_server,g' \
	-e 's,^# maxfetch,maxfetch,g' \
	-e 's,^# initialfetch,initialfetch,g' \
	-e 's,^# allow_8bit_headers,allow_8bit_headers,g' \
	< config.example \
	> %buildroot%_sysconfdir/leafnode/config

%post
# get hostname to config -- works for first time
grep -qF host.domain.country %_sysconfdir/%name/config && {
	SERVERNAME=`hostname`
	[ -z "$SERVERNAME" ] && SERVERNAME="localhost"
	TMP=`mktemp -q leafnode-config-XXXXXXXXXX`
	[ $? = 0 ] && sed -e "s,host.domain.country,$SERVERNAME,g" \
		< %_sysconfdir/%name/config \
		> $TMP && \
		cat $TMP > %_sysconfdir/%name/config && rm $TMP
} || :

# force spool perms in case of upgrade (since 1.9.38-alt1)
chown -R %leafuser.%leafgroup %_spooldir/news/
chmod -R u=rwX,go=rX %_spooldir/news/

# NB:
# - we don't need run.*.dist examples -- using xinetd
# - the same with nntp.rules.dist

# TODO
# - use %leafgroup for texpire?
# - config dir should be better guarded probably? (or not?)

%files
%_mandir/man?/*
%doc ADD-ONS CREDITS INSTALL KNOWNBUGS NEWS *README* FAQ.html FAQ.txt
%doc tools/archivefaq.pl update.sh
%dir %_sysconfdir/%name/
%config(noreplace) %verify(not size mtime md5) %_sysconfdir/xinetd.d/%name
%attr(755,root,root) %config(noreplace) %_sysconfdir/cron.daily/texpire
%attr(640,root,%leafgroup) %config(noreplace) %_sysconfdir/%name/config
%attr(640,root,%leafgroup) %config(noreplace) %_sysconfdir/%name/filters
%attr(710,root,%leafgroup) %_sbindir/*
%attr (775,root,%leafgroup) %_lockdir/news
%attr (755,%leafuser,%leafgroup) %_spooldir/news
%_bindir/*

%changelog
