Name: lftp
Version: 4.4.9
Release: alt1

Summary: Sophisticated command line file transfer program
License: GPLv3+
Group: Networking/File transfer
Url: http://lftp.yar.ru/

# ftp://ftp.yars.free.net/pub/source/lftp/lftp-%version.tar.xz
Source: lftp-%version.tar
Source1: lftp-l.xpm
Source2: lftp-m.xpm
Source3: lftp-n.xpm
Source4: lftp.desktop
Source5: lftpget.1

# http://git.altlinux.org/gears/l/lftp.git
Patch: lftp-%version-%release.patch

# Due to default pager.
Requires: less

# Automatically added by buildreq on Thu Jan 02 2003
BuildRequires: desktop-file-utils gcc-c++ libexpat-devel libncurses-devel libreadline-devel libssl-devel zlib-devel

%description
lftp is sophisticated file transfer program with command-line
interface.  It supports the FTP, HTTP, HTTPS, SFTP, FISH, and
BitTorrent protocols, advanced and obscure features of the protocols,
proxy servers, automatic retries on non-fatal errors and timeouts,
continuation of interrupted file transfers, mirroring, transfer rate
throttling, multiple connections and background jobs, shell-like
command syntax and comprehensive scripting, command-line editing
(via the GNU Readline library), context-sensitive command completion,
command history, and a lot more.

%prep
%setup
%patch -p1
sed -i 's/curses\.h term\.h/term\.h curses\.h/' m4/terminfo.m4
bzip2 -9k NEWS src/ChangeLog

%build
%def_with openssl
%def_with modules
export CXX=%__cxx
%autoreconf
%configure \
	%{subst_with openssl} \
	%{subst_with modules} \
	--with-pager='exec less' \
	#
%make_build

%install
%makeinstall_std
%{?_with_modules:find %buildroot%_libdir/lftp/ -type f -name \*.la -delete}

install -pm644 %_sourcedir/lftpget.1 %buildroot%_man1dir/
install -pDm644 %_sourcedir/lftp-l.xpm %buildroot%_liconsdir/lftp.xpm
install -pDm644 %_sourcedir/lftp-m.xpm %buildroot%_miconsdir/lftp.xpm
install -pDm644 %_sourcedir/lftp-n.xpm %buildroot%_niconsdir/lftp.xpm

desktop-file-install --dir %buildroot%_desktopdir %_sourcedir/lftp.desktop

%find_lang %name
%set_verify_elf_method strict,rpath=normal
%add_findreq_skiplist %_datadir/lftp/convert-mozilla-cookies
%add_findreq_skiplist %_datadir/lftp/verify-file

%files -f %name.lang
%config(noreplace) %_sysconfdir/lftp.conf
%_bindir/*
%_libdir/liblftp*.so*
%{?_with_modules:%_libdir/lftp}
%_datadir/lftp
%_mandir/man?/*
%_desktopdir/lftp.desktop
%_liconsdir/*.xpm
%_miconsdir/*.xpm
%_niconsdir/*.xpm
%doc src/ChangeLog.bz2 F* MIRRORS NEWS.bz2
%doc AUTHORS README.* THANKS TODO lftp.lsm BUGS

%changelog
