%define origname GeoIP

# due to hasher network isolation
%def_disable check

Name: lib%{origname}
Version: 1.5.0
Release: alt1

Summary: GeoIP is a C library find what country an IP address or hostname originates from
License: LGPLv2.1+
Group: System/Libraries

URL: http://www.maxmind.com/app/c
Source: http://geolite.maxmind.com/download/geoip/api/c/%origname-%version.tar.gz

# Automatically added by buildreq on Sun Apr 17 2011
BuildRequires: zlib-devel

# Both library and lookup tools unusable without database. But user can choose
# to get this file directly from MaxMind site, without installing our packaged
# GeoIP database. Hence this is file rather than package requirement.
Requires: /usr/share/GeoIP/GeoIP.dat

%description
%origname is a C library that enables the user to find the country that any IP
address or hostname originates from. It uses a file based database that is
accurate as of March 2003. This database simply contains IP blocks as keys,
and countries as values. This database should be more complete and accurate
than using reverse DNS lookups. Commercial databases and automatic update
services are available from http://www.maxmind.com/

This module can be used to automatically select the geographically closest
mirror, to analyze your web server logs to determine the countries of your
visitors, for credit card fraud detection, and for software export controls.

%package devel
Summary: GeoIP headers, libraries
Group: Development/C
Requires: %name = %version-%release

%description devel
%origname is a C library that enables the user to find the country that
any IP address or hostname originates from.

This package contain the devel files for %origname.

%package tools
Summary: GeoIP tools
Group: System/Libraries
Requires: %name = %version-%release

%description tools
%origname is a C library that enables the user to find the country that
any IP address or hostname originates from.

This package contain few tools for %origname such as lookup, export,
autoupdate.

%prep
%setup -n %origname-%version

%build
%autoreconf
%configure --disable-static
%make_build

%check
make check

%install
%makeinstall_std

%files
%config(noreplace) %_sysconfdir/GeoIP.conf
%exclude %_sysconfdir/GeoIP.conf.default
%_libdir/*.so.*
# GeoIP databases updated way more often than library itself. So we will not
# package DB files
%exclude %_datadir/%origname

%files devel
%doc ChangeLog
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/geoip.pc

%files tools
%_bindir/*
%_man1dir/*

%changelog
