Name:           libHX
Version:        3.11
Release:        alt1
Summary:        General-purpose library for typical low-level operations

Group:          System/Libraries
License:        LGPLv2 or LGPLv3
URL:            http://jengelh.hopto.org/files/libHX/
Source0:        libHX-%{version}.tar
BuildRequires:  gcc-c++ gcc-fortran glibc-devel-static lyx
Packager: Anton V. Boyarshinov <boyarsh@altlinux.org>

%description
A library for:
- rbtree with key-value pair extension
- deques (double-ended queues) (Stacks (LIFO) / Queues (FIFOs))
- platform independent opendir-style directory access
- platform independent dlopen-style shared library access
- auto-storage strings with direct access
- command line option (argv) parser
- shconfig-style config file parser
- platform independent random number generator with transparent
  /dev/urandom support
- various string, memory and zvec ops


%package        devel
Summary:        Development files for %{name}
Group:          Development/C
Requires:       %{name} = %{version}-%{release}
Requires:       pkgconfig

%description    devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.


%prep
%setup -q


%build
# Move libHX.so.* to /%{_lib}:
# /sbin/mount.crypt from pam_mount uses libHX
# /lib/security/pam_mount.so from pam_mount uses libHX
%autoreconf
%configure --libdir=/%_lib
export echo=echo
%make_build


%install
export echo=echo
%makeinstall
mkdir -p %buildroot/%_lib/
mv %buildroot/%_libdir/*so* %buildroot/%_lib/
subst 's|libdir=/usr|libdir=|' %buildroot/%_libdir/pkgconfig/libHX.pc

%files
/%{_lib}/*.so.*

%files devel
%defattr(-,root,root,-)
%doc doc/* README.txt
%{_includedir}/*
/%{_lib}/*.so
%{_libdir}/pkgconfig/libHX.pc


%changelog
